/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.item;

import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.betterx.bclib.items.BaseArmorItem;
import org.betterx.betterend.effects.EndStatusEffects;
import org.betterx.betterend.item.material.EndArmorMaterial;

public class CrystaliteArmor
extends BaseArmorItem {
    public static final MutableComponent CHEST_DESC;
    public static final MutableComponent BOOTS_DESC;

    public CrystaliteArmor(ArmorItem.Type type, Item.Properties settings) {
        super(EndArmorMaterial.CRYSTALITE, type, settings);
    }

    public static boolean hasFullSet(LivingEntity owner) {
        for (ItemStack armorStack : owner.getArmorSlots()) {
            if (armorStack.getItem() instanceof CrystaliteArmor) continue;
            return false;
        }
        return true;
    }

    public static void applySetEffect(LivingEntity owner) {
        if ((owner.tickCount & 0x3F) == 0) {
            owner.addEffect(new MobEffectInstance(EndStatusEffects.CRYSTALITE_HEALTH_REGEN));
        }
    }

    static {
        Style descStyle = Style.EMPTY.applyFormats(new ChatFormatting[]{ChatFormatting.DARK_AQUA, ChatFormatting.ITALIC});
        CHEST_DESC = Component.translatable((String)"tooltip.armor.crystalite_chest");
        CHEST_DESC.setStyle(descStyle);
        BOOTS_DESC = Component.translatable((String)"tooltip.armor.crystalite_boots");
        BOOTS_DESC.setStyle(descStyle);
    }
}

