/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.item;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import org.betterx.bclib.items.BaseArmorItem;
import org.betterx.betterend.BetterEnd;
import org.betterx.betterend.interfaces.BetterEndElytra;
import org.betterx.betterend.interfaces.MultiModelItem;
import org.betterx.betterend.item.EndArmorItem;
import org.betterx.wover.complex.api.equipment.ArmorSlot;
import org.betterx.wover.complex.api.equipment.ArmorTier;
import org.betterx.wover.item.api.ItemTagProvider;
import org.betterx.wover.tag.api.event.context.ItemTagBootstrapContext;

public class ArmoredElytra
extends BaseArmorItem
implements MultiModelItem,
BetterEndElytra,
ItemTagProvider {
    private final ResourceLocation wingTexture;
    private final Item repairItem;
    private final double movementFactor;
    private final float toughness;
    private final int defense;

    private static Item.Properties defaultSettings(ArmorTier material, int durability, float defenseDivider, float toughnessDivider, boolean fireproof) {
        float defense = (float)((ArmorMaterial)material.armorMaterial.value()).getDefense(ArmorItem.Type.CHESTPLATE) / defenseDivider;
        float toughness = ((ArmorMaterial)material.armorMaterial.value()).toughness() / toughnessDivider;
        Item.Properties props = EndArmorItem.createDefaultEndArmorSettings(ArmorSlot.CHESTPLATE_SLOT, material, EndArmorItem.startAttributeBuilder(ArmorSlot.CHESTPLATE_SLOT, material, (int)defense, toughness, 0.5f).build()).rarity(Rarity.EPIC).durability(durability);
        if (fireproof) {
            props.fireResistant();
        }
        return props;
    }

    public ArmoredElytra(String name, ArmorTier material, Item repairItem, int durability, double movementFactor, float defenseDivider, float toughnessDivider, boolean fireproof) {
        super(material.armorMaterial, ArmorItem.Type.CHESTPLATE, ArmoredElytra.defaultSettings(material, durability, defenseDivider, toughnessDivider, fireproof));
        this.wingTexture = BetterEnd.C.mk("textures/entity/" + name + ".png");
        this.repairItem = repairItem;
        this.movementFactor = movementFactor;
        this.defense = (int)((float)((ArmorMaterial)material.armorMaterial.value()).getDefense(ArmorItem.Type.CHESTPLATE) / defenseDivider);
        this.toughness = ((ArmorMaterial)material.armorMaterial.value()).toughness() / toughnessDivider;
    }

    public double getMovementFactor() {
        return this.movementFactor;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public ResourceLocation getModelTexture() {
        return this.wingTexture;
    }

    public boolean isValidRepairItem(ItemStack itemStack, ItemStack itemStack2) {
        return super.isValidRepairItem(itemStack, itemStack2) || itemStack2.getItem() == this.repairItem;
    }

    public int getDefense() {
        return this.defense;
    }

    public float getToughness() {
        return this.toughness;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void registerModelPredicate() {
        ItemProperties.register((Item)this, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"broken"), (itemStack, clientLevel, livingEntity, id) -> ElytraItem.isFlyEnabled((ItemStack)itemStack) ? 0.0f : 1.0f);
    }

    public void registerItemTags(ResourceLocation location, ItemTagBootstrapContext context) {
        context.add((Object)this, new TagKey[]{ItemTags.DURABILITY_ENCHANTABLE, ItemTags.EQUIPPABLE_ENCHANTABLE});
    }
}

