/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.integration.trinkets;

import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketsApi;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.entity.event.v1.EntityElytraEvents;
import net.fabricmc.fabric.api.entity.event.v1.FabricElytraItem;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.betterx.bclib.items.elytra.BCLElytraItem;
import org.betterx.bclib.items.elytra.BCLElytraUtils;

public class Elytra {
    private static boolean isElytra(ItemStack stack) {
        return stack.getItem() instanceof ElytraItem || stack.getItem() instanceof FabricElytraItem;
    }

    public static void register() {
        BCLElytraUtils.slotProvider = (entity, slotGetter) -> {
            List equipped;
            ItemStack itemStack = (ItemStack)slotGetter.apply(EquipmentSlot.CHEST);
            if (Elytra.isElytra(itemStack)) {
                return itemStack;
            }
            Optional oTrinketComponent = TrinketsApi.getTrinketComponent((LivingEntity)entity);
            if (oTrinketComponent.isPresent() && !(equipped = ((TrinketComponent)oTrinketComponent.get()).getEquipped(Elytra::isElytra)).isEmpty()) {
                return (ItemStack)((Tuple)equipped.get(0)).getB();
            }
            return null;
        };
        BCLElytraUtils.onBreak = (entity, chestStack) -> {
            Optional oTrinketComponent = TrinketsApi.getTrinketComponent((LivingEntity)entity);
            if (oTrinketComponent.isPresent()) {
                List equipped = ((TrinketComponent)oTrinketComponent.get()).getEquipped(Elytra::isElytra);
                for (Tuple slot : equipped) {
                    ItemStack slotStack = (ItemStack)slot.getB();
                    if (slotStack != chestStack) continue;
                    TrinketsApi.onTrinketBroken((ItemStack)slotStack, (SlotReference)((SlotReference)slot.getA()), (LivingEntity)entity);
                }
            }
        };
        EntityElytraEvents.CUSTOM.register(Elytra::useElytraTrinket);
    }

    private static boolean useElytraTrinket(LivingEntity entity, boolean tickElytra) {
        Optional oTrinketComponent = TrinketsApi.getTrinketComponent((LivingEntity)entity);
        if (oTrinketComponent.isPresent()) {
            List equipped = ((TrinketComponent)oTrinketComponent.get()).getEquipped(Elytra::isElytra);
            for (Tuple slot : equipped) {
                FabricElytraItem fabricElytraItem;
                ItemStack stack = (ItemStack)slot.getB();
                Item item = stack.getItem();
                if (item instanceof ElytraItem) {
                    if (!ElytraItem.isFlyEnabled((ItemStack)stack)) continue;
                    BCLElytraItem.vanillaElytraTick((LivingEntity)entity, (ItemStack)stack);
                    return true;
                }
                if (!(item instanceof FabricElytraItem) || !(fabricElytraItem = (FabricElytraItem)item).useCustomElytra(entity, stack, tickElytra)) continue;
                return true;
            }
        }
        return false;
    }
}

