/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.integration.rei;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.plugin.common.BuiltinPlugin;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.fabricmc.fabric.impl.content.registry.FuelRegistryImpl;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import org.betterx.bclib.blocks.BaseFurnaceBlock;
import org.betterx.bclib.recipes.AlloyingRecipe;
import org.betterx.bclib.recipes.AnvilRecipe;
import org.betterx.betterend.BetterEnd;
import org.betterx.betterend.blocks.basis.EndAnvilBlock;
import org.betterx.betterend.integration.rei.REIAlloyingCategory;
import org.betterx.betterend.integration.rei.REIAlloyingDisplay;
import org.betterx.betterend.integration.rei.REIAlloyingFuelCategory;
import org.betterx.betterend.integration.rei.REIAlloyingFuelDisplay;
import org.betterx.betterend.integration.rei.REIAnvilCategory;
import org.betterx.betterend.integration.rei.REIAnvilDisplay;
import org.betterx.betterend.integration.rei.REIBlastingDisplay;
import org.betterx.betterend.integration.rei.REIInfusionCategory;
import org.betterx.betterend.integration.rei.REIInfusionDisplay;
import org.betterx.betterend.recipe.builders.InfusionRecipe;
import org.betterx.betterend.registry.EndBlocks;

public class REIPlugin
implements REIClientPlugin {
    public static final ResourceLocation PLUGIN_ID = BetterEnd.C.mk("rei_plugin");
    public static final CategoryIdentifier<REIAlloyingFuelDisplay> ALLOYING_FUEL = CategoryIdentifier.of((String)BetterEnd.MOD_ID, (String)"alloying_fuel");
    public static final CategoryIdentifier<REIAlloyingDisplay> ALLOYING = CategoryIdentifier.of((String)BetterEnd.MOD_ID, (String)"alloying");
    public static final CategoryIdentifier<REIAnvilDisplay> SMITHING = CategoryIdentifier.of((String)BetterEnd.MOD_ID, (String)AnvilRecipe.ID.getPath());
    public static final CategoryIdentifier<REIInfusionDisplay> INFUSION = CategoryIdentifier.of((String)BetterEnd.MOD_ID, (String)"infusion");

    public void registerDisplays(DisplayRegistry registry) {
        registry.registerRecipeFiller(AlloyingRecipe.class, AlloyingRecipe.TYPE, REIAlloyingDisplay::new);
        registry.registerRecipeFiller(BlastingRecipe.class, RecipeType.BLASTING, REIBlastingDisplay::new);
        registry.registerRecipeFiller(AnvilRecipe.class, AnvilRecipe.TYPE, REIAnvilDisplay::new);
        registry.registerRecipeFiller(InfusionRecipe.class, InfusionRecipe.TYPE, REIInfusionDisplay::new);
        FuelRegistry fuelRegistry = FuelRegistry.INSTANCE;
        if (fuelRegistry instanceof FuelRegistryImpl) {
            FuelRegistryImpl fabricImpl = (FuelRegistryImpl)fuelRegistry;
            fabricImpl.getFuelTimes().forEach((item, time) -> {
                if (time >= 2000) {
                    List<EntryIngredient> list = Collections.singletonList(EntryIngredients.of((ItemLike)item));
                    registry.add((Display)new REIAlloyingFuelDisplay(list, (int)time));
                }
            });
        }
    }

    public void registerCategories(CategoryRegistry registry) {
        EntryStack endStoneSmelter = EntryStacks.of((ItemLike)EndBlocks.END_STONE_SMELTER);
        EntryStack infusionRitual = EntryStacks.of((ItemLike)EndBlocks.INFUSION_PEDESTAL);
        ArrayList anvils = Lists.newArrayList((Iterable)EntryIngredients.ofItems((Collection)EndBlocks.getModBlocks().stream().filter(EndAnvilBlock.class::isInstance).collect(Collectors.toList())));
        anvils.add(0, EntryStacks.of((ItemLike)Blocks.ANVIL));
        ArrayList ITEM_FURNACES = Lists.newArrayList((Iterable)EntryIngredients.ofItems((Collection)EndBlocks.getModBlocks().stream().filter(BaseFurnaceBlock.class::isInstance).collect(Collectors.toList())));
        EntryStack[] anvilsArray = anvils.toArray(new EntryStack[0]);
        EntryStack[] ITEM_FURNACESArray = ITEM_FURNACES.toArray(new EntryStack[0]);
        registry.add(new DisplayCategory[]{new REIAlloyingFuelCategory(), new REIAlloyingCategory(endStoneSmelter), new REIInfusionCategory(infusionRitual), new REIAnvilCategory(anvilsArray)});
        registry.addWorkstations(ALLOYING_FUEL, new EntryStack[]{endStoneSmelter});
        registry.addWorkstations(ALLOYING, new EntryStack[]{endStoneSmelter});
        registry.addWorkstations(INFUSION, new EntryStack[]{infusionRitual});
        registry.addWorkstations(SMITHING, anvilsArray);
        registry.addWorkstations(BuiltinPlugin.SMELTING, ITEM_FURNACESArray);
        registry.addWorkstations(BuiltinPlugin.FUEL, ITEM_FURNACESArray);
    }
}

