/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.integration.rei;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.betterx.betterend.blocks.basis.EndAnvilBlock;
import org.betterx.betterend.integration.rei.REIAnvilDisplay;
import org.betterx.betterend.integration.rei.REIPlugin;
import org.jetbrains.annotations.NotNull;

public class REIAnvilCategory
implements DisplayCategory<REIAnvilDisplay> {
    private final EntryStack<?>[] ANVILS;

    REIAnvilCategory(EntryStack<?>[] anvils) {
        this.ANVILS = anvils;
    }

    public CategoryIdentifier<REIAnvilDisplay> getCategoryIdentifier() {
        return REIPlugin.SMITHING;
    }

    @NotNull
    public Component getTitle() {
        return Component.translatable((String)Blocks.ANVIL.getDescriptionId());
    }

    @NotNull
    public EntryStack<?> getIcon() {
        return this.ANVILS[0];
    }

    @NotNull
    public List<Widget> setupDisplay(REIAnvilDisplay display, Rectangle bounds) {
        Point startPoint = new Point(bounds.getCenterX() - 41, bounds.y + 10);
        ArrayList widgets = Lists.newArrayList();
        widgets.add(Widgets.createRecipeBase((Rectangle)bounds));
        int x = startPoint.x + 10;
        int y = startPoint.y;
        widgets.add(Widgets.createResultSlotBackground((Point)new Point(x + 61, y + 5)));
        List inputEntries = display.getInputEntries();
        EntryIngredient materials = (EntryIngredient)inputEntries.get(1);
        int anvilLevel = display.getAnvilLevel();
        List anvils = Arrays.stream(this.ANVILS).filter(anvil -> {
            Block block;
            Object value = anvil.getValue();
            if (value instanceof ItemStack) {
                value = ((ItemStack)value).getItem();
            }
            if ((block = ((BlockItem)value).getBlock()) instanceof EndAnvilBlock) {
                return ((EndAnvilBlock)block).getCraftingLevel() >= anvilLevel;
            }
            return anvilLevel == 1;
        }).collect(Collectors.toList());
        widgets.add(Widgets.createArrow((Point)new Point(x + 24, y + 4)));
        widgets.add(Widgets.createLabel((Point)new Point(bounds.x + bounds.width - 7, bounds.y + bounds.height - 15), (Component)Component.translatable((String)"category.rei.damage.amount&dmg", (Object[])new Object[]{display.getDamage()})).noShadow().rightAligned().color(-12566464, -4473925));
        widgets.add(Widgets.createSlot((Point)new Point(x - 20, y + 4)).entries((Collection)materials).markInput());
        widgets.add(Widgets.createSlot((Point)new Point(x + 1, y + 4)).entries((Collection)inputEntries.get(0)).markInput());
        widgets.add(Widgets.createSlot((Point)new Point(x + 61, y + 5)).entries((Collection)display.getOutputEntries().get(0)).disableBackground().markOutput());
        widgets.add(Widgets.createSlot((Point)new Point(x - 9, y + 25)).entries(anvils));
        return widgets;
    }

    public int getDisplayHeight() {
        return 60;
    }
}

