/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.integration.rei;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.SimpleGridMenuDisplay;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.betterx.bclib.recipes.AlloyingRecipe;
import org.betterx.betterend.blocks.entities.EndStoneSmelterBlockEntity;
import org.betterx.betterend.integration.rei.REIPlugin;
import org.jetbrains.annotations.NotNull;

public class REIAlloyingDisplay
extends BasicDisplay
implements SimpleGridMenuDisplay {
    private static final List<EntryStack> fuel = EndStoneSmelterBlockEntity.availableFuels().keySet().stream().map(Item::getDefaultInstance).map(EntryStacks::of).map(e -> e.setting(EntryStack.Settings.TOOLTIP_APPEND_EXTRA, stack -> Collections.singletonList(Component.translatable((String)"category.rei.smelting.fuel").withStyle(ChatFormatting.YELLOW)))).collect(Collectors.toList());
    private final RecipeHolder<AlloyingRecipe> recipe;
    private final float xp;
    private final double smeltTime;

    public REIAlloyingDisplay(RecipeHolder<AlloyingRecipe> recipe) {
        this(recipe, ((AlloyingRecipe)recipe.value()).getExperience(), ((AlloyingRecipe)recipe.value()).getSmeltTime());
    }

    protected REIAlloyingDisplay(RecipeHolder<AlloyingRecipe> recipe, float xp, double smeltTime) {
        super(EntryIngredients.ofIngredients((List)((AlloyingRecipe)recipe.value()).getIngredients()), Collections.singletonList(EntryIngredients.of((ItemStack)((AlloyingRecipe)recipe.value()).getResultItem((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess()))));
        this.recipe = recipe;
        this.xp = xp;
        this.smeltTime = smeltTime;
    }

    public static List<EntryStack> getFuel() {
        return fuel;
    }

    @NotNull
    public Optional<ResourceLocation> getDisplayLocation() {
        return Optional.ofNullable(this.recipe).map(RecipeHolder::id);
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return REIPlugin.ALLOYING;
    }

    public float getXp() {
        return this.xp;
    }

    public double getSmeltTime() {
        return this.smeltTime;
    }

    public Optional<RecipeHolder<?>> getOptionalRecipe() {
        return Optional.ofNullable(this.recipe);
    }

    public int getWidth() {
        return 2;
    }

    public int getHeight() {
        return 1;
    }
}

