/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.integration.emi;

import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import org.betterx.betterend.BetterEnd;
import org.betterx.betterend.integration.emi.EMIPlugin;
import org.betterx.betterend.recipe.builders.InfusionRecipe;
import org.betterx.ui.ColorUtil;
import org.betterx.wover.core.api.Logger;
import org.jetbrains.annotations.Nullable;

public class EMIInfusionRecipe
implements EmiRecipe {
    public static final EmiTexture BACKGROUND = new EmiTexture(BetterEnd.C.mk("textures/gui/infusion.png"), 0, 0, 84, 84, 84, 84, 84, 84);
    public final Component[] ORIENTATIONS = new Component[]{Component.translatable((String)"betterend.infusion.north").setStyle(Style.EMPTY.withColor(ColorUtil.GRAY)), Component.translatable((String)"betterend.infusion.north_east").setStyle(Style.EMPTY.withColor(ColorUtil.GRAY)), Component.translatable((String)"betterend.infusion.east").setStyle(Style.EMPTY.withColor(ColorUtil.GRAY)), Component.translatable((String)"betterend.infusion.south_east").setStyle(Style.EMPTY.withColor(ColorUtil.GRAY)), Component.translatable((String)"betterend.infusion.south").setStyle(Style.EMPTY.withColor(ColorUtil.GRAY)), Component.translatable((String)"betterend.infusion.south_west").setStyle(Style.EMPTY.withColor(ColorUtil.GRAY)), Component.translatable((String)"betterend.infusion.west").setStyle(Style.EMPTY.withColor(ColorUtil.GRAY)), Component.translatable((String)"betterend.infusion.north_west").setStyle(Style.EMPTY.withColor(ColorUtil.GRAY))};
    private final ResourceLocation id;
    private final List<EmiIngredient> input;
    private final List<EmiStack> output;

    public EMIInfusionRecipe(RecipeHolder<InfusionRecipe> recipe) {
        this.id = recipe.id();
        this.input = ((InfusionRecipe)recipe.value()).getIngredients().stream().map(EmiIngredient::of).toList();
        this.output = List.of(EmiStack.of((ItemStack)((InfusionRecipe)recipe.value()).getResultItem((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess())));
    }

    static void addAllRecipes(EmiRegistry emiRegistry, RecipeManager manager) {
        org.betterx.bclib.integration.emi.EMIPlugin.addAllRecipes((EmiRegistry)emiRegistry, (RecipeManager)manager, (Logger)BetterEnd.LOGGER, InfusionRecipe.TYPE, EMIInfusionRecipe::new);
    }

    public EmiRecipeCategory getCategory() {
        return EMIPlugin.INFUSION_CATEGORY;
    }

    @Nullable
    public ResourceLocation getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return this.input;
    }

    public List<EmiStack> getOutputs() {
        return this.output;
    }

    public int getDisplayWidth() {
        return 166;
    }

    public int getDisplayHeight() {
        return 108;
    }

    public void addWidgets(WidgetHolder widgets) {
        int radius = 36;
        int halfSize = 9;
        int left = 10;
        int top = 17;
        int cx = 52;
        int cy = 59;
        int right = 94;
        int bottom = 101;
        widgets.addTexture(BACKGROUND, 10, 17);
        widgets.addTexture(EmiTexture.EMPTY_ARROW, 104, 51);
        widgets.add((Widget)new SlotWidget(this.input.get(0), 43, 50));
        FormattedCharSequence str = FormattedCharSequence.forward((String)"N", (Style)Style.EMPTY);
        widgets.addText(str, 52 - Minecraft.getInstance().font.width(str) / 2, 4, ColorUtil.WHITE, true);
        double a = Math.PI;
        for (int i = 1; i < this.input.size(); ++i) {
            ((SlotWidget)widgets.add((Widget)new SlotWidget(this.input.get(i), 43 + (int)(Math.sin(a) * 36.0), 50 + (int)(Math.cos(a) * 36.0)))).appendTooltip(this.ORIENTATIONS[i - 1]);
            a -= 0.7853981633974483;
        }
        widgets.addSlot((EmiIngredient)this.output.get(0), 134, 46).large(true).recipeContext((EmiRecipe)this);
    }

    public boolean supportsRecipeTree() {
        return true;
    }
}

