/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.integration.byg.features;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import org.betterx.bclib.api.v2.levelgen.features.features.DefaultFeature;
import org.betterx.bclib.sdf.PosInfo;
import org.betterx.bclib.sdf.SDF;
import org.betterx.bclib.sdf.operator.SDFDisplacement;
import org.betterx.bclib.sdf.operator.SDFFlatWave;
import org.betterx.bclib.sdf.operator.SDFSmoothUnion;
import org.betterx.bclib.sdf.primitive.SDFCappedCone;
import org.betterx.bclib.sdf.primitive.SDFPrimitive;
import org.betterx.bclib.sdf.primitive.SDFSphere;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.bclib.util.MHelper;
import org.betterx.bclib.util.SplineHelper;
import org.betterx.betterend.integration.Integrations;
import org.betterx.wover.tag.api.predefined.CommonBlockTags;
import org.joml.Vector3f;

public class NightshadeRedwoodTreeFeature
extends DefaultFeature {
    private static final List<Vector3f> BRANCH = Lists.newArrayList((Object[])new Vector3f[]{new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.25f, 0.1f, 0.0f), new Vector3f(0.4f, 0.2f, 0.0f), new Vector3f(0.5f, 0.4f, 0.0f), new Vector3f(0.55f, 0.6f, 0.0f)});

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> featureConfig) {
        BlockPos p;
        int y;
        RandomSource random = featureConfig.random();
        BlockPos pos = featureConfig.origin();
        WorldGenLevel world = featureConfig.level();
        if (!world.getBlockState(pos.below()).is(CommonBlockTags.END_STONES)) {
            return false;
        }
        BlockState log = Integrations.BYG.getDefaultState("nightshade_log");
        BlockState wood = Integrations.BYG.getDefaultState("nightshade_wood");
        BlockState leaves = Integrations.BYG.getDefaultState("nightshade_leaves");
        BlockState leaves_flower = Integrations.BYG.getDefaultState("flowering_nightshade_leaves");
        Function<BlockPos, BlockState> splinePlacer = bpos -> log;
        Function<BlockState, Boolean> replace = state -> state.is(CommonBlockTags.END_STONES) || BlocksHelper.replaceableOrPlant((BlockState)state) != false;
        Function<PosInfo, BlockState> post = info -> {
            if (!(!info.getState().equals(log) || info.getStateUp().equals(log) && info.getStateDown().equals(log))) {
                return wood;
            }
            return info.getState();
        };
        Function<BlockState, Boolean> ignore = state -> state.equals(log) || state.equals(wood);
        int height = MHelper.randRange((int)40, (int)60, (RandomSource)random);
        List trunk = SplineHelper.makeSpline((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)height, (float)0.0f, (int)(height / 4));
        SplineHelper.offsetParts((List)trunk, (RandomSource)random, (float)0.8f, (float)0.0f, (float)0.8f);
        if (!SplineHelper.canGenerate((List)trunk, (BlockPos)pos, (WorldGenLevel)world, replace)) {
            return false;
        }
        int count = height >> 2;
        float start = (float)trunk.size() / 3.0f;
        float delta = (float)trunk.size() * 0.6f;
        float max = height - 7;
        float startAngle = random.nextFloat() * ((float)Math.PI * 2);
        for (int i = 0; i < count; ++i) {
            float scale = (float)(count - i) / (float)count * 15.0f;
            Vector3f offset = SplineHelper.getPos((List)trunk, (float)((float)i / (float)count * delta + start));
            if (offset.y() > max) break;
            List branch = SplineHelper.copySpline(BRANCH);
            SplineHelper.rotateSpline((List)branch, (float)((float)i * 1.3f + startAngle));
            SplineHelper.scale((List)branch, (float)scale);
            SplineHelper.offsetParts((List)branch, (RandomSource)random, (float)0.3f, (float)0.3f, (float)0.3f);
            SplineHelper.offset((List)branch, (Vector3f)offset);
            SplineHelper.fillSpline((List)branch, (WorldGenLevel)world, (BlockState)wood, (BlockPos)pos, replace);
        }
        SDF sdf = SplineHelper.buildSDF((List)trunk, (float)2.3f, (float)0.8f, splinePlacer);
        SDFPrimitive roots = new SDFSphere().setRadius(2.0f).setBlock(log);
        roots = new SDFFlatWave().setIntensity(2.0f).setRaysCount(MHelper.randRange((int)5, (int)7, (RandomSource)random)).setAngle(random.nextFloat() * ((float)Math.PI * 2)).setSource((SDF)roots);
        sdf = new SDFSmoothUnion().setRadius(2.0f).setSourceA(sdf).setSourceB((SDF)roots);
        sdf.setReplaceFunction(replace).addPostProcess(post).fillRecursive((ServerLevelAccessor)world, pos);
        Vector3f last = SplineHelper.getPos((List)trunk, (float)((float)trunk.size() - 1.35f));
        for (y = 0; y < 8; ++y) {
            p = pos.offset((int)((double)last.x() + 0.5), (int)(last.y() + (float)y), (int)((double)last.z() + 0.5));
            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)p, (BlockState)(y == 4 ? wood : log));
        }
        for (y = 0; y < 16; ++y) {
            p = pos.offset((int)((double)last.x() + 0.5), (int)(last.y() + (float)y), (int)((double)last.z() + 0.5));
            if (world.isEmptyBlock(p)) {
                BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)p, (BlockState)leaves);
            }
            float radius = (1.0f - (float)y / 16.0f) * 3.0f;
            int rad = (int)(radius + 1.0f);
            radius *= radius;
            for (int x = -rad; x <= rad; ++x) {
                int x2 = x * x;
                for (int z = -rad; z <= rad; ++z) {
                    BlockPos lp;
                    int z2 = z * z;
                    if (!((float)(x2 + z2) < radius - random.nextFloat() * (float)rad) || !world.isEmptyBlock(lp = p.offset(x, 0, z))) continue;
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)lp, (BlockState)leaves);
                }
            }
        }
        BlockPos.MutableBlockPos mut = new BlockPos.MutableBlockPos();
        Function<PosInfo, BlockState> leavesPost1 = info -> {
            if (info.getState().equals(log) || info.getState().equals(wood)) {
                for (int x = -6; x < 7; ++x) {
                    int ax = Math.abs(x);
                    mut.setX(x + info.getPos().getX());
                    for (int z = -6; z < 7; ++z) {
                        int az = Math.abs(z);
                        mut.setZ(z + info.getPos().getZ());
                        for (int y = -6; y < 7; ++y) {
                            int distance;
                            int ay = Math.abs(y);
                            int d = ax + ay + az;
                            if (d >= 7) continue;
                            mut.setY(y + info.getPos().getY());
                            BlockState state = info.getState((BlockPos)mut);
                            if (!(state.getBlock() instanceof LeavesBlock) || d >= (distance = ((Integer)state.getValue((Property)LeavesBlock.DISTANCE)).intValue())) continue;
                            info.setState((BlockPos)mut, (BlockState)state.setValue((Property)LeavesBlock.DISTANCE, (Comparable)Integer.valueOf(d)));
                        }
                    }
                }
            }
            return info.getState();
        };
        Function<PosInfo, BlockState> leavesPost2 = info -> {
            if (info.getState().getBlock() instanceof LeavesBlock) {
                int distance = (Integer)info.getState().getValue((Property)LeavesBlock.DISTANCE);
                if (distance > MHelper.randRange((int)2, (int)4, (RandomSource)random)) {
                    return Blocks.AIR.defaultBlockState();
                }
                int airCount = 0;
                for (Direction d : BlocksHelper.DIRECTIONS) {
                    if (info.getState(d).isAir()) {
                        ++airCount;
                    }
                    if (airCount <= 5) continue;
                    return Blocks.AIR.defaultBlockState();
                }
                if (random.nextInt(8) == 0) {
                    return (BlockState)leaves_flower.setValue((Property)LeavesBlock.DISTANCE, (Comparable)Integer.valueOf(distance));
                }
            }
            return info.getState();
        };
        SDFPrimitive canopy = new SDFCappedCone().setRadius1(12.0f).setRadius2(1.0f).setHeight((float)height * 0.3f).setBlock(leaves);
        canopy = new SDFDisplacement().setFunction(vec -> Float.valueOf(MHelper.randRange((float)-3.0f, (float)3.0f, (RandomSource)random))).setSource((SDF)canopy);
        canopy.addPostProcess(leavesPost1).addPostProcess(leavesPost2).fillRecursiveIgnore((ServerLevelAccessor)world, pos.offset(0, (int)((double)height * 0.75), 0), ignore);
        return true;
    }
}

