/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.integration.byg.features;

import com.google.common.base.Function;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import org.betterx.bclib.api.v2.levelgen.features.features.DefaultFeature;
import org.betterx.bclib.sdf.SDF;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.bclib.util.MHelper;
import org.betterx.bclib.util.SplineHelper;
import org.betterx.betterend.integration.Integrations;
import org.betterx.wover.tag.api.predefined.CommonBlockTags;
import org.joml.Vector3f;

public class BigEtherTreeFeature
extends DefaultFeature {
    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> featureConfig) {
        RandomSource random = featureConfig.random();
        BlockPos pos = featureConfig.origin();
        WorldGenLevel world = featureConfig.level();
        if (!world.getBlockState(pos.below()).is(CommonBlockTags.END_STONES)) {
            return false;
        }
        BlockState log = Integrations.BYG.getDefaultState("ether_log");
        BlockState wood = Integrations.BYG.getDefaultState("ether_wood");
        Function splinePlacer = bpos -> log;
        Function replace = state -> state.is(CommonBlockTags.END_STONES) || BlocksHelper.replaceableOrPlant((BlockState)state) != false;
        int height = MHelper.randRange((int)40, (int)60, (RandomSource)random);
        List trunk = SplineHelper.makeSpline((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)height, (float)0.0f, (int)(height / 4));
        SplineHelper.offsetParts((List)trunk, (RandomSource)random, (float)2.0f, (float)0.0f, (float)2.0f);
        SDF sdf = SplineHelper.buildSDF((List)trunk, (float)2.3f, (float)0.8f, (java.util.function.Function)splinePlacer);
        int count = height / 15;
        for (int i = 1; i < count; ++i) {
            float length;
            float splinePos = (float)i / (float)count;
            float startAngle = random.nextFloat() * ((float)Math.PI * 2);
            int points = (int)((length = (1.0f - splinePos) * (float)height * 0.4f) / 3.0f);
            List branch = SplineHelper.makeSpline((float)0.0f, (float)0.0f, (float)0.0f, (float)length, (float)0.0f, (float)0.0f, (int)(points < 2 ? 2 : points));
            SplineHelper.powerOffset((List)branch, (float)length, (float)2.0f);
            int rotCount = MHelper.randRange((int)5, (int)7, (RandomSource)random);
            Vector3f start = SplineHelper.getPos((List)trunk, (float)(splinePos * (float)(trunk.size() - 1)));
            for (int j = 0; j < rotCount; ++j) {
                float angle = startAngle + (float)j / (float)rotCount * ((float)Math.PI * 2);
                List br = SplineHelper.copySpline((List)branch);
                SplineHelper.offsetParts((List)br, (RandomSource)random, (float)0.0f, (float)1.0f, (float)1.0f);
                SplineHelper.rotateSpline((List)br, (float)angle);
                SplineHelper.offset((List)br, (Vector3f)start);
                SplineHelper.fillSpline((List)br, (WorldGenLevel)world, (BlockState)wood, (BlockPos)pos, (java.util.function.Function)replace);
            }
        }
        sdf.setReplaceFunction(state -> state.is(CommonBlockTags.END_STONES) || BlocksHelper.replaceableOrPlant((BlockState)state) != false).addPostProcess(info -> {
            if (!(!info.getState().equals(log) || info.getStateUp().equals(log) && info.getStateDown().equals(log))) {
                return wood;
            }
            return info.getState();
        }).fillRecursive((ServerLevelAccessor)world, pos);
        return true;
    }
}

