/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.integration.byg.biomes;

import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.Music;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.AmbientAdditionsSettings;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.SurfaceRules;
import org.betterx.bclib.interfaces.SurfaceMaterialProvider;
import org.betterx.betterend.integration.Integrations;
import org.betterx.betterend.integration.byg.biomes.BYGBiomes;
import org.betterx.betterend.integration.byg.features.BYGFeatures;
import org.betterx.betterend.registry.features.EndLakeFeatures;
import org.betterx.betterend.registry.features.EndVegetationFeatures;
import org.betterx.betterend.world.biome.EndBiome;
import org.betterx.betterend.world.biome.EndBiomeBuilder;
import org.betterx.wover.core.api.ModCore;
import org.betterx.wover.feature.api.placed.BasePlacedFeatureKey;
import org.betterx.wover.surface.api.Conditions;
import org.betterx.wover.surface.api.SurfaceRuleBuilder;

public class OldBulbisGardens
extends EndBiome.Config {
    @Override
    public void addCustomBuildData(EndBiomeBuilder builder) {
        ((EndBiomeBuilder)((EndBiomeBuilder)((EndBiomeBuilder)((EndBiomeBuilder)((EndBiomeBuilder)((EndBiomeBuilder)builder.fogColor(215, 132, 207)).fogDensity(1.8f)).waterAndFogColor(40, 0, 56)).foliageColorOverride(122, 17, 155)).particles((ParticleOptions)ParticleTypes.REVERSE_PORTAL, 0.002f)).feature((BasePlacedFeatureKey)EndLakeFeatures.END_LAKE_RARE)).feature((BasePlacedFeatureKey)BYGFeatures.OLD_BULBIS_TREE);
        Holder biome = Integrations.BYG.getBiome("bulbis_gardens");
        if (biome == null) {
            return;
        }
        if (ModCore.isClient()) {
            BiomeSpecialEffects effects = ((Biome)biome.value()).getSpecialEffects();
            Holder loop = (Holder)effects.getAmbientLoopSoundEvent().get();
            Holder music = ((Music)effects.getBackgroundMusic().get()).getEvent();
            Holder additions = ((AmbientAdditionsSettings)effects.getAmbientAdditionsSettings().get()).getSoundEvent();
            Holder mood = ((AmbientMoodSettings)effects.getAmbientMoodSettings().get()).getSoundEvent();
            ((EndBiomeBuilder)((EndBiomeBuilder)((EndBiomeBuilder)builder.loop(loop)).music(music)).additions(additions)).mood(mood);
        }
        for (BiomeSpecialEffects group : MobCategory.values()) {
            List list = ((Biome)biome.value()).getMobSettings().getMobs((MobCategory)group).unwrap();
            list.forEach(entry -> builder.spawn(entry.type, 1, entry.minCount, entry.maxCount));
        }
        List features = ((Biome)biome.value()).getGenerationSettings().features();
        HolderSet vegetal = (HolderSet)features.get(GenerationStep.Decoration.VEGETAL_DECORATION.ordinal());
        for (Holder feature : vegetal) {
            builder.feature(GenerationStep.Decoration.VEGETAL_DECORATION, feature);
        }
        ((EndBiomeBuilder)((EndBiomeBuilder)((EndBiomeBuilder)((EndBiomeBuilder)builder.feature((BasePlacedFeatureKey)EndVegetationFeatures.PURPLE_POLYPORE)).feature((BasePlacedFeatureKey)BYGFeatures.IVIS_MOSS_WOOD)).feature((BasePlacedFeatureKey)BYGFeatures.IVIS_MOSS)).feature((BasePlacedFeatureKey)BYGFeatures.IVIS_VINE)).feature((BasePlacedFeatureKey)BYGFeatures.IVIS_SPROUT);
    }

    @Override
    public SurfaceMaterialProvider surfaceMaterial() {
        return new EndBiome.DefaultSurfaceMaterialProvider(this){

            @Override
            public BlockState getTopMaterial() {
                return Integrations.BYG.getBlock("ivis_phylium").defaultBlockState();
            }

            @Override
            public BlockState getAltTopMaterial() {
                return Integrations.BYG.getBlock("bulbis_phycelium").defaultBlockState();
            }

            @Override
            public SurfaceRuleBuilder surface() {
                return (SurfaceRuleBuilder)SurfaceRuleBuilder.start().rule(SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)BYGBiomes.BYG_WATER_CHECK, (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.ON_FLOOR, (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)Conditions.roughNoise((ResourceKey)Noises.NETHERRACK, (double)0.19), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)this.getTopMaterial())), SurfaceRules.state((BlockState)this.getAltTopMaterial())})))}), 4);
            }
        };
    }
}

