/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.entity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.EyesLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.betterx.betterend.BetterEnd;
import org.betterx.betterend.entity.EndSlimeEntity;
import org.betterx.betterend.entity.model.EndSlimeEntityModel;

public class RendererEntityEndSlime
extends MobRenderer<EndSlimeEntity, EndSlimeEntityModel<EndSlimeEntity>> {
    private static final ResourceLocation[] TEXTURE = new ResourceLocation[4];
    private static final RenderType[] GLOW = new RenderType[4];

    public RendererEntityEndSlime(EntityRendererProvider.Context ctx) {
        super(ctx, new EndSlimeEntityModel(ctx.getModelSet(), false), 0.25f);
        this.addLayer(new OverlayFeatureRenderer(this, this, ctx));
        this.addLayer((RenderLayer)new EyesLayer<EndSlimeEntity, EndSlimeEntityModel<EndSlimeEntity>>(this, (RenderLayerParent)this){

            public RenderType renderType() {
                return GLOW[0];
            }

            public void render(PoseStack matrices, MultiBufferSource vertexConsumers, int light, EndSlimeEntity entity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
                VertexConsumer vertexConsumer = vertexConsumers.getBuffer(GLOW[entity.getSlimeType()]);
                ((EndSlimeEntityModel)this.getParentModel()).renderToBuffer(matrices, vertexConsumer, 0xF00000, OverlayTexture.NO_OVERLAY, -1);
                if (entity.isLake()) {
                    ((EndSlimeEntityModel)this.getParentModel()).renderFlower(matrices, vertexConsumer, 0xF00000, OverlayTexture.NO_OVERLAY);
                }
            }
        });
    }

    public ResourceLocation getTextureLocation(EndSlimeEntity entity) {
        return TEXTURE[entity.getSlimeType()];
    }

    public void render(EndSlimeEntity slimeEntity, float f, float g, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int i) {
        this.shadowRadius = 0.25f * (float)slimeEntity.getSize();
        super.render((LivingEntity)slimeEntity, f, g, matrixStack, vertexConsumerProvider, i);
    }

    protected void scale(EndSlimeEntity slimeEntity, PoseStack matrixStack, float f) {
        matrixStack.scale(0.999f, 0.999f, 0.999f);
        matrixStack.translate(0.0, (double)0.001f, 0.0);
        float h = slimeEntity.getSize();
        float i = Mth.lerp((float)f, (float)slimeEntity.oSquish, (float)slimeEntity.squish) / (h * 0.5f + 1.0f);
        float j = 1.0f / (i + 1.0f);
        matrixStack.scale(j * h, 1.0f / j * h, j * h);
    }

    static {
        RendererEntityEndSlime.TEXTURE[0] = BetterEnd.C.mk("textures/entity/end_slime/end_slime.png");
        RendererEntityEndSlime.TEXTURE[1] = BetterEnd.C.mk("textures/entity/end_slime/end_slime_mossy.png");
        RendererEntityEndSlime.TEXTURE[2] = BetterEnd.C.mk("textures/entity/end_slime/end_slime_lake.png");
        RendererEntityEndSlime.TEXTURE[3] = BetterEnd.C.mk("textures/entity/end_slime/end_slime_amber.png");
        RendererEntityEndSlime.GLOW[0] = RenderType.eyes((ResourceLocation)BetterEnd.C.mk("textures/entity/end_slime/end_slime_glow.png"));
        RendererEntityEndSlime.GLOW[1] = GLOW[0];
        RendererEntityEndSlime.GLOW[2] = RenderType.eyes((ResourceLocation)BetterEnd.C.mk("textures/entity/end_slime/end_slime_lake_glow.png"));
        RendererEntityEndSlime.GLOW[3] = RenderType.eyes((ResourceLocation)BetterEnd.C.mk("textures/entity/end_slime/end_slime_amber_glow.png"));
    }

    private final class OverlayFeatureRenderer<T extends EndSlimeEntity>
    extends RenderLayer<T, EndSlimeEntityModel<T>> {
        private final EndSlimeEntityModel<T> modelOrdinal;
        private final EndSlimeEntityModel<T> modelLake;

        public OverlayFeatureRenderer(RendererEntityEndSlime rendererEntityEndSlime, RenderLayerParent<T, EndSlimeEntityModel<T>> featureRendererContext, EntityRendererProvider.Context ctx) {
            super(featureRendererContext);
            this.modelOrdinal = new EndSlimeEntityModel(ctx.getModelSet(), true);
            this.modelLake = new EndSlimeEntityModel(ctx.getModelSet(), true);
        }

        public void render(PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int i, T livingEntity, float f, float g, float h, float j, float k, float l) {
            if (!livingEntity.isInvisible()) {
                if (((EndSlimeEntity)((Object)livingEntity)).isLake()) {
                    vertexConsumer = vertexConsumerProvider.getBuffer(RenderType.entityCutout((ResourceLocation)this.getTextureLocation((Entity)livingEntity)));
                    ((EndSlimeEntityModel)this.getParentModel()).renderFlower(matrixStack, vertexConsumer, i, LivingEntityRenderer.getOverlayCoords(livingEntity, (float)0.0f));
                } else if (((EndSlimeEntity)((Object)livingEntity)).isAmber() || ((EndSlimeEntity)((Object)livingEntity)).isChorus()) {
                    vertexConsumer = vertexConsumerProvider.getBuffer(RenderType.entityCutout((ResourceLocation)this.getTextureLocation((Entity)livingEntity)));
                    ((EndSlimeEntityModel)this.getParentModel()).renderCrop(matrixStack, vertexConsumer, i, LivingEntityRenderer.getOverlayCoords(livingEntity, (float)0.0f));
                }
                EndSlimeEntityModel<T> model = ((EndSlimeEntity)((Object)livingEntity)).getSlimeType() == 1 ? this.modelLake : this.modelOrdinal;
                ((EndSlimeEntityModel)this.getParentModel()).copyPropertiesTo((EntityModel)model);
                model.prepareMobModel((Entity)livingEntity, f, g, h);
                model.setupAnim(livingEntity, f, g, j, k, l);
                VertexConsumer vertexConsumer = vertexConsumerProvider.getBuffer(RenderType.entityTranslucent((ResourceLocation)this.getTextureLocation((Entity)livingEntity)));
                model.renderToBuffer(matrixStack, vertexConsumer, i, LivingEntityRenderer.getOverlayCoords(livingEntity, (float)0.0f), -1);
            }
        }
    }
}

