/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.entity.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.entity.EndSlimeEntity;
import org.betterx.betterend.registry.EndEntitiesRenders;

public class EndSlimeEntityModel<T extends EndSlimeEntity>
extends ListModel<T> {
    private final ModelPart innerCube;
    private final ModelPart rightEye;
    private final ModelPart leftEye;
    private final ModelPart mouth;
    private final ModelPart flower;
    private final ModelPart crop;

    public static LayerDefinition getShellOnlyTexturedModelData() {
        return EndSlimeEntityModel.getTexturedModelData(true);
    }

    public static LayerDefinition getCompleteTexturedModelData() {
        return EndSlimeEntityModel.getTexturedModelData(false);
    }

    private static LayerDefinition getTexturedModelData(boolean onlyShell) {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        if (onlyShell) {
            modelPartData.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, 16.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.ZERO);
        } else {
            modelPartData.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 16).addBox(-3.0f, 17.0f, -3.0f, 6.0f, 6.0f, 6.0f), PartPose.ZERO);
            modelPartData.addOrReplaceChild("right_eye", CubeListBuilder.create().texOffs(32, 0).addBox(-3.25f, 18.0f, -3.5f, 2.0f, 2.0f, 2.0f), PartPose.ZERO);
            modelPartData.addOrReplaceChild("left_eye", CubeListBuilder.create().texOffs(32, 4).addBox(1.25f, 18.0f, -3.5f, 2.0f, 2.0f, 2.0f), PartPose.ZERO);
            modelPartData.addOrReplaceChild("mouth", CubeListBuilder.create().texOffs(32, 8).addBox(0.0f, 21.0f, -3.5f, 1.0f, 1.0f, 1.0f), PartPose.ZERO);
            PartDefinition flowerPart = modelPartData.addOrReplaceChild("flower", CubeListBuilder.create(), PartPose.ZERO);
            PartDefinition cropPart = modelPartData.addOrReplaceChild("crop", CubeListBuilder.create(), PartPose.ZERO);
            for (int i = 0; i < 6; ++i) {
                PartDefinition parent = i < 4 ? flowerPart : cropPart;
                float rot = MHelper.degreesToRadians((float)(i < 4 ? (float)i * 45.0f : (float)(i - 4) * 90.0f + 45.0f));
                PartDefinition petalRotPart = parent.addOrReplaceChild("petalRot_" + i, CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)rot, (float)0.0f));
                petalRotPart.addOrReplaceChild("petal_" + i, CubeListBuilder.create().texOffs(40, 0).addBox(0.0f, 0.0f, 0.0f, 8.0f, 8.0f, 0.0f), PartPose.offset((float)-4.0f, (float)8.0f, (float)0.0f));
            }
        }
        return LayerDefinition.create((MeshDefinition)modelData, (int)64, (int)32);
    }

    public EndSlimeEntityModel(EntityModelSet modelSet, boolean onlyShell) {
        super(RenderType::entityCutout);
        ModelPart modelPart = modelSet.bakeLayer(onlyShell ? EndEntitiesRenders.END_SLIME_SHELL_MODEL : EndEntitiesRenders.END_SLIME_MODEL);
        this.innerCube = modelPart.getChild("body");
        if (!onlyShell) {
            this.rightEye = modelPart.getChild("right_eye");
            this.leftEye = modelPart.getChild("left_eye");
            this.mouth = modelPart.getChild("mouth");
            this.flower = modelPart.getChild("flower");
            this.crop = modelPart.getChild("crop");
        } else {
            this.rightEye = null;
            this.leftEye = null;
            this.mouth = null;
            this.flower = null;
            this.crop = null;
        }
    }

    public void setupAnim(T entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
    }

    public void renderFlower(PoseStack matrices, VertexConsumer vertices, int light, int overlay) {
        this.flower.render(matrices, vertices, light, overlay);
    }

    public void renderCrop(PoseStack matrices, VertexConsumer vertices, int light, int overlay) {
        this.crop.render(matrices, vertices, light, overlay);
    }

    private boolean isOnlyShell() {
        return this.rightEye == null;
    }

    public Iterable<ModelPart> parts() {
        if (this.isOnlyShell()) {
            return ImmutableList.of((Object)this.innerCube);
        }
        return ImmutableList.of((Object)this.innerCube, (Object)this.rightEye, (Object)this.leftEye, (Object)this.mouth);
    }
}

