/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.entity.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.Mth;
import org.betterx.betterend.entity.CubozoaEntity;

public class CubozoaEntityModel
extends EntityModel<CubozoaEntity> {
    private static final int TENTACLE_COUNT = 4;
    private final ModelPart model;
    private final ModelPart[] tentacle_center;
    private final ModelPart[] tentacle = new ModelPart[4];
    private float scaleY;
    private float scaleXZ;

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        PartDefinition bodyPart = modelPartData.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 17).addBox(-2.0f, -12.5f, -2.0f, 4.0f, 4.0f, 4.0f), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        bodyPart.addOrReplaceChild("main_cube_r1", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, -7.0f, -5.0f, 10.0f, 7.0f, 10.0f), PartPose.offsetAndRotation((float)0.0f, (float)-14.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-3.1416f));
        for (int i = 1; i <= 4; ++i) {
            PartDefinition tentaclePart = bodyPart.addOrReplaceChild("tentacle_center_" + i, CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)((float)i * 1.5708f), (float)0.0f));
            tentaclePart.addOrReplaceChild("tentacle_" + i, CubeListBuilder.create().texOffs(16, 17).addBox(-4.0f, 0.0f, 0.0f, 8.0f, 7.0f, 0.0f), PartPose.offset((float)0.0f, (float)-7.0f, (float)4.5f));
        }
        return LayerDefinition.create((MeshDefinition)modelData, (int)48, (int)48);
    }

    public CubozoaEntityModel(ModelPart modelPart) {
        super(RenderType::entityTranslucent);
        this.tentacle_center = new ModelPart[4];
        this.model = modelPart.getChild("body");
        for (int i = 1; i <= 4; ++i) {
            this.tentacle_center[i - 1] = this.model.getChild("tentacle_center_" + i);
            this.tentacle[i - 1] = this.tentacle_center[i - 1].getChild("tentacle_" + i);
        }
    }

    public void setupAnim(CubozoaEntity entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        float sin = Mth.sin((float)(animationProgress * 0.13f));
        this.scaleY = sin * 0.1f + 0.9f;
        this.scaleXZ = Mth.sin((float)(animationProgress * 0.13f + 3.14f)) * 0.1f + 0.9f;
        for (int i = 0; i < 4; ++i) {
            this.tentacle[i].xRot = sin * 0.15f;
        }
    }

    public void renderToBuffer(PoseStack matrices, VertexConsumer vertices, int light, int overlay, int color) {
        matrices.pushPose();
        matrices.scale(this.scaleXZ, this.scaleY, this.scaleXZ);
        this.model.render(matrices, vertices, light, overlay);
        matrices.popPose();
    }
}

