/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.registry.EndSounds;

public class ShadowWalkerEntity
extends Monster {
    public ShadowWalkerEntity(EntityType<ShadowWalkerEntity> entityType, Level world) {
        super(entityType, world);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(2, (Goal)new AttackGoal(this, this, 1.0, false));
        this.goalSelector.addGoal(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public static AttributeSupplier.Builder createMobAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.FOLLOW_RANGE, 35.0).add(Attributes.MOVEMENT_SPEED, 0.15).add(Attributes.ATTACK_DAMAGE, 4.5).add(Attributes.ARMOR, 2.0).add(Attributes.SPAWN_REINFORCEMENTS_CHANCE);
    }

    public void tick() {
        super.tick();
        this.level().addParticle((ParticleOptions)ParticleTypes.ASH, this.getX() + this.random.nextGaussian() * 0.2, this.getY() + this.random.nextGaussian() * 0.5 + 1.0, this.getZ() + this.random.nextGaussian() * 0.2, 0.0, 0.0, 0.0);
        this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, this.getX() + this.random.nextGaussian() * 0.2, this.getY() + this.random.nextGaussian() * 0.5 + 1.0, this.getZ() + this.random.nextGaussian() * 0.2, 0.0, 0.0, 0.0);
        this.level().addParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (int)-1), this.getX() + this.random.nextGaussian() * 0.2, this.getY() + this.random.nextGaussian() * 0.5 + 1.0, this.getZ() + this.random.nextGaussian() * 0.2, 0.0, 0.0, 0.0);
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)EndSounds.ENTITY_SHADOW_WALKER.value();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)EndSounds.ENTITY_SHADOW_WALKER_DAMAGE.value();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)EndSounds.ENTITY_SHADOW_WALKER_DEATH.value();
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
    }

    protected float getSoundVolume() {
        return MHelper.randRange((float)0.25f, (float)0.5f, (RandomSource)this.random);
    }

    public float getVoicePitch() {
        return MHelper.randRange((float)0.75f, (float)1.25f, (RandomSource)this.random);
    }

    public boolean doHurtTarget(Entity target) {
        LivingEntity living;
        boolean attack = super.doHurtTarget(target);
        if (attack && target instanceof LivingEntity && !(living = (LivingEntity)target).hasEffect(MobEffects.BLINDNESS)) {
            living.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 60));
        }
        return attack;
    }

    private final class AttackGoal
    extends MeleeAttackGoal {
        private final ShadowWalkerEntity walker;
        private int ticks;

        public AttackGoal(ShadowWalkerEntity shadowWalkerEntity, ShadowWalkerEntity walker, double speed, boolean pauseWhenMobIdle) {
            super((PathfinderMob)walker, speed, pauseWhenMobIdle);
            this.walker = walker;
        }

        public void start() {
            super.start();
            this.ticks = 0;
        }

        public void stop() {
            super.stop();
            this.walker.setAggressive(false);
        }

        public void tick() {
            super.tick();
            ++this.ticks;
            this.walker.setAggressive(this.ticks >= 5 && this.getTicksUntilNextAttack() < this.getAttackInterval() / 2);
        }
    }
}

