/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.entity;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.interfaces.ISlime;
import org.betterx.betterend.registry.EndBiomes;
import org.betterx.betterend.util.GlobalState;
import org.betterx.wover.enchantment.api.EnchantmentUtils;
import org.betterx.wover.tag.api.predefined.CommonBlockTags;
import org.jetbrains.annotations.Nullable;

public class EndSlimeEntity
extends Slime {
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.defineId(EndSlimeEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public EndSlimeEntity(EntityType<EndSlimeEntity> entityType, Level world) {
        super(entityType, world);
        this.moveControl = new EndSlimeMoveControl(this);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new SwimmingGoal());
        this.goalSelector.addGoal(2, (Goal)new FaceTowardTargetGoal());
        this.goalSelector.addGoal(3, (Goal)new RandomLookGoal());
        this.goalSelector.addGoal(5, (Goal)new MoveGoal());
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, livingEntity -> Math.abs(livingEntity.getY() - this.getY()) <= 4.0));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    public static AttributeSupplier.Builder createMobAttributes() {
        return LivingEntity.createLivingAttributes().add(Attributes.MAX_HEALTH, 1.0).add(Attributes.ATTACK_DAMAGE, 1.0).add(Attributes.FOLLOW_RANGE, 16.0).add(Attributes.MOVEMENT_SPEED, 0.15);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData) {
        SpawnGroupData data = super.finalizeSpawn(world, difficulty, spawnReason, entityData);
        Holder biome = world.getBiome(this.blockPosition());
        if (biome.unwrapKey().isPresent()) {
            if (biome.is(EndBiomes.FOGGY_MUSHROOMLAND.key)) {
                this.setMossy();
            } else if (biome.is(EndBiomes.MEGALAKE.key) || biome.is(EndBiomes.MEGALAKE_GROVE.key)) {
                this.setLake();
            } else if (biome.is(EndBiomes.AMBER_LAND.key)) {
                this.setAmber();
            }
            this.refreshDimensions();
        }
        return data;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(VARIANT, (Object)0);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("Variant", this.getSlimeType());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("Variant")) {
            this.entityData.set(VARIANT, (Object)tag.getInt("Variant"));
        }
    }

    protected ParticleOptions getParticleType() {
        return ParticleTypes.PORTAL;
    }

    public void remove(Entity.RemovalReason reason) {
        int i = this.getSize();
        if (!this.level().isClientSide && i > 1 && this.isDeadOrDying()) {
            Component text = this.getCustomName();
            boolean bl = this.isNoAi();
            float f = (float)i / 4.0f;
            int j = i / 2;
            int k = 2 + this.random.nextInt(3);
            int type = this.getSlimeType();
            for (int l = 0; l < k; ++l) {
                float g = ((float)(l % 2) - 0.5f) * f;
                float h = ((float)(l / 2) - 0.5f) * f;
                EndSlimeEntity slimeEntity = (EndSlimeEntity)this.getType().create(this.level());
                if (this.isPersistenceRequired()) {
                    slimeEntity.setPersistenceRequired();
                }
                slimeEntity.setSlimeType(type);
                slimeEntity.setCustomName(text);
                slimeEntity.setNoAi(bl);
                slimeEntity.setInvulnerable(this.isInvulnerable());
                ((ISlime)((Object)slimeEntity)).be_setSlimeSize(j, true);
                slimeEntity.refreshDimensions();
                slimeEntity.moveTo(this.getX() + (double)g, this.getY() + 0.5, this.getZ() + (double)h, this.random.nextFloat() * 360.0f, 0.0f);
                this.level().addFreshEntity((Entity)slimeEntity);
            }
        }
        ((ISlime)((Object)this)).entityRemove(reason);
    }

    protected void dropFromLootTable(DamageSource source, boolean causedByPlayer) {
        int maxCount = this.getSize();
        int minCount = maxCount >> 1;
        if (minCount < 1) {
            minCount = 1;
        }
        if (causedByPlayer && this.lastHurtByPlayer != null) {
            int looting = EnchantmentUtils.getItemEnchantmentLevel((Level)this.lastHurtByPlayer.level(), (ResourceKey)Enchantments.LOOTING, (LivingEntity)this.lastHurtByPlayer);
            minCount += looting;
        }
        int count = minCount < maxCount ? MHelper.randRange((int)minCount, (int)maxCount, (RandomSource)this.random) : maxCount;
        ItemEntity drop = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), new ItemStack((ItemLike)Items.SLIME_BALL, count));
        this.level().addFreshEntity((Entity)drop);
    }

    public int getSlimeType() {
        return (Integer)this.entityData.get(VARIANT);
    }

    public void setSlimeType(int value) {
        this.entityData.set(VARIANT, (Object)value);
    }

    protected void setMossy() {
        this.setSlimeType(1);
    }

    public boolean isMossy() {
        return this.getSlimeType() == 1;
    }

    protected void setLake() {
        this.setSlimeType(2);
    }

    public boolean isLake() {
        return this.getSlimeType() == 2;
    }

    protected void setAmber() {
        this.setSlimeType(3);
    }

    public boolean isAmber() {
        return (Integer)this.entityData.get(VARIANT) == 3;
    }

    public boolean isChorus() {
        return (Integer)this.entityData.get(VARIANT) == 0;
    }

    public static boolean canSpawn(EntityType entityType, LevelAccessor world, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        if (!world.getBlockState(pos.below()).is(CommonBlockTags.END_STONES)) {
            return false;
        }
        Holder biome = world.getBiome(pos);
        if (biome.unwrapKey().isPresent()) {
            if (biome.equals(EndBiomes.CHORUS_FOREST) || biome.equals(EndBiomes.MEGALAKE)) {
                return true;
            }
            if (biome.equals(EndBiomes.MEGALAKE_GROVE) && random.nextBoolean()) {
                return true;
            }
        }
        return random.nextInt(4) == 0 && EndSlimeEntity.isWaterNear(world, pos);
    }

    private static boolean isWaterNear(LevelAccessor world, BlockPos pos) {
        BlockPos.MutableBlockPos POS = GlobalState.stateForThread().POS;
        for (int x = pos.getX() - 32; x <= pos.getX() + 32; ++x) {
            POS.setX(x);
            for (int z = pos.getZ() - 32; z <= pos.getZ() + 32; ++z) {
                POS.setZ(z);
                for (int y = pos.getY() - 8; y <= pos.getY() + 8; ++y) {
                    POS.setY(y);
                    if (world.getBlockState((BlockPos)POS).getBlock() != Blocks.WATER) continue;
                    return true;
                }
            }
        }
        return false;
    }

    class EndSlimeMoveControl
    extends MoveControl {
        private float targetYaw;
        private int ticksUntilJump;
        private boolean jumpOften;

        public EndSlimeMoveControl(EndSlimeEntity slime) {
            super((Mob)slime);
            this.targetYaw = 180.0f * slime.getYRot() / (float)Math.PI;
        }

        public void look(float targetYaw, boolean jumpOften) {
            this.targetYaw = targetYaw;
            this.jumpOften = jumpOften;
        }

        public void move(double speed) {
            this.speedModifier = speed;
            this.operation = MoveControl.Operation.MOVE_TO;
        }

        public void tick() {
            this.mob.setYRot(this.rotlerp(this.mob.getYRot(), this.targetYaw, 90.0f));
            this.mob.yHeadRot = this.mob.getYRot();
            this.mob.yBodyRot = this.mob.getYRot();
            if (this.operation != MoveControl.Operation.MOVE_TO) {
                this.mob.setZza(0.0f);
            } else {
                this.operation = MoveControl.Operation.WAIT;
                if (this.mob.onGround()) {
                    this.mob.setSpeed((float)(this.speedModifier * this.mob.getAttributeValue(Attributes.MOVEMENT_SPEED)));
                    if (this.ticksUntilJump-- <= 0) {
                        this.ticksUntilJump = EndSlimeEntity.this.getJumpDelay();
                        if (this.jumpOften) {
                            this.ticksUntilJump /= 3;
                        }
                        EndSlimeEntity.this.getJumpControl().jump();
                        if (EndSlimeEntity.this.doPlayJumpSound()) {
                            EndSlimeEntity.this.playSound(EndSlimeEntity.this.getJumpSound(), EndSlimeEntity.this.getSoundVolume(), this.getJumpSoundPitch());
                        }
                    } else {
                        EndSlimeEntity.this.xxa = 0.0f;
                        EndSlimeEntity.this.zza = 0.0f;
                        this.mob.setSpeed(0.0f);
                    }
                } else {
                    this.mob.setSpeed((float)(this.speedModifier * this.mob.getAttributeValue(Attributes.MOVEMENT_SPEED)));
                }
            }
        }

        private float getJumpSoundPitch() {
            float f = EndSlimeEntity.this.isTiny() ? 1.4f : 0.8f;
            return ((EndSlimeEntity.this.random.nextFloat() - EndSlimeEntity.this.random.nextFloat()) * 0.2f + 1.0f) * f;
        }
    }

    class SwimmingGoal
    extends Goal {
        public SwimmingGoal() {
            this.setFlags(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
            EndSlimeEntity.this.getNavigation().setCanFloat(true);
        }

        public boolean canUse() {
            return (EndSlimeEntity.this.isInWater() || EndSlimeEntity.this.isInLava()) && EndSlimeEntity.this.getMoveControl() instanceof EndSlimeMoveControl;
        }

        public void tick() {
            if (EndSlimeEntity.this.getRandom().nextFloat() < 0.8f) {
                EndSlimeEntity.this.getJumpControl().jump();
            }
            ((EndSlimeMoveControl)EndSlimeEntity.this.getMoveControl()).move(1.2);
        }
    }

    class FaceTowardTargetGoal
    extends Goal {
        private int ticksLeft;

        public FaceTowardTargetGoal() {
            this.setFlags(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean canUse() {
            LivingEntity livingEntity = EndSlimeEntity.this.getTarget();
            if (livingEntity == null) {
                return false;
            }
            if (!livingEntity.isAlive()) {
                return false;
            }
            return (!(livingEntity instanceof Player) || !((Player)livingEntity).getAbilities().invulnerable) && EndSlimeEntity.this.getMoveControl() instanceof EndSlimeMoveControl;
        }

        public void start() {
            this.ticksLeft = 300;
            super.start();
        }

        public boolean canContinueToUse() {
            LivingEntity livingEntity = EndSlimeEntity.this.getTarget();
            if (livingEntity == null) {
                return false;
            }
            if (!livingEntity.isAlive()) {
                return false;
            }
            if (livingEntity instanceof Player && ((Player)livingEntity).getAbilities().invulnerable) {
                return false;
            }
            return --this.ticksLeft > 0;
        }

        public void tick() {
            EndSlimeEntity.this.lookAt((Entity)EndSlimeEntity.this.getTarget(), 10.0f, 10.0f);
            ((EndSlimeMoveControl)EndSlimeEntity.this.getMoveControl()).look(EndSlimeEntity.this.getYRot(), EndSlimeEntity.this.isDealsDamage());
        }
    }

    class RandomLookGoal
    extends Goal {
        private float targetYaw;
        private int timer;

        public RandomLookGoal() {
            this.setFlags(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean canUse() {
            return EndSlimeEntity.this.getTarget() == null && (EndSlimeEntity.this.onGround() || EndSlimeEntity.this.isInWater() || EndSlimeEntity.this.isInLava() || EndSlimeEntity.this.hasEffect(MobEffects.LEVITATION)) && EndSlimeEntity.this.getMoveControl() instanceof EndSlimeMoveControl;
        }

        public void tick() {
            if (--this.timer <= 0) {
                this.timer = 40 + EndSlimeEntity.this.getRandom().nextInt(60);
                this.targetYaw = EndSlimeEntity.this.getRandom().nextInt(360);
            }
            ((EndSlimeMoveControl)EndSlimeEntity.this.getMoveControl()).look(this.targetYaw, false);
        }
    }

    class MoveGoal
    extends Goal {
        public MoveGoal() {
            this.setFlags(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean canUse() {
            if (EndSlimeEntity.this.isPassenger()) {
                return false;
            }
            float yaw = EndSlimeEntity.this.getYHeadRot();
            float speed = EndSlimeEntity.this.getSpeed();
            if ((double)speed > 0.1) {
                float dx = Mth.sin((float)(-yaw * ((float)Math.PI / 180)));
                float dz = Mth.cos((float)(-yaw * ((float)Math.PI / 180)));
                BlockPos pos = EndSlimeEntity.this.blockPosition().offset((int)(dx * speed * 4.0f), 0, (int)(dz * speed * 4.0f));
                int down = BlocksHelper.downRay((LevelAccessor)EndSlimeEntity.this.level(), (BlockPos)pos, (int)16);
                return down < 5;
            }
            return true;
        }

        public void tick() {
            ((EndSlimeMoveControl)EndSlimeEntity.this.getMoveControl()).move(1.0);
        }
    }
}

