/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.entity;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.AirAndWaterRandomPos;
import net.minecraft.world.entity.ai.util.HoverRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import org.betterx.bclib.entity.DespawnableAnimal;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.registry.EndEntities;
import org.betterx.betterend.registry.EndSounds;
import org.jetbrains.annotations.NotNull;

public class DragonflyEntity
extends DespawnableAnimal
implements FlyingAnimal {
    public DragonflyEntity(EntityType<DragonflyEntity> entityType, Level world) {
        super(entityType, world);
        this.moveControl = new FlyingMoveControl((Mob)this, 20, true);
        this.lookControl = new DragonflyLookControl((Mob)this);
        this.setPathfindingMalus(PathType.WATER, -1.0f);
        this.setPathfindingMalus(PathType.DANGER_FIRE, -1.0f);
        this.xpReward = 1;
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder createMobAttributes() {
        return LivingEntity.createLivingAttributes().add(Attributes.MAX_HEALTH, 8.0).add(Attributes.FOLLOW_RANGE, 16.0).add(Attributes.FLYING_SPEED, 1.0).add(Attributes.MOVEMENT_SPEED, 0.1);
    }

    public boolean canBeLeashed() {
        return false;
    }

    @NotNull
    protected PathNavigation createNavigation(Level world) {
        FlyingPathNavigation birdNavigation = new FlyingPathNavigation(this, (Mob)this, world){

            public boolean isStableDestination(BlockPos pos) {
                BlockState state = this.level.getBlockState(pos);
                return state.isAir() || !state.blocksMotion();
            }

            public void tick() {
                super.tick();
            }
        };
        birdNavigation.setCanOpenDoors(false);
        birdNavigation.setCanFloat(false);
        birdNavigation.setCanPassDoors(true);
        return birdNavigation;
    }

    public float getWalkTargetValue(BlockPos pos, LevelReader world) {
        return world.getBlockState(pos).isAir() ? 10.0f : 0.0f;
    }

    public boolean isFood(ItemStack itemStack) {
        return false;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new FollowParentGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(4, (Goal)new WanderAroundGoal());
    }

    public boolean isPushable() {
        return false;
    }

    public boolean causeFallDamage(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        return false;
    }

    protected // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.EVENTS;
    }

    public boolean isFlying() {
        return !this.onGround();
    }

    public boolean isNoGravity() {
        return true;
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)EndSounds.ENTITY_DRAGONFLY.value();
    }

    protected float getSoundVolume() {
        return MHelper.randRange((float)0.25f, (float)0.5f, (RandomSource)this.random);
    }

    public AgeableMob getBreedOffspring(ServerLevel world, AgeableMob entity) {
        return (AgeableMob)EndEntities.DRAGONFLY.type().create((Level)world);
    }

    static class DragonflyLookControl
    extends LookControl {
        DragonflyLookControl(Mob entity) {
            super(entity);
        }

        protected boolean resetXRotOnTick() {
            return true;
        }
    }

    class WanderAroundGoal
    extends Goal {
        WanderAroundGoal() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            return DragonflyEntity.this.navigation.isDone() && DragonflyEntity.this.random.nextInt(10) == 0;
        }

        public boolean canContinueToUse() {
            return DragonflyEntity.this.navigation.isInProgress();
        }

        public void start() {
            Vec3 vec3d = this.getRandomLocation();
            if (vec3d != null) {
                BlockPos pos = new BlockPos((int)vec3d.x, (int)vec3d.y, (int)vec3d.z);
                try {
                    Path path = DragonflyEntity.this.navigation.createPath(pos, 1);
                    if (path != null) {
                        DragonflyEntity.this.navigation.moveTo(path, 1.0);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            super.start();
        }

        private Vec3 getRandomLocation() {
            int h = BlocksHelper.downRay((LevelAccessor)DragonflyEntity.this.level(), (BlockPos)DragonflyEntity.this.blockPosition(), (int)16);
            Vec3 rotation = DragonflyEntity.this.getViewVector(0.0f);
            Vec3 airPos = HoverRandomPos.getPos((PathfinderMob)DragonflyEntity.this, (int)8, (int)7, (double)rotation.x, (double)rotation.z, (float)1.5707964f, (int)3, (int)1);
            if (airPos != null) {
                if (this.isInVoid(airPos)) {
                    for (int i = 0; i < 8; ++i) {
                        airPos = HoverRandomPos.getPos((PathfinderMob)DragonflyEntity.this, (int)16, (int)7, (double)rotation.x, (double)rotation.z, (float)((float)Math.PI * 2), (int)3, (int)1);
                        if (airPos == null || this.isInVoid(airPos)) continue;
                        return airPos;
                    }
                    return null;
                }
                if (h > 5 && airPos.y() >= (double)DragonflyEntity.this.blockPosition().getY()) {
                    airPos = new Vec3(airPos.x, airPos.y - (double)h * 0.5, airPos.z);
                }
                return airPos;
            }
            return AirAndWaterRandomPos.getPos((PathfinderMob)DragonflyEntity.this, (int)8, (int)4, (int)-2, (double)rotation.x, (double)rotation.z, (double)1.5707963705062866);
        }

        private boolean isInVoid(Vec3 pos) {
            int h = BlocksHelper.downRay((LevelAccessor)DragonflyEntity.this.level(), (BlockPos)new BlockPos((int)pos.x, (int)pos.y, (int)pos.z), (int)128);
            return h > 100;
        }
    }
}

