/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.entity;

import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.AbstractSchoolingFish;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.betterx.betterend.registry.EndBiomes;
import org.betterx.betterend.registry.EndItems;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CubozoaEntity
extends AbstractSchoolingFish {
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.defineId(CubozoaEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> SCALE = SynchedEntityData.defineId(CubozoaEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public CubozoaEntity(EntityType<CubozoaEntity> entityType, Level world) {
        super(entityType, world);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData) {
        SpawnGroupData data = super.finalizeSpawn(world, difficulty, spawnReason, entityData);
        Holder biome = world.getBiome(this.blockPosition());
        if (biome.is(EndBiomes.SULPHUR_SPRINGS.key)) {
            this.entityData.set(VARIANT, (Object)1);
        }
        this.refreshDimensions();
        return data;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(VARIANT, (Object)0);
        builder.define(SCALE, (Object)this.getRandom().nextInt(16));
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("Variant", (int)((byte)this.getVariant()));
        tag.putInt("Scale", ((Integer)this.entityData.get(SCALE)).intValue());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("Variant")) {
            this.entityData.set(VARIANT, (Object)tag.getInt("Variant"));
        }
        if (tag.contains("Scale")) {
            this.entityData.set(SCALE, (Object)tag.getInt("Scale"));
        }
    }

    public void saveToBucketTag(ItemStack itemStack) {
        super.saveToBucketTag(itemStack);
        CustomData.update((DataComponentType)DataComponents.BUCKET_ENTITY_DATA, (ItemStack)itemStack, tag -> {
            tag.putInt("Variant", ((Integer)this.entityData.get(VARIANT)).intValue());
            tag.putInt("Scale", ((Integer)this.entityData.get(SCALE)).intValue());
        });
    }

    @NotNull
    public ItemStack getBucketItemStack() {
        ItemStack bucket = EndItems.BUCKET_CUBOZOA.getDefaultInstance();
        return bucket;
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder createMobAttributes() {
        return LivingEntity.createLivingAttributes().add(Attributes.MAX_HEALTH, 2.0).add(Attributes.FOLLOW_RANGE, 16.0).add(Attributes.MOVEMENT_SPEED, 0.5);
    }

    public int getVariant() {
        return (Integer)this.entityData.get(VARIANT);
    }

    public float getScale() {
        return (float)((Integer)this.entityData.get(SCALE)).intValue() / 32.0f + 0.75f;
    }

    protected float getStandingEyeHeight(Pose pose, EntityDimensions dimensions) {
        return dimensions.height() * 0.5f;
    }

    protected void dropFromLootTable(DamageSource source, boolean causedByPlayer) {
        int count = this.random.nextInt(3);
        if (count > 0) {
            ItemEntity drop = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), new ItemStack((ItemLike)EndItems.GELATINE, count));
            this.level().addFreshEntity((Entity)drop);
        }
    }

    protected SoundEvent getFlopSound() {
        return SoundEvents.SALMON_FLOP;
    }

    public void playerTouch(Player player) {
        if (player instanceof ServerPlayer && player.hurt(player.damageSources().mobAttack((LivingEntity)this), 0.5f)) {
            if (!this.isSilent()) {
                ((ServerPlayer)player).connection.send((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.PUFFER_FISH_STING, 0.0f));
            }
            if (this.random.nextBoolean()) {
                player.addEffect(new MobEffectInstance(MobEffects.POISON, 20, 0));
            }
        }
    }
}

