/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.complexmaterials;

import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.material.MapColor;
import org.betterx.bclib.blocks.BaseBlock;
import org.betterx.bclib.blocks.BaseButtonBlock;
import org.betterx.bclib.blocks.BaseFurnaceBlock;
import org.betterx.bclib.blocks.BasePressurePlateBlock;
import org.betterx.bclib.blocks.BaseRotatedPillarBlock;
import org.betterx.bclib.blocks.BaseSlabBlock;
import org.betterx.bclib.blocks.BaseStairsBlock;
import org.betterx.bclib.blocks.BaseWallBlock;
import org.betterx.betterend.BetterEnd;
import org.betterx.betterend.blocks.EndPedestal;
import org.betterx.betterend.blocks.FlowerPotBlock;
import org.betterx.betterend.blocks.basis.StoneLanternBlock;
import org.betterx.betterend.complexmaterials.MaterialManager;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.betterend.registry.EndItems;
import org.betterx.datagen.betterend.recipes.EndCraftingRecipesProvider;
import org.betterx.wover.recipe.api.RecipeBuilder;
import org.betterx.wover.tag.api.event.context.ItemTagBootstrapContext;
import org.betterx.wover.tag.api.event.context.TagBootstrapContext;
import org.betterx.wover.tag.api.predefined.CommonBlockTags;
import org.betterx.wover.tag.api.predefined.CommonItemTags;

public class StoneMaterial
implements MaterialManager.Material {
    public final Block stone;
    public final String name;
    public final Block polished;
    public final Block tiles;
    public final Block pillar;
    public final Block stairs;
    public final Block slab;
    public final Block wall;
    public final Block button;
    public final Block pressurePlate;
    public final Block pedestal;
    public final Block lantern;
    public final Block bricks;
    public final Block brickStairs;
    public final Block brickSlab;
    public final Block brickWall;
    public final Block furnace;
    public final Block flowerPot;

    public static BlockBehaviour.Properties createMaterial(MapColor color) {
        return BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.END_STONE).mapColor(color);
    }

    public StoneMaterial(String name, MapColor color) {
        BlockBehaviour.Properties material = StoneMaterial.createMaterial(color);
        this.name = name;
        this.stone = EndBlocks.registerBlock(name, new BaseBlock.Stone(material), new TagKey[0]);
        this.polished = EndBlocks.registerBlock(name + "_polished", new BaseBlock.Stone(material), new TagKey[0]);
        this.tiles = EndBlocks.registerBlock(name + "_tiles", new BaseBlock.Stone(material), new TagKey[0]);
        this.pillar = EndBlocks.registerBlock(name + "_pillar", new BaseRotatedPillarBlock.Stone(material), new TagKey[0]);
        this.stairs = EndBlocks.registerBlock(name + "_stairs", new BaseStairsBlock.Stone(this.stone), new TagKey[0]);
        this.slab = EndBlocks.registerBlock(name + "_slab", new BaseSlabBlock.Stone(this.stone), new TagKey[0]);
        this.wall = EndBlocks.registerBlock(name + "_wall", new BaseWallBlock.Stone(this.stone), new TagKey[0]);
        this.button = EndBlocks.registerBlock(name + "_button", new BaseButtonBlock.Stone(this.stone, BlockSetType.STONE), new TagKey[0]);
        this.pressurePlate = EndBlocks.registerBlock(name + "_plate", new BasePressurePlateBlock.Stone(this.stone, BlockSetType.STONE), new TagKey[0]);
        this.pedestal = EndBlocks.registerBlock(name + "_pedestal", new EndPedestal.Stone(this.stone), new TagKey[0]);
        this.lantern = EndBlocks.registerBlock(name + "_lantern", new StoneLanternBlock(this.stone), new TagKey[0]);
        this.bricks = EndBlocks.registerBlock(name + "_bricks", new BaseBlock.Stone(material), new TagKey[0]);
        this.brickStairs = EndBlocks.registerBlock(name + "_bricks_stairs", new BaseStairsBlock.Stone(this.bricks), new TagKey[0]);
        this.brickSlab = EndBlocks.registerBlock(name + "_bricks_slab", new BaseSlabBlock.Stone(this.bricks), new TagKey[0]);
        this.brickWall = EndBlocks.registerBlock(name + "_bricks_wall", new BaseWallBlock.Stone(this.bricks), new TagKey[0]);
        this.furnace = EndBlocks.registerBlock(name + "_furnace", new BaseFurnaceBlock.Stone(this.bricks), new TagKey[0]);
        this.flowerPot = EndBlocks.registerBlock(name + "_flower_pot", new FlowerPotBlock.Stone(this.bricks), new TagKey[0]);
        MaterialManager.register(this);
    }

    public static void recipesForStoneMaterial(RecipeOutput context, StoneMaterial mat) {
        RecipeBuilder.stonecutting((ResourceLocation)BetterEnd.C.mk(mat.name + "_bricks_stonecutting"), (ItemLike)mat.bricks).input((ItemLike)mat.stone).group(mat.name + "_stonecutting").build(context);
        RecipeBuilder.stonecutting((ResourceLocation)BetterEnd.C.mk(mat.name + "_wall_stonecutting"), (ItemLike)mat.wall).input((ItemLike)mat.stone).group(mat.name + "_stonecutting").build(context);
        RecipeBuilder.stonecutting((ResourceLocation)BetterEnd.C.mk(mat.name + "_slab_stonecutting"), (ItemLike)mat.slab).input((ItemLike)mat.stone).group(mat.name + "_stonecutting").build(context);
        RecipeBuilder.stonecutting((ResourceLocation)BetterEnd.C.mk(mat.name + "_stairs_stonecutting"), (ItemLike)mat.stairs).input((ItemLike)mat.stone).group(mat.name + "_stonecutting").build(context);
        RecipeBuilder.stonecutting((ResourceLocation)BetterEnd.C.mk(mat.name + "_tiles_stonecutting"), (ItemLike)mat.tiles).input((ItemLike)mat.stone).group(mat.name + "_stonecutting").build(context);
        RecipeBuilder.stonecutting((ResourceLocation)BetterEnd.C.mk(mat.name + "_brick_slab_stonecutting"), (ItemLike)mat.brickSlab).outputCount(2).input((ItemLike)mat.stone).group(mat.name + "_stonecutting").build(context);
        RecipeBuilder.stonecutting((ResourceLocation)BetterEnd.C.mk(mat.name + "_brick_stair_stonecutting"), (ItemLike)mat.brickStairs).input((ItemLike)mat.stone).group(mat.name + "_stonecutting").build(context);
        RecipeBuilder.stonecutting((ResourceLocation)BetterEnd.C.mk(mat.name + "_brick_wall_stonecutting"), (ItemLike)mat.brickWall).input((ItemLike)mat.stone).group(mat.name + "_stonecutting").build(context);
        RecipeBuilder.stonecutting((ResourceLocation)BetterEnd.C.mk(mat.name + "_pillar_stonecutting"), (ItemLike)mat.pillar).input((ItemLike)mat.stone).group(mat.name + "_stonecutting").build(context);
        RecipeBuilder.stonecutting((ResourceLocation)BetterEnd.C.mk(mat.name + "_polished_stonecutting"), (ItemLike)mat.polished).input((ItemLike)mat.stone).group(mat.name + "_stonecutting").build(context);
        RecipeBuilder.stonecutting((ResourceLocation)BetterEnd.C.mk(mat.name + "_brick_slabs_from_" + mat.name + "_brick_stonecutting"), (ItemLike)mat.brickSlab).outputCount(2).input((ItemLike)mat.bricks).group(mat.name + "_stonecutting").build(context);
        RecipeBuilder.stonecutting((ResourceLocation)BetterEnd.C.mk(mat.name + "_brick_stair_from_" + mat.name + "_brick_stonecutting"), (ItemLike)mat.brickStairs).input((ItemLike)mat.bricks).group(mat.name + "_stonecutting").build(context);
        RecipeBuilder.stonecutting((ResourceLocation)BetterEnd.C.mk(mat.name + "_brick_wall_from_" + mat.name + "_brick_stonecutting"), (ItemLike)mat.brickWall).input((ItemLike)mat.bricks).group(mat.name + "_stonecutting").build(context);
    }

    @Override
    public void registerRecipes(RecipeOutput context) {
        RecipeBuilder.crafting((ResourceLocation)BetterEnd.C.mk(this.name + "_bricks"), (ItemLike)this.bricks).outputCount(4).shape(new String[]{"##", "##"}).addMaterial('#', new ItemLike[]{this.stone}).group("end_bricks").build(context);
        RecipeBuilder.crafting((ResourceLocation)BetterEnd.C.mk(this.name + "_polished"), (ItemLike)this.polished).outputCount(4).shape(new String[]{"##", "##"}).addMaterial('#', new ItemLike[]{this.bricks}).group("end_tile").build(context);
        RecipeBuilder.crafting((ResourceLocation)BetterEnd.C.mk(this.name + "_tiles"), (ItemLike)this.tiles).outputCount(4).shape(new String[]{"##", "##"}).addMaterial('#', new ItemLike[]{this.polished}).group("end_small_tile").build(context);
        RecipeBuilder.crafting((ResourceLocation)BetterEnd.C.mk(this.name + "_pillar"), (ItemLike)this.pillar).shape(new String[]{"#", "#"}).addMaterial('#', new ItemLike[]{this.slab}).group("end_pillar").build(context);
        RecipeBuilder.crafting((ResourceLocation)BetterEnd.C.mk(this.name + "_stairs"), (ItemLike)this.stairs).outputCount(4).shape(new String[]{"#  ", "## ", "###"}).addMaterial('#', new ItemLike[]{this.stone}).group("end_stone_stairs").build(context);
        RecipeBuilder.crafting((ResourceLocation)BetterEnd.C.mk(this.name + "_slab"), (ItemLike)this.slab).outputCount(6).shape(new String[]{"###"}).addMaterial('#', new ItemLike[]{this.stone}).group("end_stone_slabs").build(context);
        RecipeBuilder.crafting((ResourceLocation)BetterEnd.C.mk(this.name + "_bricks_stairs"), (ItemLike)this.brickStairs).outputCount(4).shape(new String[]{"#  ", "## ", "###"}).addMaterial('#', new ItemLike[]{this.bricks}).group("end_stone_stairs").build(context);
        RecipeBuilder.crafting((ResourceLocation)BetterEnd.C.mk(this.name + "_bricks_slab"), (ItemLike)this.brickSlab).outputCount(6).shape(new String[]{"###"}).addMaterial('#', new ItemLike[]{this.bricks}).group("end_stone_slabs").build(context);
        RecipeBuilder.crafting((ResourceLocation)BetterEnd.C.mk(this.name + "_wall"), (ItemLike)this.wall).outputCount(6).shape(new String[]{"###", "###"}).addMaterial('#', new ItemLike[]{this.stone}).group("end_wall").build(context);
        RecipeBuilder.crafting((ResourceLocation)BetterEnd.C.mk(this.name + "_bricks_wall"), (ItemLike)this.brickWall).outputCount(6).shape(new String[]{"###", "###"}).addMaterial('#', new ItemLike[]{this.bricks}).group("end_wall").build(context);
        RecipeBuilder.crafting((ResourceLocation)BetterEnd.C.mk(this.name + "_button"), (ItemLike)this.button).shapeless().addMaterial('#', new ItemLike[]{this.stone}).group("end_stone_buttons").build(context);
        RecipeBuilder.crafting((ResourceLocation)BetterEnd.C.mk(this.name + "_pressure_plate"), (ItemLike)this.pressurePlate).shape(new String[]{"##"}).addMaterial('#', new ItemLike[]{this.stone}).group("end_stone_plates").build(context);
        RecipeBuilder.crafting((ResourceLocation)BetterEnd.C.mk(this.name + "_lantern"), (ItemLike)this.lantern).shape(new String[]{"S", "#", "S"}).addMaterial('#', new ItemLike[]{EndItems.CRYSTAL_SHARDS}).addMaterial('S', new ItemLike[]{this.slab, this.brickSlab}).group("end_stone_lanterns").build(context);
        RecipeBuilder.crafting((ResourceLocation)BetterEnd.C.mk(this.name + "_furnace"), (ItemLike)this.furnace).shape(new String[]{"###", "# #", "###"}).addMaterial('#', new ItemLike[]{this.stone}).group("end_stone_ITEM_FURNACES").build(context);
        RecipeBuilder.crafting((ResourceLocation)BetterEnd.C.mk(this.name + "_flower_pot"), (ItemLike)this.flowerPot).outputCount(3).shape(new String[]{"# #", " # "}).addMaterial('#', new ItemLike[]{this.bricks}).group("end_pots").build(context);
        EndCraftingRecipesProvider.registerPedestal(context, this.name + "_pedestal", this.pedestal, this.slab, this.pillar);
        StoneMaterial.recipesForStoneMaterial(context, this);
    }

    @Override
    public void registerBlockTags(TagBootstrapContext<Block> context) {
        context.add(BlockTags.STONE_BRICKS, (Object[])new Block[]{this.bricks});
        context.add(BlockTags.WALLS, (Object[])new Block[]{this.wall, this.brickWall});
        context.add(BlockTags.SLABS, (Object[])new Block[]{this.slab, this.brickSlab});
        context.add((Object)this.pressurePlate, new TagKey[]{BlockTags.PRESSURE_PLATES, BlockTags.STONE_PRESSURE_PLATES});
        context.add(CommonBlockTags.END_STONES, (Object[])new Block[]{this.stone});
        context.add(BlockTags.DRAGON_IMMUNE, (Object[])new Block[]{this.stone, this.stairs, this.slab, this.wall});
        context.add(CommonBlockTags.END_STONES, (Object[])new Block[]{this.stone});
        context.add(CommonBlockTags.END_STONES, (Object[])new Block[]{this.stone});
    }

    @Override
    public void registerItemTags(ItemTagBootstrapContext context) {
        context.add(ItemTags.SLABS, (Object[])new Item[]{this.slab.asItem(), this.brickSlab.asItem()});
        context.add(ItemTags.STONE_BRICKS, (Object[])new Item[]{this.bricks.asItem()});
        context.add(ItemTags.STONE_CRAFTING_MATERIALS, (Object[])new Item[]{this.stone.asItem()});
        context.add(ItemTags.STONE_TOOL_MATERIALS, (Object[])new Item[]{this.stone.asItem()});
        context.add(CommonItemTags.FURNACES, (Object[])new Item[]{this.furnace.asItem()});
    }
}

