/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.complexmaterials;

import java.util.function.Supplier;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SmithingTemplateItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.material.MapColor;
import org.betterx.bclib.blocks.BaseBarsBlock;
import org.betterx.bclib.blocks.BaseBlock;
import org.betterx.bclib.blocks.BaseChainBlock;
import org.betterx.bclib.blocks.BaseDoorBlock;
import org.betterx.bclib.blocks.BaseOreBlock;
import org.betterx.bclib.blocks.BasePressurePlateBlock;
import org.betterx.bclib.blocks.BaseSlabBlock;
import org.betterx.bclib.blocks.BaseStairsBlock;
import org.betterx.bclib.blocks.BaseTrapdoorBlock;
import org.betterx.bclib.items.ModelProviderItem;
import org.betterx.bclib.items.tool.BaseAxeItem;
import org.betterx.bclib.items.tool.BaseHoeItem;
import org.betterx.bclib.items.tool.BaseShovelItem;
import org.betterx.bclib.items.tool.BaseSwordItem;
import org.betterx.bclib.recipes.BCLRecipeBuilder;
import org.betterx.betterend.BetterEnd;
import org.betterx.betterend.blocks.BulbVineLanternBlock;
import org.betterx.betterend.blocks.BulbVineLanternColoredBlock;
import org.betterx.betterend.blocks.ChandelierBlock;
import org.betterx.betterend.blocks.basis.EndAnvilBlock;
import org.betterx.betterend.complexmaterials.ColoredMaterial;
import org.betterx.betterend.complexmaterials.MaterialManager;
import org.betterx.betterend.item.EndArmorItem;
import org.betterx.betterend.item.tool.EndHammerItem;
import org.betterx.betterend.item.tool.EndPickaxe;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.betterend.registry.EndItems;
import org.betterx.betterend.registry.EndTemplates;
import org.betterx.wover.complex.api.equipment.ArmorSlot;
import org.betterx.wover.complex.api.equipment.ArmorTier;
import org.betterx.wover.recipe.api.RecipeBuilder;
import org.betterx.wover.tag.api.TagManager;
import org.betterx.wover.tag.api.event.context.ItemTagBootstrapContext;
import org.betterx.wover.tag.api.event.context.TagBootstrapContext;

public class MetalMaterial
implements MaterialManager.Material {
    public final Block ore;
    public final Block block;
    public final Block tile;
    public final Block bars;
    public final Block pressurePlate;
    public final Block door;
    public final Block trapdoor;
    public final Block chain;
    public final Block stairs;
    public final Block slab;
    public final Block chandelier;
    public final Block bulb_lantern;
    public final ColoredMaterial bulb_lantern_colored;
    public final Block anvilBlock;
    public final Item rawOre;
    public final Item nugget;
    public final Item ingot;
    public final Item shovelHead;
    public final Item pickaxeHead;
    public final Item axeHead;
    public final Item hoeHead;
    public final Item swordBlade;
    public final Item swordHandle;
    public final Item shovel;
    public final Item sword;
    public final Item pickaxe;
    public final Item axe;
    public final Item hoe;
    public final Item hammer;
    public final Item forgedPlate;
    public final Item helmet;
    public final Item chestplate;
    public final Item leggings;
    public final Item boots;
    public final TagKey<Item> alloyingOre;
    public final SmithingTemplateItem swordHandleTemplate;
    public final boolean hasOre;
    public final String name;
    public final int anvilLevel;
    public final TagKey<Item> anvilTools;

    public static MetalMaterial makeNormal(String name, MapColor color, Tier material, ArmorTier armor, int anvilLevel, TagKey<Item> anvilTools, SmithingTemplateItem swordHandleTemplate) {
        return new MetalMaterial(name, true, () -> BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).mapColor(color), EndItems.makeEndItemSettings(), material, armor, anvilLevel, anvilTools, swordHandleTemplate);
    }

    public static MetalMaterial makeOreless(String name, MapColor color, float hardness, float resistance, Tier material, ArmorTier armor, int anvilLevel, TagKey<Item> anvilTools, SmithingTemplateItem swordHandleTemplate) {
        return new MetalMaterial(name, false, () -> BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).mapColor(color).destroyTime(hardness).explosionResistance(resistance), EndItems.makeEndItemSettings(), material, armor, anvilLevel, anvilTools, swordHandleTemplate);
    }

    private MetalMaterial(String name, boolean hasOre, Supplier<BlockBehaviour.Properties> settingsSupplier, Item.Properties itemSettings, Tier material, ArmorTier armor, int anvilLevel, TagKey<Item> anvilTools, SmithingTemplateItem swordHandleTemplate) {
        BlockBehaviour.Properties settings = settingsSupplier.get();
        BlockBehaviour.Properties lanternProperties = settingsSupplier.get().destroyTime(1.0f).explosionResistance(1.0f).lightLevel(bs -> 15).sound(SoundType.LANTERN);
        this.anvilLevel = anvilLevel;
        this.anvilTools = anvilTools;
        this.hasOre = hasOre;
        this.name = name;
        this.swordHandleTemplate = swordHandleTemplate;
        this.rawOre = hasOre ? EndItems.registerEndItem(name + "_raw", (Item)new ModelProviderItem(itemSettings)) : null;
        this.ore = hasOre ? EndBlocks.registerBlock(name + "_ore", new BaseOreBlock(() -> this.rawOre, 1, 3, 1), new TagKey[0]) : null;
        this.alloyingOre = hasOre ? TagManager.ITEMS.makeTag(BetterEnd.C, name + "_alloying") : null;
        this.block = EndBlocks.registerBlock(name + "_block", new BaseBlock.Metal(settings), new TagKey[0]);
        this.tile = EndBlocks.registerBlock(name + "_tile", new BaseBlock.Metal(settings), new TagKey[0]);
        this.stairs = EndBlocks.registerBlock(name + "_stairs", new BaseStairsBlock.Metal(this.tile), new TagKey[0]);
        this.slab = EndBlocks.registerBlock(name + "_slab", new BaseSlabBlock.Metal(this.tile), new TagKey[0]);
        this.door = EndBlocks.registerBlock(name + "_door", new BaseDoorBlock.Metal(this.block, BlockSetType.IRON), new TagKey[0]);
        this.trapdoor = EndBlocks.registerBlock(name + "_trapdoor", new BaseTrapdoorBlock.Metal(this.block, BlockSetType.IRON), new TagKey[0]);
        this.bars = EndBlocks.registerBlock(name + "_bars", new BaseBarsBlock.Metal(this.block), new TagKey[0]);
        this.chain = EndBlocks.registerBlock(name + "_chain", new BaseChainBlock.Metal(this.block.defaultMapColor()), new TagKey[0]);
        this.pressurePlate = EndBlocks.registerBlock(name + "_plate", new BasePressurePlateBlock.Wood(this.block, BlockSetType.IRON), new TagKey[0]);
        this.chandelier = EndBlocks.registerBlock(name + "_chandelier", new ChandelierBlock(this.block), new TagKey[0]);
        this.bulb_lantern = EndBlocks.registerBlock(name + "_bulb_lantern", new BulbVineLanternBlock(lanternProperties), new TagKey[0]);
        this.bulb_lantern_colored = new ColoredMaterial(BulbVineLanternColoredBlock::new, this.bulb_lantern, false);
        this.nugget = EndItems.registerEndItem(name + "_nugget", (Item)new ModelProviderItem(itemSettings));
        this.ingot = EndItems.registerEndItem(name + "_ingot", (Item)new ModelProviderItem(itemSettings));
        this.shovelHead = EndItems.registerEndItem(name + "_shovel_head");
        this.pickaxeHead = EndItems.registerEndItem(name + "_pickaxe_head");
        this.axeHead = EndItems.registerEndItem(name + "_axe_head");
        this.hoeHead = EndItems.registerEndItem(name + "_hoe_head");
        this.swordBlade = EndItems.registerEndItem(name + "_sword_blade");
        this.swordHandle = EndItems.registerEndItem(name + "_sword_handle");
        this.shovel = EndItems.registerEndTool(name + "_shovel", (TieredItem)new BaseShovelItem(material, 1.5f, -3.0f, itemSettings));
        this.sword = EndItems.registerEndTool(name + "_sword", (TieredItem)new BaseSwordItem(material, 3, -2.4f, itemSettings));
        this.pickaxe = EndItems.registerEndTool(name + "_pickaxe", (TieredItem)new EndPickaxe(material, 1, -2.8f, itemSettings));
        this.axe = EndItems.registerEndTool(name + "_axe", (TieredItem)new BaseAxeItem(material, 6.0f, -3.0f, itemSettings));
        this.hoe = EndItems.registerEndTool(name + "_hoe", (TieredItem)new BaseHoeItem(material, -3, 0.0f, itemSettings));
        this.hammer = EndItems.registerEndTool(name + "_hammer", (TieredItem)new EndHammerItem(material, 5.0f, -3.2f, 0.3f, itemSettings));
        this.forgedPlate = EndItems.registerEndItem(name + "_forged_plate");
        this.helmet = EndItems.registerEndItem(name + "_helmet", (Item)new EndArmorItem(armor, ArmorSlot.HELMET_SLOT, itemSettings));
        this.chestplate = EndItems.registerEndItem(name + "_chestplate", (Item)new EndArmorItem(armor, ArmorSlot.CHESTPLATE_SLOT, itemSettings));
        this.leggings = EndItems.registerEndItem(name + "_leggings", (Item)new EndArmorItem(armor, ArmorSlot.LEGGINGS_SLOT, itemSettings));
        this.boots = EndItems.registerEndItem(name + "_boots", (Item)new EndArmorItem(armor, ArmorSlot.BOOTS_SLOT, itemSettings));
        this.anvilBlock = EndBlocks.registerBlock(name + "_anvil", new EndAnvilBlock(this, this.block.defaultMapColor(), anvilLevel), new TagKey[0]);
        MaterialManager.register(this);
    }

    @Override
    public void registerRecipes(RecipeOutput context) {
        if (this.hasOre) {
            RecipeBuilder.blasting((ResourceLocation)BetterEnd.C.mk(this.name + "_ingot_furnace_ore"), (ItemLike)this.ingot).input((ItemLike)this.ore).build(context);
            RecipeBuilder.blasting((ResourceLocation)BetterEnd.C.mk(this.name + "_ingot_furnace_raw"), (ItemLike)this.ingot).input((ItemLike)this.rawOre).build(context);
            BCLRecipeBuilder.alloying((ResourceLocation)BetterEnd.C.mk(this.name + "_ingot_alloy"), (ItemLike)this.ingot).setInput(this.alloyingOre, this.alloyingOre).outputCount(3).setExperience(2.1f).build(context);
        }
        RecipeBuilder.crafting((ResourceLocation)BetterEnd.C.mk(this.name + "_ingot_from_nuggets"), (ItemLike)this.ingot).shape(new String[]{"###", "###", "###"}).addMaterial('#', new ItemLike[]{this.nugget}).group("end_metal_ingots_nug").build(context);
        RecipeBuilder.crafting((ResourceLocation)BetterEnd.C.mk(this.name + "_nuggets_from_ingot"), (ItemLike)this.nugget).outputCount(9).shapeless().addMaterial('#', new ItemLike[]{this.ingot}).group("end_metal_nuggets_ing").build(context);
        RecipeBuilder.crafting((ResourceLocation)BetterEnd.C.mk(this.name + "_block"), (ItemLike)this.block).shape(new String[]{"###", "###", "###"}).addMaterial('#', new ItemLike[]{this.ingot}).group("end_metal_blocks").build(context);
        RecipeBuilder.crafting((ResourceLocation)BetterEnd.C.mk(this.name + "_ingot_from_block"), (ItemLike)this.ingot).outputCount(9).shapeless().addMaterial('#', new ItemLike[]{this.block}).group("end_metal_ingots").build(context);
        RecipeBuilder.crafting((ResourceLocation)BetterEnd.C.mk(this.name + "_tile"), (ItemLike)this.tile).outputCount(4).shape(new String[]{"##", "##"}).addMaterial('#', new ItemLike[]{this.block}).group("end_metal_tiles").build(context);
        RecipeBuilder.crafting((ResourceLocation)BetterEnd.C.mk(this.name + "_bars"), (ItemLike)this.bars).outputCount(16).shape(new String[]{"###", "###"}).addMaterial('#', new ItemLike[]{this.ingot}).group("end_metal_bars").build(context);
        RecipeBuilder.crafting((ResourceLocation)BetterEnd.C.mk(this.name + "_pressure_plate"), (ItemLike)this.pressurePlate).shape(new String[]{"##"}).addMaterial('#', new ItemLike[]{this.ingot}).group("end_metal_plates").build(context);
        RecipeBuilder.crafting((ResourceLocation)BetterEnd.C.mk(this.name + "_door"), (ItemLike)this.door).outputCount(3).shape(new String[]{"##", "##", "##"}).addMaterial('#', new ItemLike[]{this.ingot}).group("end_metal_doors").build(context);
        RecipeBuilder.crafting((ResourceLocation)BetterEnd.C.mk(this.name + "_trapdoor"), (ItemLike)this.trapdoor).shape(new String[]{"##", "##"}).addMaterial('#', new ItemLike[]{this.ingot}).group("end_metal_trapdoors").build(context);
        RecipeBuilder.crafting((ResourceLocation)BetterEnd.C.mk(this.name + "_stairs"), (ItemLike)this.stairs).outputCount(4).shape(new String[]{"#  ", "## ", "###"}).addMaterial('#', new ItemLike[]{this.block, this.tile}).group("end_metal_stairs").build(context);
        RecipeBuilder.crafting((ResourceLocation)BetterEnd.C.mk(this.name + "_slab"), (ItemLike)this.slab).outputCount(6).shape(new String[]{"###"}).addMaterial('#', new ItemLike[]{this.block, this.tile}).group("end_metal_slabs").build(context);
        RecipeBuilder.crafting((ResourceLocation)BetterEnd.C.mk(this.name + "_chain"), (ItemLike)this.chain).shape(new String[]{"N", "#", "N"}).addMaterial('#', new ItemLike[]{this.ingot}).addMaterial('N', new ItemLike[]{this.nugget}).group("end_metal_chain").build(context);
        RecipeBuilder.crafting((ResourceLocation)BetterEnd.C.mk(this.name + "_anvil"), (ItemLike)this.anvilBlock).shape(new String[]{"###", " I ", "III"}).addMaterial('#', new ItemLike[]{this.block, this.tile}).addMaterial('I', new ItemLike[]{this.ingot}).group("end_metal_anvil").build(context);
        RecipeBuilder.crafting((ResourceLocation)BetterEnd.C.mk(this.name + "_bulb_lantern"), (ItemLike)this.bulb_lantern).shape(new String[]{"C", "I", "#"}).addMaterial('C', new ItemLike[]{this.chain}).addMaterial('I', new ItemLike[]{this.ingot}).addMaterial('#', new ItemLike[]{EndItems.GLOWING_BULB}).build(context);
        RecipeBuilder.crafting((ResourceLocation)BetterEnd.C.mk(this.name + "_chandelier"), (ItemLike)this.chandelier).shape(new String[]{"I#I", " # "}).addMaterial('#', new ItemLike[]{this.ingot}).addMaterial('I', new ItemLike[]{EndItems.LUMECORN_ROD}).group("end_metal_chandelier").build(context);
        RecipeBuilder.blasting((ResourceLocation)BetterEnd.C.mk(this.name + "_axe_nugget"), (ItemLike)this.nugget).input((ItemLike)this.axe).build(context);
        RecipeBuilder.blasting((ResourceLocation)BetterEnd.C.mk(this.name + "_hoe_nugget"), (ItemLike)this.nugget).input((ItemLike)this.hoe).build(context);
        RecipeBuilder.blasting((ResourceLocation)BetterEnd.C.mk(this.name + "_pickaxe_nugget"), (ItemLike)this.nugget).input((ItemLike)this.pickaxe).build(context);
        RecipeBuilder.blasting((ResourceLocation)BetterEnd.C.mk(this.name + "_sword_nugget"), (ItemLike)this.nugget).input((ItemLike)this.sword).build(context);
        RecipeBuilder.blasting((ResourceLocation)BetterEnd.C.mk(this.name + "_hammer_nugget"), (ItemLike)this.nugget).input((ItemLike)this.hammer).build(context);
        RecipeBuilder.blasting((ResourceLocation)BetterEnd.C.mk(this.name + "_helmet_nugget"), (ItemLike)this.nugget).input((ItemLike)this.helmet).build(context);
        RecipeBuilder.blasting((ResourceLocation)BetterEnd.C.mk(this.name + "_chestplate_nugget"), (ItemLike)this.nugget).input((ItemLike)this.chestplate).build(context);
        RecipeBuilder.blasting((ResourceLocation)BetterEnd.C.mk(this.name + "_leggings_nugget"), (ItemLike)this.nugget).input((ItemLike)this.leggings).build(context);
        RecipeBuilder.blasting((ResourceLocation)BetterEnd.C.mk(this.name + "_boots_nugget"), (ItemLike)this.nugget).input((ItemLike)this.boots).build(context);
        BCLRecipeBuilder.anvil((ResourceLocation)BetterEnd.C.mk(this.name + "_shovel_head"), (ItemLike)this.shovelHead).setPrimaryInput(new ItemLike[]{this.ingot}).setAnvilLevel(this.anvilLevel).setAllowedTools(this.anvilTools).setDamage(this.anvilLevel).build(context);
        BCLRecipeBuilder.anvil((ResourceLocation)BetterEnd.C.mk(this.name + "_pickaxe_head"), (ItemLike)this.pickaxeHead).setPrimaryInput(new ItemLike[]{this.ingot}).setInputCount(3).setAnvilLevel(this.anvilLevel).setAllowedTools(this.anvilTools).setDamage(this.anvilLevel).build(context);
        BCLRecipeBuilder.anvil((ResourceLocation)BetterEnd.C.mk(this.name + "_axe_head"), (ItemLike)this.axeHead).setPrimaryInput(new ItemLike[]{this.ingot}).setInputCount(3).setAnvilLevel(this.anvilLevel).setAllowedTools(this.anvilTools).setDamage(this.anvilLevel).build(context);
        BCLRecipeBuilder.anvil((ResourceLocation)BetterEnd.C.mk(this.name + "_hoe_head"), (ItemLike)this.hoeHead).setPrimaryInput(new ItemLike[]{this.ingot}).setInputCount(2).setAnvilLevel(this.anvilLevel).setAllowedTools(this.anvilTools).setDamage(this.anvilLevel).build(context);
        BCLRecipeBuilder.anvil((ResourceLocation)BetterEnd.C.mk(this.name + "_sword_blade"), (ItemLike)this.swordBlade).setPrimaryInput(new ItemLike[]{this.ingot}).setAnvilLevel(this.anvilLevel).setAllowedTools(this.anvilTools).setDamage(this.anvilLevel).build(context);
        BCLRecipeBuilder.anvil((ResourceLocation)BetterEnd.C.mk(this.name + "_forged_plate"), (ItemLike)this.forgedPlate).setPrimaryInput(new ItemLike[]{this.ingot}).setAnvilLevel(this.anvilLevel).setAllowedTools(this.anvilTools).setDamage(this.anvilLevel).build(context);
        RecipeBuilder.smithing((ResourceLocation)BetterEnd.C.mk(this.name + "_hammer"), (ItemLike)this.hammer).template(EndTemplates.HANDLE_ATTACHMENT).base((ItemLike)this.block).addon((ItemLike)Items.STICK).build(context);
        RecipeBuilder.smithing((ResourceLocation)BetterEnd.C.mk(this.name + "_axe"), (ItemLike)this.axe).template(EndTemplates.HANDLE_ATTACHMENT).base((ItemLike)this.axeHead).addon((ItemLike)Items.STICK).build(context);
        RecipeBuilder.smithing((ResourceLocation)BetterEnd.C.mk(this.name + "_pickaxe"), (ItemLike)this.pickaxe).template(EndTemplates.HANDLE_ATTACHMENT).base((ItemLike)this.pickaxeHead).addon((ItemLike)Items.STICK).build(context);
        RecipeBuilder.smithing((ResourceLocation)BetterEnd.C.mk(this.name + "_hoe"), (ItemLike)this.hoe).template(EndTemplates.HANDLE_ATTACHMENT).base((ItemLike)this.hoeHead).addon((ItemLike)Items.STICK).build(context);
        RecipeBuilder.smithing((ResourceLocation)BetterEnd.C.mk(this.name + "_sword_handle"), (ItemLike)this.swordHandle).template(this.swordHandleTemplate).base((ItemLike)Items.STICK).addon((ItemLike)this.ingot).build(context);
        RecipeBuilder.smithing((ResourceLocation)BetterEnd.C.mk(this.name + "_sword"), (ItemLike)this.sword).template(EndTemplates.TOOL_ASSEMBLY).base((ItemLike)this.swordBlade).addon((ItemLike)this.swordHandle).build(context);
        RecipeBuilder.smithing((ResourceLocation)BetterEnd.C.mk(this.name + "_shovel"), (ItemLike)this.shovel).template(EndTemplates.HANDLE_ATTACHMENT).base((ItemLike)this.shovelHead).addon((ItemLike)Items.STICK).build(context);
        RecipeBuilder.crafting((ResourceLocation)BetterEnd.C.mk(this.name + "_helmet"), (ItemLike)this.helmet).shape(new String[]{"###", "# #"}).addMaterial('#', new ItemLike[]{this.forgedPlate}).group("end_metal_helmets").build(context);
        RecipeBuilder.crafting((ResourceLocation)BetterEnd.C.mk(this.name + "_chestplate"), (ItemLike)this.chestplate).shape(new String[]{"# #", "###", "###"}).addMaterial('#', new ItemLike[]{this.forgedPlate}).group("end_metal_chestplates").build(context);
        RecipeBuilder.crafting((ResourceLocation)BetterEnd.C.mk(this.name + "_leggings"), (ItemLike)this.leggings).shape(new String[]{"###", "# #", "# #"}).addMaterial('#', new ItemLike[]{this.forgedPlate}).group("end_metal_leggings").build(context);
        RecipeBuilder.crafting((ResourceLocation)BetterEnd.C.mk(this.name + "_boots"), (ItemLike)this.boots).shape(new String[]{"# #", "# #"}).addMaterial('#', new ItemLike[]{this.forgedPlate}).group("end_metal_boots").build(context);
    }

    @Override
    public void registerBlockTags(TagBootstrapContext<Block> context) {
        context.add(BlockTags.ANVIL, (Object[])new Block[]{this.anvilBlock});
        context.add(BlockTags.BEACON_BASE_BLOCKS, (Object[])new Block[]{this.block});
        context.add(BlockTags.DRAGON_IMMUNE, (Object[])new Block[]{this.ore, this.bars});
    }

    @Override
    public void registerItemTags(ItemTagBootstrapContext context) {
        context.add(ItemTags.BEACON_PAYMENT_ITEMS, (Object[])new Item[]{this.ingot});
        if (this.alloyingOre != null) {
            context.add(this.alloyingOre, (Object[])new Item[]{this.ore.asItem(), this.rawOre});
        }
    }
}

