/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.complexmaterials;

import java.util.function.Consumer;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.MapColor;
import org.betterx.bclib.complexmaterials.ComplexMaterial;
import org.betterx.bclib.complexmaterials.WoodenComplexMaterial;
import org.betterx.bclib.complexmaterials.entry.MaterialSlot;
import org.betterx.bclib.complexmaterials.entry.RecipeEntry;
import org.betterx.bclib.complexmaterials.entry.SlotMap;
import org.betterx.bclib.complexmaterials.set.wood.HangingSign;
import org.betterx.bclib.complexmaterials.set.wood.WoodSlots;
import org.betterx.betterend.complexmaterials.EndWoodenComplexMaterial;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.wover.recipe.api.CraftingRecipeBuilder;
import org.betterx.wover.recipe.api.RecipeBuilder;
import org.jetbrains.annotations.Nullable;

public class JellyLucerniaWoodMaterial
extends EndWoodenComplexMaterial {
    public JellyLucerniaWoodMaterial() {
        super("lucernia_jellyshroom", MapColor.COLOR_PURPLE, MapColor.COLOR_ORANGE, Blocks.BROWN_WOOL);
    }

    @Override
    protected SlotMap<WoodenComplexMaterial> createMaterialSlots() {
        return SlotMap.of((MaterialSlot[])new MaterialSlot[]{new HangingSign(this){

            public void addRecipeEntry(WoodenComplexMaterial parentMaterial, Consumer<RecipeEntry> adder) {
                adder.accept(new RecipeEntry(this.suffix, (ctx, mat, id) -> {
                    CraftingRecipeBuilder craftingRecipeBuilder1 = RecipeBuilder.crafting((ResourceLocation)id, (ItemLike)parentMaterial.getBlock(this.suffix));
                    CraftingRecipeBuilder craftingRecipeBuilder2 = craftingRecipeBuilder1.outputCount(3);
                    CraftingRecipeBuilder craftingRecipeBuilder = craftingRecipeBuilder2.shape(new String[]{"I I", "o#o", "o#o"}).addMaterial('#', new ItemLike[]{EndBlocks.LUCERNIA.getBlock(WoodSlots.STRIPPED_LOG)}).addMaterial('o', new ItemLike[]{EndBlocks.JELLYSHROOM.getBlock(WoodSlots.LOG)}).addMaterial('I', new ItemLike[]{Items.CHAIN});
                    ((CraftingRecipeBuilder)craftingRecipeBuilder.group("sign").setCategory(RecipeCategory.DECORATIONS)).build(ctx);
                }));
            }
        }});
    }

    @Nullable
    public <M extends ComplexMaterial> Block getBlock(MaterialSlot<M> key) {
        if (key == WoodSlots.PLANKS || key == WoodSlots.SLAB) {
            return EndBlocks.LUCERNIA.getBlock(WoodSlots.PLANKS);
        }
        return super.getBlock(key);
    }
}

