/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.complexmaterials;

import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import org.betterx.bclib.blocks.BaseSlabBlock;
import org.betterx.bclib.blocks.BaseStairsBlock;
import org.betterx.bclib.blocks.BaseWallBlock;
import org.betterx.betterend.BetterEnd;
import org.betterx.betterend.blocks.EndPedestal;
import org.betterx.betterend.blocks.basis.LitBaseBlock;
import org.betterx.betterend.blocks.basis.LitPillarBlock;
import org.betterx.betterend.complexmaterials.MaterialManager;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.datagen.betterend.recipes.EndCraftingRecipesProvider;
import org.betterx.wover.recipe.api.CraftingRecipeBuilder;
import org.betterx.wover.recipe.api.RecipeBuilder;
import org.betterx.wover.tag.api.event.context.ItemTagBootstrapContext;
import org.betterx.wover.tag.api.event.context.TagBootstrapContext;

public class CrystalSubblocksMaterial
implements MaterialManager.Material {
    public final Block polished;
    public final Block tiles;
    public final Block pillar;
    public final Block stairs;
    public final Block slab;
    public final Block wall;
    public final Block pedestal;
    public final Block bricks;
    public final Block brick_stairs;
    public final Block brick_slab;
    public final Block brick_wall;
    private final Block source;
    private final String name;

    public CrystalSubblocksMaterial(String name, Block source) {
        this.source = source;
        this.name = name;
        BlockBehaviour.Properties material = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)source);
        this.polished = EndBlocks.registerBlock(name + "_polished", new LitBaseBlock(material), new TagKey[0]);
        this.tiles = EndBlocks.registerBlock(name + "_tiles", new LitBaseBlock(material), new TagKey[0]);
        this.pillar = EndBlocks.registerBlock(name + "_pillar", new LitPillarBlock(material), new TagKey[0]);
        this.stairs = EndBlocks.registerBlock(name + "_stairs", new BaseStairsBlock.Stone(source), new TagKey[0]);
        this.slab = EndBlocks.registerBlock(name + "_slab", new BaseSlabBlock.Stone(source), new TagKey[0]);
        this.wall = EndBlocks.registerBlock(name + "_wall", new BaseWallBlock.Stone(source), new TagKey[0]);
        this.pedestal = EndBlocks.registerBlock(name + "_pedestal", new EndPedestal.Stone(source), new TagKey[0]);
        this.bricks = EndBlocks.registerBlock(name + "_bricks", new LitBaseBlock(material), new TagKey[0]);
        this.brick_stairs = EndBlocks.registerBlock(name + "_bricks_stairs", new BaseStairsBlock.Stone(this.bricks), new TagKey[0]);
        this.brick_slab = EndBlocks.registerBlock(name + "_bricks_slab", new BaseSlabBlock.Stone(this.bricks), new TagKey[0]);
        this.brick_wall = EndBlocks.registerBlock(name + "_bricks_wall", new BaseWallBlock.Stone(this.bricks), new TagKey[0]);
        MaterialManager.register(this);
    }

    @Override
    public void registerBlockTags(TagBootstrapContext<Block> context) {
        context.add(BlockTags.STONE_BRICKS, (Object[])new Block[]{this.bricks});
        context.add(BlockTags.WALLS, (Object[])new Block[]{this.wall, this.brick_wall});
        context.add(BlockTags.SLABS, (Object[])new Block[]{this.slab, this.brick_slab});
    }

    @Override
    public void registerItemTags(ItemTagBootstrapContext context) {
        context.add(ItemTags.SLABS, (Object[])new Item[]{this.slab.asItem(), this.brick_slab.asItem()});
        context.add(ItemTags.STONE_BRICKS, (Object[])new Item[]{this.bricks.asItem()});
        context.add(ItemTags.STONE_CRAFTING_MATERIALS, (Object[])new Item[]{this.source.asItem()});
        context.add(ItemTags.STONE_TOOL_MATERIALS, (Object[])new Item[]{this.source.asItem()});
    }

    @Override
    public void registerRecipes(RecipeOutput context) {
        CraftingRecipeBuilder craftingRecipeBuilder18 = RecipeBuilder.crafting((ResourceLocation)BetterEnd.C.mk(this.name + "_bricks"), (ItemLike)this.bricks);
        CraftingRecipeBuilder craftingRecipeBuilder28 = craftingRecipeBuilder18.outputCount(4);
        CraftingRecipeBuilder craftingRecipeBuilder9 = craftingRecipeBuilder28.shape(new String[]{"##", "##"}).addMaterial('#', new ItemLike[]{this.source});
        craftingRecipeBuilder9.group("end_bricks").build(context);
        CraftingRecipeBuilder craftingRecipeBuilder17 = RecipeBuilder.crafting((ResourceLocation)BetterEnd.C.mk(this.name + "_polished"), (ItemLike)this.polished);
        CraftingRecipeBuilder craftingRecipeBuilder27 = craftingRecipeBuilder17.outputCount(4);
        CraftingRecipeBuilder craftingRecipeBuilder8 = craftingRecipeBuilder27.shape(new String[]{"##", "##"}).addMaterial('#', new ItemLike[]{this.bricks});
        craftingRecipeBuilder8.group("end_tile").build(context);
        CraftingRecipeBuilder craftingRecipeBuilder16 = RecipeBuilder.crafting((ResourceLocation)BetterEnd.C.mk(this.name + "_tiles"), (ItemLike)this.tiles);
        CraftingRecipeBuilder craftingRecipeBuilder26 = craftingRecipeBuilder16.outputCount(4);
        CraftingRecipeBuilder craftingRecipeBuilder7 = craftingRecipeBuilder26.shape(new String[]{"##", "##"}).addMaterial('#', new ItemLike[]{this.polished});
        craftingRecipeBuilder7.group("end_small_tile").build(context);
        CraftingRecipeBuilder craftingRecipeBuilder25 = RecipeBuilder.crafting((ResourceLocation)BetterEnd.C.mk(this.name + "_pillar"), (ItemLike)this.pillar);
        CraftingRecipeBuilder craftingRecipeBuilder6 = craftingRecipeBuilder25.shape(new String[]{"#", "#"}).addMaterial('#', new ItemLike[]{this.slab});
        craftingRecipeBuilder6.group("end_pillar").build(context);
        CraftingRecipeBuilder craftingRecipeBuilder15 = RecipeBuilder.crafting((ResourceLocation)BetterEnd.C.mk(this.name + "_stairs"), (ItemLike)this.stairs);
        CraftingRecipeBuilder craftingRecipeBuilder24 = craftingRecipeBuilder15.outputCount(4);
        CraftingRecipeBuilder craftingRecipeBuilder5 = craftingRecipeBuilder24.shape(new String[]{"#  ", "## ", "###"}).addMaterial('#', new ItemLike[]{this.source});
        craftingRecipeBuilder5.group("end_stone_stairs").build(context);
        CraftingRecipeBuilder craftingRecipeBuilder14 = RecipeBuilder.crafting((ResourceLocation)BetterEnd.C.mk(this.name + "_slab"), (ItemLike)this.slab);
        CraftingRecipeBuilder craftingRecipeBuilder23 = craftingRecipeBuilder14.outputCount(6);
        CraftingRecipeBuilder craftingRecipeBuilder4 = craftingRecipeBuilder23.shape(new String[]{"###"}).addMaterial('#', new ItemLike[]{this.source});
        craftingRecipeBuilder4.group("end_stone_slabs").build(context);
        CraftingRecipeBuilder craftingRecipeBuilder13 = RecipeBuilder.crafting((ResourceLocation)BetterEnd.C.mk(this.name + "_bricks_stairs"), (ItemLike)this.brick_stairs);
        CraftingRecipeBuilder craftingRecipeBuilder22 = craftingRecipeBuilder13.outputCount(4);
        CraftingRecipeBuilder craftingRecipeBuilder3 = craftingRecipeBuilder22.shape(new String[]{"#  ", "## ", "###"}).addMaterial('#', new ItemLike[]{this.bricks});
        craftingRecipeBuilder3.group("end_stone_stairs").build(context);
        CraftingRecipeBuilder craftingRecipeBuilder12 = RecipeBuilder.crafting((ResourceLocation)BetterEnd.C.mk(this.name + "_bricks_slab"), (ItemLike)this.brick_slab);
        CraftingRecipeBuilder craftingRecipeBuilder21 = craftingRecipeBuilder12.outputCount(6);
        CraftingRecipeBuilder craftingRecipeBuilder2 = craftingRecipeBuilder21.shape(new String[]{"###"}).addMaterial('#', new ItemLike[]{this.bricks});
        craftingRecipeBuilder2.group("end_stone_slabs").build(context);
        CraftingRecipeBuilder craftingRecipeBuilder11 = RecipeBuilder.crafting((ResourceLocation)BetterEnd.C.mk(this.name + "_wall"), (ItemLike)this.wall);
        CraftingRecipeBuilder craftingRecipeBuilder20 = craftingRecipeBuilder11.outputCount(6);
        CraftingRecipeBuilder craftingRecipeBuilder1 = craftingRecipeBuilder20.shape(new String[]{"###", "###"}).addMaterial('#', new ItemLike[]{this.source});
        craftingRecipeBuilder1.group("end_wall").build(context);
        CraftingRecipeBuilder craftingRecipeBuilder10 = RecipeBuilder.crafting((ResourceLocation)BetterEnd.C.mk(this.name + "_bricks_wall"), (ItemLike)this.brick_wall);
        CraftingRecipeBuilder craftingRecipeBuilder19 = craftingRecipeBuilder10.outputCount(6);
        CraftingRecipeBuilder craftingRecipeBuilder = craftingRecipeBuilder19.shape(new String[]{"###", "###"}).addMaterial('#', new ItemLike[]{this.bricks});
        craftingRecipeBuilder.group("end_wall").build(context);
        EndCraftingRecipesProvider.registerPedestal(context, this.name + "_pedestal", this.pedestal, this.slab, this.pillar);
    }
}

