/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.ambertation.wunderlib.ui.ColorHelper;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.util.Mth;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.betterx.betterend.blocks.EternalPedestal;
import org.betterx.betterend.blocks.basis.PedestalBlock;
import org.betterx.betterend.blocks.entities.PedestalBlockEntity;
import org.betterx.betterend.client.render.BeamRenderer;
import org.betterx.betterend.client.render.EndCrystalRenderer;
import org.betterx.betterend.client.render.EternalCrystalRenderer;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.betterend.registry.EndItems;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class PedestalItemRenderer<T extends PedestalBlockEntity>
implements BlockEntityRenderer<T> {
    public PedestalItemRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(T blockEntity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        Level world = blockEntity.getLevel();
        if (world == null || ((PedestalBlockEntity)((Object)blockEntity)).isEmpty()) {
            return;
        }
        BlockState state = world.getBlockState(blockEntity.getBlockPos());
        if (!(state.getBlock() instanceof PedestalBlock)) {
            return;
        }
        ItemStack activeItem = ((PedestalBlockEntity)((Object)blockEntity)).getItem(0);
        matrices.pushPose();
        Minecraft minecraft = Minecraft.getInstance();
        BakedModel model = minecraft.getItemRenderer().getModel(activeItem, world, null, 0);
        Vector3f translate = model.getTransforms().ground.translation;
        PedestalBlock pedestal = (PedestalBlock)state.getBlock();
        matrices.translate((double)translate.x() + 0.5, (double)(translate.y() + pedestal.getHeight(state)), (double)translate.z() + 0.5);
        if (activeItem.getItem() instanceof BlockItem) {
            matrices.scale(1.5f, 1.5f, 1.5f);
        } else {
            matrices.scale(1.25f, 1.25f, 1.25f);
        }
        int age = PedestalItemRenderer.getGemAge();
        if (state.is(EndBlocks.ETERNAL_PEDESTAL) && ((Boolean)state.getValue((Property)EternalPedestal.ACTIVATED)).booleanValue()) {
            float[] colors = ColorHelper.toFloatArrayRGBA((int)EternalCrystalRenderer.colors(age));
            int y = blockEntity.getBlockPos().getY();
            BeamRenderer.renderLightBeam(matrices, vertexConsumers, age, tickDelta, -y, 1024 - y, colors, 0.25f, 0.13f, 0.16f);
            float altitude = Mth.sin((float)(((float)age + tickDelta) / 10.0f)) * 0.1f + 0.1f;
            matrices.translate(0.0, (double)altitude, 0.0);
        }
        if (activeItem.getItem() == Items.END_CRYSTAL) {
            EndCrystalRenderer.render(age, 314, tickDelta, matrices, vertexConsumers, light);
        } else if (activeItem.getItem() == EndItems.ETERNAL_CRYSTAL) {
            EternalCrystalRenderer.render(age, tickDelta, matrices, vertexConsumers, light);
        } else {
            float rotation = ((float)age + tickDelta) / 25.0f + 6.0f;
            matrices.mulPose(Axis.YP.rotation(rotation));
            minecraft.getItemRenderer().render(activeItem, ItemDisplayContext.GROUND, false, matrices, vertexConsumers, light, overlay, model);
        }
        matrices.popPose();
    }

    public static int getGemAge() {
        return (int)(Minecraft.getInstance().level.getGameTime() % 314L);
    }
}

