/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import de.ambertation.wunderlib.ui.ColorHelper;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.BetterEnd;
import org.betterx.betterend.blocks.AuroraCrystalBlock;

public class EternalCrystalRenderer {
    private static final RenderType RENDER_LAYER = RenderType.itemEntityTranslucentCull((ResourceLocation)BetterEnd.C.mk("textures/entity/eternal_crystal.png"));
    private static final ModelPart[] SHARDS = new ModelPart[4];
    private static final ModelPart CORE;

    public static void render(int age, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumerProvider, int light) {
        VertexConsumer vertexConsumer = vertexConsumerProvider.getBuffer(RENDER_LAYER);
        int color = EternalCrystalRenderer.colors(age);
        float rotation = ((float)age + tickDelta) / 25.0f + 6.0f;
        matrices.pushPose();
        matrices.scale(0.6f, 0.6f, 0.6f);
        matrices.mulPose(Axis.YP.rotation(rotation));
        CORE.render(matrices, vertexConsumer, light, OverlayTexture.NO_OVERLAY, color);
        for (int i = 0; i < 4; ++i) {
            matrices.pushPose();
            float offset = Mth.sin((float)(rotation * 2.0f + (float)i)) * 0.15f;
            matrices.translate(0.0f, offset, 0.0f);
            SHARDS[i].render(matrices, vertexConsumer, light, OverlayTexture.NO_OVERLAY, color);
            matrices.popPose();
        }
        matrices.popPose();
    }

    public static int colors(int age) {
        double delta = (double)age * 0.01;
        int index = MHelper.floor((double)delta);
        int index2 = index + 1 & 3;
        delta -= (double)index;
        Vec3i color1 = AuroraCrystalBlock.COLORS[index &= 3];
        Vec3i color2 = AuroraCrystalBlock.COLORS[index2];
        int r = MHelper.floor((double)Mth.lerp((double)delta, (double)color1.getX(), (double)color2.getX()));
        int g = MHelper.floor((double)Mth.lerp((double)delta, (double)color1.getY(), (double)color2.getY()));
        int b = MHelper.floor((double)Mth.lerp((double)delta, (double)color1.getZ(), (double)color2.getZ()));
        return ColorHelper.color((int)r, (int)g, (int)b);
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        modelPartData.addOrReplaceChild("SHARDS_0", CubeListBuilder.create().texOffs(2, 4).addBox(-5.0f, 1.0f, -3.0f, 2.0f, 8.0f, 2.0f), PartPose.ZERO);
        modelPartData.addOrReplaceChild("SHARDS_1", CubeListBuilder.create().texOffs(2, 4).addBox(3.0f, -1.0f, -1.0f, 2.0f, 8.0f, 2.0f), PartPose.ZERO);
        modelPartData.addOrReplaceChild("SHARDS_2", CubeListBuilder.create().texOffs(2, 4).addBox(-1.0f, 0.0f, -5.0f, 2.0f, 4.0f, 2.0f), PartPose.ZERO);
        modelPartData.addOrReplaceChild("SHARDS_3", CubeListBuilder.create().texOffs(2, 4).addBox(0.0f, 3.0f, 4.0f, 2.0f, 6.0f, 2.0f), PartPose.ZERO);
        modelPartData.addOrReplaceChild("CORE", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)modelData, (int)16, (int)16);
    }

    static {
        ModelPart root = EternalCrystalRenderer.getTexturedModelData().bakeRoot();
        EternalCrystalRenderer.SHARDS[0] = root.getChild("SHARDS_0");
        EternalCrystalRenderer.SHARDS[1] = root.getChild("SHARDS_1");
        EternalCrystalRenderer.SHARDS[2] = root.getChild("SHARDS_2");
        EternalCrystalRenderer.SHARDS[3] = root.getChild("SHARDS_3");
        CORE = root.getChild("CORE");
    }
}

