/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.client.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.fabricmc.fabric.api.client.rendering.v1.DimensionRenderingRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import org.betterx.bclib.util.BackgroundInfo;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.BetterEnd;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class BetterEndSkyRenderer
implements DimensionRenderingRegistry.SkyRenderer {
    private static final ResourceLocation NEBULA_1 = BetterEnd.C.mk("textures/sky/nebula_2.png");
    private static final ResourceLocation NEBULA_2 = BetterEnd.C.mk("textures/sky/nebula_3.png");
    private static final ResourceLocation HORIZON = BetterEnd.C.mk("textures/sky/nebula_1.png");
    private static final ResourceLocation STARS = BetterEnd.C.mk("textures/sky/stars.png");
    private static final ResourceLocation FOG = BetterEnd.C.mk("textures/sky/fog.png");
    private VertexBuffer nebula1;
    private VertexBuffer nebula2;
    private VertexBuffer horizon;
    private VertexBuffer stars1;
    private VertexBuffer stars2;
    private VertexBuffer stars3;
    private VertexBuffer stars4;
    private VertexBuffer fog;
    private Vector3f axis1;
    private Vector3f axis2;
    private Vector3f axis3;
    private Vector3f axis4;
    private boolean initialised;

    private void initialise() {
        if (!this.initialised) {
            this.initStars();
            LegacyRandomSource random = new LegacyRandomSource(131L);
            this.axis1 = new Vector3f(random.nextFloat(), random.nextFloat(), random.nextFloat());
            this.axis2 = new Vector3f(random.nextFloat(), random.nextFloat(), random.nextFloat());
            this.axis3 = new Vector3f(random.nextFloat(), random.nextFloat(), random.nextFloat());
            this.axis4 = new Vector3f(random.nextFloat(), random.nextFloat(), random.nextFloat());
            this.axis1.normalize();
            this.axis2.normalize();
            this.axis3.normalize();
            this.axis4.normalize();
            this.initialised = true;
        }
    }

    public void render(WorldRenderContext context) {
        float a;
        if (context.world() == null || context.matrixStack() == null) {
            return;
        }
        this.initialise();
        Matrix4f projectionMatrix = context.projectionMatrix();
        PoseStack matrices = context.matrixStack();
        float time = ((float)context.world().getDayTime() + context.tickCounter().getRealtimeDeltaTicks()) % 360000.0f * 1.7453292E-5f;
        float time2 = time * 2.0f;
        float time3 = time * 3.0f;
        FogRenderer.levelFogColor();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        float blindA = 1.0f - BackgroundInfo.blindness;
        float blind02 = blindA * 0.2f;
        float blind06 = blindA * 0.6f;
        if (blindA > 0.0f) {
            matrices.pushPose();
            matrices.mulPose(new Quaternionf().rotationXYZ(0.0f, time, 0.0f));
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)HORIZON);
            this.renderBuffer(matrices, projectionMatrix, this.horizon, DefaultVertexFormat.POSITION_TEX, 0.77f, 0.31f, 0.73f, 0.7f * blindA);
            matrices.popPose();
            matrices.pushPose();
            matrices.mulPose(new Quaternionf().rotationXYZ(0.0f, -time, 0.0f));
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)NEBULA_1);
            this.renderBuffer(matrices, projectionMatrix, this.nebula1, DefaultVertexFormat.POSITION_TEX, 0.77f, 0.31f, 0.73f, blind02);
            matrices.popPose();
            matrices.pushPose();
            matrices.mulPose(new Quaternionf().rotationXYZ(0.0f, time2, 0.0f));
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)NEBULA_2);
            this.renderBuffer(matrices, projectionMatrix, this.nebula2, DefaultVertexFormat.POSITION_TEX, 0.77f, 0.31f, 0.73f, blind02);
            matrices.popPose();
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)STARS);
            matrices.pushPose();
            matrices.mulPose(new Quaternionf().setAngleAxis(time, this.axis3.x, this.axis3.y, this.axis3.z));
            this.renderBuffer(matrices, projectionMatrix, this.stars3, DefaultVertexFormat.POSITION_TEX, 0.77f, 0.31f, 0.73f, blind06);
            matrices.popPose();
            matrices.pushPose();
            matrices.mulPose(new Quaternionf().setAngleAxis(time2, this.axis4.x, this.axis4.y, this.axis4.z));
            this.renderBuffer(matrices, projectionMatrix, this.stars4, DefaultVertexFormat.POSITION_TEX, 1.0f, 1.0f, 1.0f, blind06);
            matrices.popPose();
        }
        if ((a = BackgroundInfo.fogDensity - 1.0f) > 0.0f) {
            if (a > 1.0f) {
                a = 1.0f;
            }
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)FOG);
            this.renderBuffer(matrices, projectionMatrix, this.fog, DefaultVertexFormat.POSITION_TEX, BackgroundInfo.fogColorRed, BackgroundInfo.fogColorGreen, BackgroundInfo.fogColorBlue, a);
        }
        if (blindA > 0.0f) {
            matrices.pushPose();
            matrices.mulPose(new Quaternionf().setAngleAxis(time3, this.axis1.x, this.axis1.y, this.axis1.z));
            this.renderBuffer(matrices, projectionMatrix, this.stars1, DefaultVertexFormat.POSITION, 1.0f, 1.0f, 1.0f, blind06);
            matrices.popPose();
            matrices.pushPose();
            matrices.mulPose(new Quaternionf().setAngleAxis(time2, this.axis2.x, this.axis2.y, this.axis2.z));
            this.renderBuffer(matrices, projectionMatrix, this.stars2, DefaultVertexFormat.POSITION, 0.95f, 0.64f, 0.93f, blind06);
            matrices.popPose();
        }
        RenderSystem.depthMask((boolean)true);
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void renderBuffer(PoseStack matrices, Matrix4f matrix4f, VertexBuffer buffer, VertexFormat format, float r, float g, float b, float a) {
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
        buffer.bind();
        if (format == DefaultVertexFormat.POSITION) {
            buffer.drawWithShader(matrices.last().pose(), matrix4f, GameRenderer.getPositionShader());
        } else {
            buffer.drawWithShader(matrices.last().pose(), matrix4f, GameRenderer.getPositionTexShader());
        }
        VertexBuffer.unbind();
    }

    private void initStars() {
        Tesselator tesselator = Tesselator.getInstance();
        this.stars1 = this.buildBuffer(tesselator, this.stars1, 0.1f, 0.3f, 3500, 41315L, this::makeStars);
        this.stars2 = this.buildBuffer(tesselator, this.stars2, 0.1f, 0.35f, 2000, 35151L, this::makeStars);
        this.stars3 = this.buildBuffer(tesselator, this.stars3, 0.4f, 1.2f, 1000, 61354L, this::makeUVStars);
        this.stars4 = this.buildBuffer(tesselator, this.stars4, 0.4f, 1.2f, 1000, 61355L, this::makeUVStars);
        this.nebula1 = this.buildBuffer(tesselator, this.nebula1, 40.0f, 60.0f, 30, 11515L, this::makeFarFog);
        this.nebula2 = this.buildBuffer(tesselator, this.nebula2, 40.0f, 60.0f, 10, 14151L, this::makeFarFog);
        this.horizon = this.buildBufferHorizon(tesselator, this.horizon);
        this.fog = this.buildBufferFog(tesselator, this.fog);
    }

    private VertexBuffer buildBuffer(Tesselator tesselator, VertexBuffer vertexBuffer, float minSize, float maxSize, int count, long seed, BufferFunction fkt) {
        if (vertexBuffer != null) {
            vertexBuffer.close();
        }
        vertexBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
        BufferBuilder bufferBuilder = fkt.make(tesselator, minSize, maxSize, count, seed);
        MeshData meshData = bufferBuilder.build();
        vertexBuffer.bind();
        vertexBuffer.upload(meshData);
        return vertexBuffer;
    }

    private VertexBuffer buildBufferHorizon(Tesselator tesselator, VertexBuffer buffer) {
        return this.buildBuffer(tesselator, buffer, 0.0f, 0.0f, 0, 0L, (_builder, _minSize, _maxSize, _count, _seed) -> this.makeCylinder(_builder, 16, 50.0f, 100.0f));
    }

    private VertexBuffer buildBufferFog(Tesselator tesselator, VertexBuffer buffer) {
        return this.buildBuffer(tesselator, buffer, 0.0f, 0.0f, 0, 0L, (_builder, _minSize, _maxSize, _count, _seed) -> this.makeCylinder(_builder, 16, 50.0f, 70.0f));
    }

    private BufferBuilder makeStars(Tesselator tesselator, float minSize, float maxSize, int count, long seed) {
        LegacyRandomSource random = new LegacyRandomSource(seed);
        RenderSystem.setShader(GameRenderer::getPositionShader);
        BufferBuilder buffer = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION);
        for (int i = 0; i < count; ++i) {
            float posX = random.nextFloat() * 2.0f - 1.0f;
            float posY = random.nextFloat() * 2.0f - 1.0f;
            float posZ = random.nextFloat() * 2.0f - 1.0f;
            float size = MHelper.randRange((float)minSize, (float)maxSize, (RandomSource)random);
            float length = posX * posX + posY * posY + posZ * posZ;
            if (!(length < 1.0f) || !(length > 0.001f)) continue;
            length = 1.0f / (float)Math.sqrt(length);
            float px = (posX *= length) * 100.0f;
            float py = (posY *= length) * 100.0f;
            float pz = (posZ *= length) * 100.0f;
            float angle = (float)Math.atan2(posX, posZ);
            float sin1 = (float)Math.sin(angle);
            float cos1 = (float)Math.cos(angle);
            angle = (float)Math.atan2(Math.sqrt(posX * posX + posZ * posZ), posY);
            float sin2 = (float)Math.sin(angle);
            float cos2 = (float)Math.cos(angle);
            angle = random.nextFloat() * (float)Math.PI * 2.0f;
            float sin3 = (float)Math.sin(angle);
            float cos3 = (float)Math.cos(angle);
            for (int index = 0; index < 4; ++index) {
                float x = (float)((index & 2) - 1) * size;
                float y = (float)((index + 1 & 2) - 1) * size;
                float aa = x * cos3 - y * sin3;
                float ab = y * cos3 + x * sin3;
                float dy = aa * sin2 + 0.0f * cos2;
                float ae = 0.0f * sin2 - aa * cos2;
                float dx = ae * sin1 - ab * cos1;
                float dz = ab * sin1 + ae * cos1;
                buffer.addVertex(px + dx, py + dy, pz + dz);
            }
        }
        return buffer;
    }

    private BufferBuilder makeUVStars(Tesselator tesselator, float minSize, float maxSize, int count, long seed) {
        LegacyRandomSource random = new LegacyRandomSource(seed);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        BufferBuilder buffer = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        for (int i = 0; i < count; ++i) {
            float posX = random.nextFloat() * 2.0f - 1.0f;
            float posY = random.nextFloat() * 2.0f - 1.0f;
            float posZ = random.nextFloat() * 2.0f - 1.0f;
            float size = MHelper.randRange((float)minSize, (float)maxSize, (RandomSource)random);
            float length = posX * posX + posY * posY + posZ * posZ;
            if (!(length < 1.0f) || !(length > 0.001f)) continue;
            length = 1.0f / (float)Math.sqrt(length);
            float px = (posX *= length) * 100.0f;
            float py = (posY *= length) * 100.0f;
            float pz = (posZ *= length) * 100.0f;
            float angle = (float)Math.atan2(posX, posZ);
            float sin1 = (float)Math.sin(angle);
            float cos1 = (float)Math.cos(angle);
            angle = (float)Math.atan2(Math.sqrt(posX * posX + posZ * posZ), posY);
            float sin2 = (float)Math.sin(angle);
            float cos2 = (float)Math.cos(angle);
            angle = random.nextFloat() * (float)Math.PI * 2.0f;
            float sin3 = (float)Math.sin(angle);
            float cos3 = (float)Math.cos(angle);
            float minV = (float)random.nextInt(4) / 4.0f;
            for (int index = 0; index < 4; ++index) {
                float x = (float)((index & 2) - 1) * size;
                float y = (float)((index + 1 & 2) - 1) * size;
                float aa = x * cos3 - y * sin3;
                float ab = y * cos3 + x * sin3;
                float dy = aa * sin2 + 0.0f * cos2;
                float ae = 0.0f * sin2 - aa * cos2;
                float dx = ae * sin1 - ab * cos1;
                float dz = ab * sin1 + ae * cos1;
                float texU = index >> 1 & 1;
                float texV = (float)(index + 1 >> 1 & 1) / 4.0f + minV;
                buffer.addVertex(px + dx, py + dy, pz + dz).setUv(texU, texV);
            }
        }
        return buffer;
    }

    private BufferBuilder makeFarFog(Tesselator tesselator, float minSize, float maxSize, int count, long seed) {
        LegacyRandomSource random = new LegacyRandomSource(seed);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        BufferBuilder buffer = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        for (int i = 0; i < count; ++i) {
            float posX = random.nextFloat() * 2.0f - 1.0f;
            float posY = random.nextFloat() - 0.5f;
            float posZ = random.nextFloat() * 2.0f - 1.0f;
            float size = MHelper.randRange((float)minSize, (float)maxSize, (RandomSource)random);
            float length = posX * posX + posY * posY + posZ * posZ;
            float distance = 2.0f;
            if (!(length < 1.0f) || !(length > 0.001f)) continue;
            length = distance / (float)Math.sqrt(length);
            size *= distance;
            float px = (posX *= length) * 100.0f;
            float py = (posY *= length) * 100.0f;
            float pz = (posZ *= length) * 100.0f;
            float angle = (float)Math.atan2(posX, posZ);
            float sin1 = (float)Math.sin(angle);
            float cos1 = (float)Math.cos(angle);
            angle = (float)Math.atan2(Math.sqrt(posX * posX + posZ * posZ), posY);
            float sin2 = (float)Math.sin(angle);
            float cos2 = (float)Math.cos(angle);
            angle = random.nextFloat() * (float)Math.PI * 2.0f;
            float sin3 = (float)Math.sin(angle);
            float cos3 = (float)Math.cos(angle);
            for (int index = 0; index < 4; ++index) {
                float x = (float)((index & 2) - 1) * size;
                float y = (float)((index + 1 & 2) - 1) * size;
                float aa = x * cos3 - y * sin3;
                float ab = y * cos3 + x * sin3;
                float dy = aa * sin2 + 0.0f * cos2;
                float ae = 0.0f * sin2 - aa * cos2;
                float dx = ae * sin1 - ab * cos1;
                float dz = ab * sin1 + ae * cos1;
                float texU = index >> 1 & 1;
                float texV = index + 1 >> 1 & 1;
                buffer.addVertex(px + dx, py + dy, pz + dz).setUv(texU, texV);
            }
        }
        return buffer;
    }

    private BufferBuilder makeCylinder(Tesselator tesselator, int segments, float height, float radius) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        BufferBuilder buffer = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        for (int i = 0; i < segments; ++i) {
            float a1 = (float)i * (float)Math.PI * 2.0f / (float)segments;
            float a2 = (float)(i + 1) * (float)Math.PI * 2.0f / (float)segments;
            float px1 = (float)Math.sin(a1) * radius;
            float pz1 = (float)Math.cos(a1) * radius;
            float px2 = (float)Math.sin(a2) * radius;
            float pz2 = (float)Math.cos(a2) * radius;
            float u0 = (float)i / (float)segments;
            float u1 = (float)(i + 1) / (float)segments;
            buffer.addVertex(px1, -height, pz1).setUv(u0, 0.0f);
            buffer.addVertex(px1, height, pz1).setUv(u0, 1.0f);
            buffer.addVertex(px2, height, pz2).setUv(u1, 1.0f);
            buffer.addVertex(px2, -height, pz2).setUv(u1, 0.0f);
        }
        return buffer;
    }

    @FunctionalInterface
    static interface BufferFunction {
        public BufferBuilder make(Tesselator var1, float var2, float var3, int var4, long var5);
    }
}

