/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.joml.Matrix4f;

public class BeamRenderer {
    private static final ResourceLocation BEAM_TEXTURE = ResourceLocation.withDefaultNamespace((String)"textures/entity/end_gateway_beam.png");

    public static void renderLightBeam(PoseStack matrices, MultiBufferSource vertexConsumers, int age, float tick, int minY, int maxY, float[] colors, float alpha, float beamIn, float beamOut) {
        float red = colors[0];
        float green = colors[1];
        float blue = colors[2];
        int maxBY = minY + maxY;
        float delta = maxY < 0 ? tick : -tick;
        float fractDelta = Mth.frac((float)(delta * 0.2f - (float)Mth.floor((float)(delta * 0.1f))));
        float xIn = -beamIn;
        float minV = Mth.clamp((float)(fractDelta - 1.0f), (float)0.0f, (float)1.0f);
        float maxV = (float)maxY * (0.5f / beamIn) + minV;
        float rotation = ((float)age + tick) / 25.0f + 6.0f;
        VertexConsumer vertexConsumer = vertexConsumers.getBuffer(RenderType.beaconBeam((ResourceLocation)BEAM_TEXTURE, (boolean)true));
        matrices.pushPose();
        matrices.mulPose(Axis.YP.rotation(-rotation));
        BeamRenderer.renderBeam(matrices, vertexConsumer, red, green, blue, alpha, minY, maxBY, beamIn, 0.0f, 0.0f, beamIn, 0.0f, xIn, xIn, 0.0f, 0.0f, 1.0f, minV, maxV);
        float xOut = -beamOut;
        maxV = (float)maxY + minV;
        BeamRenderer.renderBeam(matrices, vertexConsumer, red, green, blue, alpha, minY, maxBY, xOut, xOut, beamOut, xOut, xOut, beamOut, beamOut, beamOut, 0.0f, 1.0f, minV, maxV);
        matrices.popPose();
    }

    private static void renderBeam(PoseStack matrices, VertexConsumer vertexConsumer, float red, float green, float blue, float alpha, int minY, int maxY, float x1, float d1, float x2, float d2, float x3, float d3, float x4, float d4, float minU, float maxU, float minV, float maxV) {
        PoseStack.Pose entry = matrices.last();
        Matrix4f matrix4f = entry.pose();
        PoseStack.Pose matrix3f = entry;
        BeamRenderer.renderBeam(matrix4f, matrix3f, vertexConsumer, red, green, blue, alpha, maxY, minY, x1, d1, x2, d2, minU, maxU, minV, maxV);
        BeamRenderer.renderBeam(matrix4f, matrix3f, vertexConsumer, red, green, blue, alpha, maxY, minY, x4, d4, x3, d3, minU, maxU, minV, maxV);
        BeamRenderer.renderBeam(matrix4f, matrix3f, vertexConsumer, red, green, blue, alpha, maxY, minY, x2, d2, x4, d4, minU, maxU, minV, maxV);
        BeamRenderer.renderBeam(matrix4f, matrix3f, vertexConsumer, red, green, blue, alpha, maxY, minY, x3, d3, x1, d1, minU, maxU, minV, maxV);
    }

    private static void renderBeam(Matrix4f matrix4f, PoseStack.Pose matrix3f, VertexConsumer vertexConsumer, float red, float green, float blue, float alpha, int minY, int maxY, float minX, float minD, float maxX, float maxD, float minU, float maxU, float minV, float maxV) {
        BeamRenderer.addVertex(matrix4f, matrix3f, vertexConsumer, red, green, blue, alpha, maxX, minY, maxD, maxU, minV);
        BeamRenderer.addVertex(matrix4f, matrix3f, vertexConsumer, red, green, blue, alpha, maxX, maxY, maxD, maxU, maxV);
        BeamRenderer.addVertex(matrix4f, matrix3f, vertexConsumer, red, green, blue, alpha, minX, maxY, minD, minU, maxV);
        BeamRenderer.addVertex(matrix4f, matrix3f, vertexConsumer, red, green, blue, alpha, minX, minY, minD, minU, minV);
    }

    private static void addVertex(Matrix4f matrix4f, PoseStack.Pose matrix3f, VertexConsumer vertexConsumer, float red, float green, float blue, float alpha, float x, float y, float d, float u, float v) {
        vertexConsumer.addVertex(matrix4f, x, y, d).setColor(red, green, blue, alpha).setUv(u, v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(matrix3f, 0.0f, 1.0f, 0.0f);
    }
}

