/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.client.gui;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.Level;
import org.anti_ad.mc.ipn.api.IPNIgnore;
import org.betterx.bclib.recipes.AlloyingRecipe;
import org.betterx.bclib.recipes.AlloyingRecipeInput;
import org.betterx.betterend.blocks.entities.EndStoneSmelterBlockEntity;
import org.betterx.betterend.client.gui.slot.SmelterFuelSlot;
import org.betterx.betterend.client.gui.slot.SmelterOutputSlot;
import org.betterx.betterend.registry.EndMenuTypes;
import org.jetbrains.annotations.NotNull;

@IPNIgnore
public class EndStoneSmelterMenu
extends RecipeBookMenu<AlloyingRecipeInput, AlloyingRecipe> {
    public static final int INGREDIENT_SLOT_A = 0;
    public static final int INGREDIENT_SLOT_B = 1;
    public static final int FUEL_SLOT = 2;
    public static final int RESULT_SLOT = 3;
    public static final int SLOT_COUNT = 4;
    private static final int INV_SLOT_START = 4;
    private static final int INV_SLOT_END = 31;
    private static final int USE_ROW_SLOT_START = 31;
    private static final int USE_ROW_SLOT_END = 40;
    private final Container inventory;
    private final ContainerData propertyDelegate;
    protected final Level world;

    public EndStoneSmelterMenu(int syncId, Inventory playerInventory) {
        this(syncId, playerInventory, (Container)new SimpleContainer(4), (ContainerData)new SimpleContainerData(4));
    }

    public EndStoneSmelterMenu(int syncId, Inventory playerInventory, Container inventory, ContainerData propertyDelegate) {
        super(EndMenuTypes.END_STONE_SMELTER, syncId);
        int i;
        this.inventory = inventory;
        this.propertyDelegate = propertyDelegate;
        this.world = playerInventory.player.level();
        this.addDataSlots(propertyDelegate);
        this.addSlot(new Slot(inventory, 0, 45, 17));
        this.addSlot(new Slot(inventory, 1, 67, 17));
        this.addSlot(new SmelterFuelSlot(this, inventory, 2, 56, 53));
        this.addSlot(new SmelterOutputSlot(playerInventory.player, inventory, 3, 129, 35));
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }

    @NotNull
    public MenuType<?> getType() {
        return EndMenuTypes.END_STONE_SMELTER;
    }

    public void fillCraftSlotsStackedContents(StackedContents finder) {
        if (this.inventory instanceof StackedContentsCompatible) {
            ((StackedContentsCompatible)this.inventory).fillStackedContents(finder);
        }
    }

    public void clearCraftingContent() {
        this.getSlot(0).set(ItemStack.EMPTY);
        this.getSlot(1).set(ItemStack.EMPTY);
        this.getSlot(3).set(ItemStack.EMPTY);
    }

    public boolean recipeMatches(RecipeHolder<AlloyingRecipe> recipeHolder) {
        return ((AlloyingRecipe)recipeHolder.value()).matches(new AlloyingRecipeInput(this.inventory.getItem(0), this.inventory.getItem(1)), this.world);
    }

    public int getResultSlotIndex() {
        return 3;
    }

    public int getGridWidth() {
        return 2;
    }

    public int getGridHeight() {
        return 1;
    }

    public int getSize() {
        return 4;
    }

    @NotNull
    public RecipeBookType getRecipeBookType() {
        return RecipeBookType.BLAST_FURNACE;
    }

    public boolean shouldMoveToInventory(int i) {
        return i != 2;
    }

    public boolean stillValid(Player player) {
        return this.inventory.stillValid(player);
    }

    protected boolean isSmeltable(ItemStack itemStack) {
        return this.world.getRecipeManager().getRecipeFor(AlloyingRecipe.TYPE, (RecipeInput)new AlloyingRecipeInput(itemStack), this.world).isPresent();
    }

    public boolean isFuel(ItemStack itemStack) {
        return EndStoneSmelterBlockEntity.canUseAsFuel(itemStack);
    }

    @NotNull
    public ItemStack quickMoveStack(Player player, int index) {
        Slot slot = (Slot)this.slots.get(index);
        if (!slot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack slotStack = slot.getItem();
        ItemStack itemStack = slotStack.copy();
        if (index == 3) {
            if (!this.moveItemStackTo(slotStack, 4, 40, true)) {
                return ItemStack.EMPTY;
            }
            slot.onQuickCraft(slotStack, itemStack);
        } else if (index == 2 || index == 0 || index == 1 ? !this.moveItemStackTo(slotStack, 31, 40, false) : (this.isSmeltable(slotStack) ? !this.moveItemStackTo(slotStack, 0, 2, false) : (this.isFuel(slotStack) ? !this.moveItemStackTo(slotStack, 2, 3, false) : (index >= 4 && index < 31 ? !this.moveItemStackTo(slotStack, 31, 40, false) : index >= 31 && index < 40 && !this.moveItemStackTo(slotStack, 4, 31, false))))) {
            return ItemStack.EMPTY;
        }
        if (slotStack.isEmpty()) {
            slot.set(ItemStack.EMPTY);
        } else {
            slot.setChanged();
        }
        if (slotStack.getCount() == itemStack.getCount()) {
            return ItemStack.EMPTY;
        }
        slot.onTake(player, slotStack);
        return itemStack;
    }

    @Environment(value=EnvType.CLIENT)
    public int getSmeltProgress() {
        int time = this.propertyDelegate.get(2);
        int timeTotal = this.propertyDelegate.get(3);
        return timeTotal != 0 && time != 0 ? time * 24 / timeTotal : 0;
    }

    @Environment(value=EnvType.CLIENT)
    public int getFuelProgress() {
        int fuelTime = this.propertyDelegate.get(1);
        if (fuelTime == 0) {
            fuelTime = 200;
        }
        return this.propertyDelegate.get(0) * 13 / fuelTime;
    }

    @Environment(value=EnvType.CLIENT)
    public boolean isBurning() {
        return this.propertyDelegate.get(0) > 0;
    }
}

