/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.client;

import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.fabricmc.fabric.api.client.rendering.v1.DimensionRenderingRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.betterx.bclib.integration.modmenu.ModMenu;
import org.betterx.betterend.BetterEnd;
import org.betterx.betterend.client.render.BetterEndSkyRenderer;
import org.betterx.betterend.config.Configs;
import org.betterx.betterend.config.screen.ConfigScreen;
import org.betterx.betterend.events.ItemTooltipCallback;
import org.betterx.betterend.integration.trinkets.ElytraClient;
import org.betterx.betterend.interfaces.MultiModelItem;
import org.betterx.betterend.item.CrystaliteArmor;
import org.betterx.betterend.registry.EndBlockEntityRenders;
import org.betterx.betterend.registry.EndEntitiesRenders;
import org.betterx.betterend.registry.EndModelProviders;
import org.betterx.betterend.registry.EndParticles;
import org.betterx.betterend.registry.EndScreens;
import org.betterx.betterend.world.generator.GeneratorOptions;

public class BetterEndClient
implements ClientModInitializer {
    public void onInitializeClient() {
        EndBlockEntityRenders.register();
        EndScreens.register();
        EndParticles.register();
        EndEntitiesRenders.register();
        EndModelProviders.register();
        MultiModelItem.register();
        BetterEndClient.registerTooltips();
        ModMenu.addModMenuScreen((String)BetterEnd.C.modId, ConfigScreen::new);
        ResourceLocation checkFlowerId = ResourceLocation.withDefaultNamespace((String)"item/chorus_flower");
        ResourceLocation checkPlantId = ResourceLocation.withDefaultNamespace((String)"item/chorus_plant");
        ResourceLocation toLoadFlowerId = BetterEnd.C.mk("item/custom_chorus_flower");
        ResourceLocation toLoadPlantId = BetterEnd.C.mk("item/custom_chorus_plant");
        ModelLoadingPlugin.register(pluginContext -> pluginContext.resolveModel().register(context -> {
            if (GeneratorOptions.changeChorusPlant()) {
                if (context.id().equals((Object)checkFlowerId)) {
                    return context.getOrLoadModel(toLoadFlowerId);
                }
                if (context.id().equals((Object)checkPlantId)) {
                    return context.getOrLoadModel(toLoadPlantId);
                }
            }
            return null;
        }));
        if (((Boolean)Configs.CLIENT_CONFIG.customSky.get()).booleanValue()) {
            DimensionRenderingRegistry.registerSkyRenderer((ResourceKey)Level.END, (DimensionRenderingRegistry.SkyRenderer)new BetterEndSkyRenderer());
        }
        if (BetterEnd.TRINKETS_CORE.isLoaded()) {
            ElytraClient.register();
        }
    }

    public static void registerTooltips() {
        ItemTooltipCallback.EVENT.register((player, stack, context, lines) -> {
            if (stack.getItem() instanceof CrystaliteArmor) {
                boolean hasSet = false;
                if (player != null) {
                    hasSet = CrystaliteArmor.hasFullSet((LivingEntity)player);
                }
                MutableComponent setDesc = Component.translatable((String)"tooltip.armor.crystalite_set");
                setDesc.setStyle(Style.EMPTY.applyFormats(new ChatFormatting[]{hasSet ? ChatFormatting.BLUE : ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
                lines.add(Component.empty());
                lines.add(setDesc);
            }
        });
    }
}

