/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.blocks.entities;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.betterx.betterend.blocks.entities.PedestalBlockEntity;
import org.betterx.betterend.registry.EndBlockEntities;
import org.betterx.betterend.rituals.InfusionRitual;

public class InfusionPedestalEntity
extends PedestalBlockEntity {
    private InfusionRitual linkedRitual;

    public InfusionPedestalEntity(BlockPos blockPos, BlockState blockState) {
        super(EndBlockEntities.INFUSION_PEDESTAL, blockPos, blockState);
    }

    public void setLevel(Level world) {
        super.setLevel(world);
        if (this.hasRitual()) {
            this.linkedRitual.setLocation(world, this.getBlockPos());
        } else {
            this.linkRitual(this, world, this.getBlockPos());
        }
    }

    public InfusionRitual linkRitual(InfusionPedestalEntity pedestal, Level world, BlockPos pos) {
        this.linkedRitual = new InfusionRitual(pedestal, world, pos);
        this.linkedRitual.configure();
        return this.linkedRitual;
    }

    public InfusionRitual getRitual() {
        return this.linkedRitual;
    }

    public boolean hasRitual() {
        return this.linkedRitual != null;
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        if (this.hasRitual()) {
            tag.put("ritual", (Tag)this.linkedRitual.toTag(new CompoundTag()));
        }
        super.saveAdditional(tag, provider);
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        if (tag.contains("ritual")) {
            if (!this.hasRitual()) {
                this.linkedRitual = new InfusionRitual(this, this.level, this.worldPosition);
            }
            this.linkedRitual.fromTag(tag.getCompound("ritual"));
            this.linkedRitual.configure();
        }
    }

    public static <T extends BlockEntity> void tickEntity(Level level, BlockPos blockPos, BlockState blockState, T uncastedEntity) {
        InfusionPedestalEntity blockEntity;
        if (uncastedEntity instanceof InfusionPedestalEntity && (blockEntity = (InfusionPedestalEntity)uncastedEntity).hasRitual()) {
            blockEntity.linkedRitual.tick();
        }
    }
}

