/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.blocks.entities;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.betterx.betterend.blocks.entities.PedestalBlockEntity;
import org.betterx.betterend.registry.EndBlockEntities;
import org.betterx.betterend.rituals.EternalRitual;

public class EternalPedestalEntity
extends PedestalBlockEntity {
    private EternalRitual linkedRitual;

    public EternalPedestalEntity(BlockPos blockPos, BlockState blockState) {
        super(EndBlockEntities.ETERNAL_PEDESTAL, blockPos, blockState);
    }

    public boolean hasRitual() {
        return this.linkedRitual != null;
    }

    public void linkRitual(EternalRitual ritual) {
        this.linkedRitual = ritual;
    }

    public EternalRitual getRitual() {
        return this.linkedRitual;
    }

    public void setLevel(Level level) {
        super.setLevel(level);
        if (this.hasRitual()) {
            this.linkedRitual.setWorld(level);
        }
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        if (this.hasRitual()) {
            tag.put("ritual", (Tag)this.linkedRitual.toTag(new CompoundTag()));
        }
        super.saveAdditional(tag, provider);
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        if (tag.contains("ritual")) {
            this.linkedRitual = new EternalRitual(this.level);
            this.linkedRitual.fromTag(tag.getCompound("ritual"));
        }
        super.loadAdditional(tag, provider);
    }
}

