/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.blocks.entities;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.RecipeCraftingHolder;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.betterx.bclib.recipes.AlloyingRecipe;
import org.betterx.bclib.recipes.AlloyingRecipeInput;
import org.betterx.betterend.BetterEnd;
import org.betterx.betterend.blocks.EndStoneSmelter;
import org.betterx.betterend.client.gui.EndStoneSmelterMenu;
import org.betterx.betterend.registry.EndBlockEntities;
import org.jetbrains.annotations.NotNull;

public class EndStoneSmelterBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer,
RecipeCraftingHolder,
StackedContentsCompatible {
    private static final int[] TOP_SLOTS = new int[]{0, 1};
    private static final int[] BOTTOM_SLOTS = new int[]{2, 3};
    private static final int[] SIDE_SLOTS = new int[]{2};
    private static final Map<Item, Integer> AVAILABLE_FUELS = Maps.newHashMap();
    private final Object2IntOpenHashMap<ResourceLocation> recipesUsed;
    protected NonNullList<ItemStack> inventory = NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);
    protected final ContainerData propertyDelegate;
    private RecipeHolder<?> lastRecipe;
    private int smeltTimeTotal;
    private int smeltTime;
    private int burnTime;
    private int fuelTime;

    public EndStoneSmelterBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(EndBlockEntities.END_STONE_SMELTER, blockPos, blockState);
        this.recipesUsed = new Object2IntOpenHashMap();
        this.propertyDelegate = new ContainerData(){

            public int get(int index) {
                return switch (index) {
                    case 0 -> EndStoneSmelterBlockEntity.this.burnTime;
                    case 1 -> EndStoneSmelterBlockEntity.this.fuelTime;
                    case 2 -> EndStoneSmelterBlockEntity.this.smeltTime;
                    case 3 -> EndStoneSmelterBlockEntity.this.smeltTimeTotal;
                    default -> 0;
                };
            }

            public void set(int index, int value) {
                switch (index) {
                    case 0: {
                        EndStoneSmelterBlockEntity.this.burnTime = value;
                        break;
                    }
                    case 1: {
                        EndStoneSmelterBlockEntity.this.fuelTime = value;
                        break;
                    }
                    case 2: {
                        EndStoneSmelterBlockEntity.this.smeltTime = value;
                        break;
                    }
                    case 3: {
                        EndStoneSmelterBlockEntity.this.smeltTimeTotal = value;
                    }
                }
            }

            public int getCount() {
                return 4;
            }
        };
    }

    private boolean isBurning() {
        return this.burnTime > 0;
    }

    public int getContainerSize() {
        return this.inventory.size();
    }

    public boolean isEmpty() {
        ItemStack itemStack;
        Iterator iterator = this.inventory.iterator();
        do {
            if (iterator.hasNext()) continue;
            return true;
        } while ((itemStack = (ItemStack)iterator.next()).isEmpty());
        return false;
    }

    @NotNull
    public ItemStack getItem(int slot) {
        return (ItemStack)this.inventory.get(slot);
    }

    @NotNull
    public ItemStack removeItem(int slot, int amount) {
        return ContainerHelper.removeItem(this.inventory, (int)slot, (int)amount);
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int slot) {
        return ContainerHelper.takeItem(this.inventory, (int)slot);
    }

    private void setLitState(boolean lit) {
        if (this.level == null || this.worldPosition == null || this.getBlockState() == null) {
            return;
        }
        this.level.setBlock(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)EndStoneSmelter.LIT, (Comparable)Boolean.valueOf(lit)), 3);
        this.setBlockState((BlockState)this.getBlockState().setValue((Property)EndStoneSmelter.LIT, (Comparable)Boolean.valueOf(lit)));
    }

    public void setItem(int slot, ItemStack stack) {
        ItemStack itemStack = (ItemStack)this.inventory.get(slot);
        boolean stackValid = !stack.isEmpty() && ItemStack.isSameItem((ItemStack)stack, (ItemStack)itemStack) && ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)itemStack);
        this.inventory.set(slot, (Object)stack);
        if (stack.getCount() > this.getMaxStackSize()) {
            stack.setCount(this.getMaxStackSize());
        }
        if (!(slot != 0 && slot != 1 || stackValid)) {
            this.smeltTimeTotal = this.getSmeltTime();
            this.smeltTime = 0;
            this.setChanged();
        }
    }

    protected int getSmeltTime() {
        if (this.level == null) {
            return 200;
        }
        AlloyingRecipeInput input = new AlloyingRecipeInput((ItemStack)this.inventory.get(0), (ItemStack)this.inventory.get(1));
        int smeltTime = this.level.getRecipeManager().getRecipeFor(AlloyingRecipe.TYPE, (RecipeInput)input, this.level).map(r -> ((AlloyingRecipe)r.value()).getSmeltTime()).orElse(0);
        if (smeltTime == 0) {
            smeltTime = this.level.getRecipeManager().getRecipeFor(RecipeType.BLASTING, (RecipeInput)new SingleRecipeInput(input.any()), this.level).map(r -> ((BlastingRecipe)r.value()).getCookingTime()).orElse(200);
            smeltTime = (int)((float)smeltTime / 1.5f);
        }
        return smeltTime;
    }

    public void dropExperience(Player player) {
        if (this.level == null) {
            return;
        }
        ArrayList list = Lists.newArrayList();
        for (Object2IntMap.Entry entry : this.recipesUsed.object2IntEntrySet()) {
            this.level.getRecipeManager().byKey((ResourceLocation)entry.getKey()).ifPresent(recipe -> {
                list.add(recipe);
                Recipe patt0$temp = recipe.value();
                if (patt0$temp instanceof AlloyingRecipe) {
                    AlloyingRecipe alloying = (AlloyingRecipe)patt0$temp;
                    this.dropExperience(player.level(), player.position(), entry.getIntValue(), alloying.getExperience());
                } else {
                    BlastingRecipe blasting = (BlastingRecipe)recipe.value();
                    this.dropExperience(player.level(), player.position(), entry.getIntValue(), blasting.getExperience());
                }
            });
        }
        player.awardRecipes((Collection)list);
        this.recipesUsed.clear();
    }

    private void dropExperience(Level world, Vec3 vec3d, int count, float amount) {
        int expTotal = Mth.floor((float)((float)count * amount));
        float g = Mth.frac((float)((float)count * amount));
        if (g != 0.0f && Math.random() < (double)g) {
            ++expTotal;
        }
        while (expTotal > 0) {
            int expVal = ExperienceOrb.getExperienceValue((int)expTotal);
            expTotal -= expVal;
            world.addFreshEntity((Entity)new ExperienceOrb(world, vec3d.x, vec3d.y, vec3d.z, expVal));
        }
    }

    public boolean stillValid(Player player) {
        if (this.level != null && this.level.getBlockEntity(this.worldPosition) != this) {
            return false;
        }
        return player.distanceToSqr((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5) <= 64.0;
    }

    public void clearContent() {
        this.inventory.clear();
    }

    @NotNull
    protected Component getDefaultName() {
        return Component.translatable((String)String.format("block.%s.%s", BetterEnd.MOD_ID, "end_stone_smelter"));
    }

    @NotNull
    protected NonNullList<ItemStack> getItems() {
        return this.inventory;
    }

    protected void setItems(NonNullList<ItemStack> nonNullList) {
        this.inventory = nonNullList;
    }

    @NotNull
    protected AbstractContainerMenu createMenu(int syncId, Inventory playerInventory) {
        return new EndStoneSmelterMenu(syncId, playerInventory, (Container)this, this.propertyDelegate);
    }

    public static void tick(Level tickLevel, BlockPos tickPos, BlockState tickState, EndStoneSmelterBlockEntity blockEntity) {
        if (tickLevel == null) {
            return;
        }
        boolean initialBurning = blockEntity.isBurning();
        if (initialBurning) {
            --blockEntity.burnTime;
        }
        boolean burning = initialBurning;
        if (!tickLevel.isClientSide) {
            ItemStack fuel = (ItemStack)blockEntity.inventory.get(2);
            AlloyingRecipeInput input = new AlloyingRecipeInput((ItemStack)blockEntity.inventory.get(0), (ItemStack)blockEntity.inventory.get(1));
            if (!burning && (fuel.isEmpty() || input.first().isEmpty() && input.second().isEmpty())) {
                if (blockEntity.smeltTime > 0) {
                    blockEntity.smeltTime = Mth.clamp((int)(blockEntity.smeltTime - 2), (int)0, (int)blockEntity.smeltTimeTotal);
                }
            } else {
                RecipeHolder recipe = tickLevel.getRecipeManager().getRecipeFor(AlloyingRecipe.TYPE, (RecipeInput)input, tickLevel).orElse(null);
                if (recipe == null) {
                    recipe = tickLevel.getRecipeManager().getRecipeFor(RecipeType.BLASTING, (RecipeInput)new SingleRecipeInput(input.any()), tickLevel).orElse(null);
                }
                boolean accepted = blockEntity.canAcceptRecipeOutput(recipe, tickLevel.registryAccess());
                if (!burning && accepted) {
                    blockEntity.fuelTime = blockEntity.burnTime = EndStoneSmelterBlockEntity.getFuelTime(fuel);
                    burning = blockEntity.isBurning();
                    if (burning) {
                        if (!fuel.isEmpty()) {
                            Item item = fuel.getItem();
                            fuel.shrink(1);
                            if (fuel.isEmpty()) {
                                Item remainFuel = item.getCraftingRemainingItem();
                                blockEntity.inventory.set(2, (Object)(remainFuel == null ? ItemStack.EMPTY : new ItemStack((ItemLike)remainFuel)));
                            }
                        }
                        blockEntity.setChanged();
                    }
                }
                if (burning && accepted) {
                    ++blockEntity.smeltTime;
                    if (blockEntity.smeltTime == blockEntity.smeltTimeTotal) {
                        blockEntity.smeltTime = 0;
                        blockEntity.smeltTimeTotal = blockEntity.getSmeltTime();
                        blockEntity.craftRecipe(recipe, tickLevel.registryAccess());
                        blockEntity.setChanged();
                    }
                } else {
                    blockEntity.smeltTime = 0;
                }
            }
            if (initialBurning != (burning = blockEntity.isBurning())) {
                blockEntity.setLitState(burning);
                blockEntity.setChanged();
            }
        }
    }

    protected boolean canAcceptRecipeOutput(RecipeHolder<?> recipe, RegistryAccess acc) {
        boolean validInput;
        if (recipe == null) {
            return false;
        }
        if (recipe.value() instanceof AlloyingRecipe) {
            validInput = !((ItemStack)this.inventory.get(0)).isEmpty() && !((ItemStack)this.inventory.get(1)).isEmpty();
        } else {
            boolean bl = validInput = !((ItemStack)this.inventory.get(0)).isEmpty() || !((ItemStack)this.inventory.get(1)).isEmpty();
        }
        if (validInput) {
            ItemStack result = recipe.value().getResultItem((HolderLookup.Provider)acc);
            if (result.isEmpty()) {
                return false;
            }
            ItemStack output = (ItemStack)this.inventory.get(3);
            int outCount = output.getCount();
            int total = outCount + result.getCount();
            if (output.isEmpty()) {
                return true;
            }
            if (!ItemStack.isSameItem((ItemStack)output, (ItemStack)result)) {
                return false;
            }
            if (outCount < this.getMaxStackSize() && outCount < output.getMaxStackSize()) {
                return this.getMaxStackSize() >= total;
            }
            return output.getCount() < result.getMaxStackSize();
        }
        return false;
    }

    private void craftRecipe(RecipeHolder<?> recipe, RegistryAccess acc) {
        if (recipe == null || !this.canAcceptRecipeOutput(recipe, acc)) {
            return;
        }
        ItemStack result = recipe.value().getResultItem((HolderLookup.Provider)acc);
        ItemStack output = (ItemStack)this.inventory.get(3);
        if (output.isEmpty()) {
            this.inventory.set(3, (Object)result.copy());
        } else if (output.getItem() == result.getItem()) {
            output.grow(result.getCount());
        }
        assert (this.level != null);
        if (!this.level.isClientSide) {
            this.setRecipeUsed(recipe);
        }
        AlloyingRecipeInput input = new AlloyingRecipeInput((ItemStack)this.inventory.get(0), (ItemStack)this.inventory.get(1));
        if (recipe.value() instanceof AlloyingRecipe) {
            input.shrinkBoth();
        } else {
            input.any().shrink(1);
        }
    }

    public void fillStackedContents(StackedContents finder) {
        for (ItemStack itemStack : this.inventory) {
            finder.accountStack(itemStack);
        }
    }

    public void setRecipeUsed(RecipeHolder<?> recipe) {
        if (recipe != null) {
            ResourceLocation recipeId = recipe.id();
            this.recipesUsed.addTo((Object)recipeId, 1);
            this.lastRecipe = recipe;
        }
    }

    public RecipeHolder<?> getRecipeUsed() {
        return this.lastRecipe;
    }

    public int @NotNull [] getSlotsForFace(Direction side) {
        return switch (side) {
            case Direction.DOWN -> BOTTOM_SLOTS;
            case Direction.UP -> TOP_SLOTS;
            default -> SIDE_SLOTS;
        };
    }

    public boolean canPlaceItemThroughFace(int slot, ItemStack stack, Direction dir) {
        return this.canPlaceItem(slot, stack);
    }

    public boolean canTakeItemThroughFace(int slot, ItemStack stack, Direction dir) {
        if (dir == Direction.DOWN && slot == 2) {
            return stack.getItem() == Items.BUCKET;
        }
        return true;
    }

    public static int getFuelTime(ItemStack fuel) {
        if (fuel.isEmpty()) {
            return 0;
        }
        Item item = fuel.getItem();
        return AVAILABLE_FUELS.getOrDefault(item, EndStoneSmelterBlockEntity.getFabricFuel(fuel));
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.inventory = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)tag, this.inventory, (HolderLookup.Provider)provider);
        this.burnTime = tag.getShort("BurnTime");
        this.fuelTime = tag.getShort("FuelTime");
        this.smeltTime = tag.getShort("SmeltTime");
        this.smeltTimeTotal = tag.getShort("SmeltTimeTotal");
        CompoundTag compoundTag = tag.getCompound("RecipesUsed");
        for (String id : compoundTag.getAllKeys()) {
            this.recipesUsed.put((Object)ResourceLocation.parse((String)id), compoundTag.getInt(id));
        }
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putShort("BurnTime", (short)this.burnTime);
        tag.putShort("FuelTime", (short)this.fuelTime);
        tag.putShort("SmeltTime", (short)this.smeltTime);
        tag.putShort("SmeltTimeTotal", (short)this.smeltTimeTotal);
        ContainerHelper.saveAllItems((CompoundTag)tag, this.inventory, (HolderLookup.Provider)provider);
        CompoundTag usedRecipes = new CompoundTag();
        this.recipesUsed.forEach((identifier, integer) -> usedRecipes.putInt(identifier.toString(), integer.intValue()));
        tag.put("RecipesUsed", (Tag)usedRecipes);
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        if (slot == 3) {
            return false;
        }
        if (slot != 2) {
            return true;
        }
        ItemStack itemStack = (ItemStack)this.inventory.get(2);
        return EndStoneSmelterBlockEntity.canUseAsFuel(stack) || stack.getItem() == Items.BUCKET && itemStack.getItem() != Items.BUCKET;
    }

    public static boolean canUseAsFuel(ItemStack stack) {
        return AVAILABLE_FUELS.containsKey(stack.getItem()) || EndStoneSmelterBlockEntity.getFabricFuel(stack) > 2000;
    }

    public static void registerFuel(ItemLike fuel, int time) {
        AVAILABLE_FUELS.put(fuel.asItem(), time);
    }

    public static Map<Item, Integer> availableFuels() {
        return AVAILABLE_FUELS;
    }

    private static int getFabricFuel(ItemStack stack) {
        Integer ticks = (Integer)FuelRegistry.INSTANCE.get((ItemLike)stack.getItem());
        return ticks == null ? 0 : ticks;
    }

    static {
        AbstractFurnaceBlockEntity.getFuel().forEach((item, time) -> {
            if (time >= 2000) {
                EndStoneSmelterBlockEntity.registerFuel((ItemLike)item, time);
            }
        });
    }
}

