/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.blocks.entities;

import java.util.List;
import net.fabricmc.fabric.api.entity.event.v1.FabricElytraItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.betterx.betterend.blocks.HydrothermalVentBlock;
import org.betterx.betterend.registry.EndBlockEntities;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.betterend.registry.EndParticles;
import org.betterx.betterend.util.GlobalState;

public class BlockEntityHydrothermalVent
extends BlockEntity {
    private static final Vec3 POSITIVE_Y = new Vec3(0.0, 1.0, 0.0);

    public BlockEntityHydrothermalVent(BlockPos blockPos, BlockState blockState) {
        super(EndBlockEntities.HYDROTHERMAL_VENT, blockPos, blockState);
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos worldPosition, BlockState state, T uncastedEntity) {
        if (level != null && uncastedEntity instanceof BlockEntityHydrothermalVent && state.is(EndBlocks.HYDROTHERMAL_VENT)) {
            BlockEntityHydrothermalVent blockEntity = (BlockEntityHydrothermalVent)uncastedEntity;
            if (level.isClientSide()) {
                BlockEntityHydrothermalVent.clientTick(level, worldPosition, state, blockEntity);
            }
            BlockEntityHydrothermalVent.serverTick(level, worldPosition, state, blockEntity);
        }
    }

    private static void clientTick(Level level, BlockPos worldPosition, BlockState state, BlockEntityHydrothermalVent blockEntity) {
        boolean active = (Boolean)state.getValue((Property)HydrothermalVentBlock.ACTIVATED);
        if (active && level.random.nextInt(20) == 0 && ((Boolean)state.getValue((Property)HydrothermalVentBlock.WATERLOGGED)).booleanValue()) {
            double x = (double)worldPosition.getX() + level.random.nextDouble();
            double y = (double)worldPosition.getY() + 0.9 + level.random.nextDouble() * 0.3;
            double z = (double)worldPosition.getZ() + level.random.nextDouble();
            level.addParticle((ParticleOptions)EndParticles.GEYSER_PARTICLE, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    private static void serverTick(Level level, BlockPos worldPosition, BlockState state, BlockEntityHydrothermalVent blockEntity) {
        BlockPos.MutableBlockPos POS = GlobalState.stateForThread().POS;
        boolean active = (Boolean)state.getValue((Property)HydrothermalVentBlock.ACTIVATED);
        POS.set((Vec3i)worldPosition).move(Direction.UP);
        int height = active ? 85 : 25;
        AABB box = new AABB(POS.offset(-1, 0, -1).getCenter(), POS.offset(1, height, 1).getCenter());
        List entities = level.getEntitiesOfClass(LivingEntity.class, box);
        if (entities.size() > 0) {
            BlockState blockState;
            while ((double)POS.getY() < box.maxY && !(blockState = level.getBlockState((BlockPos)POS)).isSolidRender((BlockGetter)level, (BlockPos)POS)) {
                if (blockState.isAir()) {
                    double mult = active ? 3.0 : 5.0;
                    float force = (float)((1.0 - (double)POS.getY() / box.maxY) / mult);
                    entities.stream().filter(entity -> (int)entity.getY() == POS.getY() && blockEntity.hasElytra((LivingEntity)entity) && entity.isFallFlying()).forEach(entity -> entity.moveRelative(force, POSITIVE_Y));
                }
                POS.move(Direction.UP);
            }
        }
    }

    private boolean hasElytra(LivingEntity entity) {
        Item item = entity.getItemBySlot(EquipmentSlot.CHEST).getItem();
        return item instanceof ElytraItem || item instanceof FabricElytraItem;
    }
}

