/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.blocks.basis;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.models.blockstates.BlockStateGenerator;
import net.minecraft.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.data.models.blockstates.PropertyDispatch;
import net.minecraft.data.models.blockstates.Variant;
import net.minecraft.data.models.blockstates.VariantProperties;
import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.betterx.bclib.behaviours.interfaces.BehaviourStone;
import org.betterx.bclib.client.models.BCLModels;
import org.betterx.bclib.interfaces.CustomColorProvider;
import org.betterx.betterend.blocks.basis.EndLanternBlock;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.wover.block.api.model.WoverBlockModelGenerators;
import org.jetbrains.annotations.NotNull;

public class StoneLanternBlock
extends EndLanternBlock
implements CustomColorProvider,
BehaviourStone {
    private static final VoxelShape SHAPE_CEIL = StoneLanternBlock.box((double)3.0, (double)1.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    private static final VoxelShape SHAPE_FLOOR = StoneLanternBlock.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)15.0, (double)13.0);
    private final Block baseBlock;

    public StoneLanternBlock(Block source) {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)source).lightLevel(bs -> 15));
        this.baseBlock = source;
    }

    public BlockColor getProvider() {
        return ((CustomColorProvider)EndBlocks.AURORA_CRYSTAL).getProvider();
    }

    public ItemColor getItemProvider() {
        return ((CustomColorProvider)EndBlocks.AURORA_CRYSTAL).getItemProvider();
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        return (Boolean)state.getValue((Property)IS_FLOOR) != false ? SHAPE_FLOOR : SHAPE_CEIL;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void provideBlockModels(WoverBlockModelGenerators generator) {
        ResourceLocation id = BuiltInRegistries.BLOCK.getKey((Object)this);
        boolean isVanilla = id.getNamespace().equals("minecraft");
        TextureMapping mapping = new TextureMapping().put(BCLModels.GLASS, TextureMapping.getBlockTexture((Block)EndBlocks.AURORA_CRYSTAL)).put(TextureSlot.TOP, TextureMapping.getBlockTexture((Block)this, (String)"_top")).put(TextureSlot.SIDE, TextureMapping.getBlockTexture((Block)this, (String)"_side")).put(TextureSlot.BOTTOM, TextureMapping.getBlockTexture((Block)this, (String)"_bottom"));
        ResourceLocation floorModel = BCLModels.STONE_LANTERN_FLOOR.createWithSuffix((Block)this, "_floor", mapping, generator.modelOutput());
        ResourceLocation ceilModel = BCLModels.STONE_LANTERN_CEIL.create((Block)this, mapping, generator.modelOutput());
        generator.acceptBlockState((BlockStateGenerator)MultiVariantGenerator.multiVariant((Block)this).with((PropertyDispatch)PropertyDispatch.property((Property)IS_FLOOR).select((Comparable)Boolean.valueOf(true), Variant.variant().with(VariantProperties.MODEL, (Object)floorModel)).select((Comparable)Boolean.valueOf(false), Variant.variant().with(VariantProperties.MODEL, (Object)ceilModel))));
    }
}

