/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.blocks.basis;

import com.google.common.collect.Lists;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.ToIntFunction;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.data.models.blockstates.BlockStateGenerator;
import net.minecraft.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.data.models.blockstates.PropertyDispatch;
import net.minecraft.data.models.blockstates.Variant;
import net.minecraft.data.models.blockstates.VariantProperties;
import net.minecraft.data.models.model.ModelTemplate;
import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.betterx.bclib.blocks.BaseBlockNotFull;
import org.betterx.betterend.blocks.EndBlockProperties;
import org.betterx.betterend.blocks.InfusionPedestal;
import org.betterx.betterend.blocks.entities.InfusionPedestalEntity;
import org.betterx.betterend.blocks.entities.PedestalBlockEntity;
import org.betterx.betterend.client.models.EndModels;
import org.betterx.betterend.registry.EndTags;
import org.betterx.betterend.rituals.InfusionRitual;
import org.betterx.wover.block.api.BlockProperties;
import org.betterx.wover.block.api.BlockTagProvider;
import org.betterx.wover.block.api.model.BlockModelProvider;
import org.betterx.wover.block.api.model.WoverBlockModelGenerators;
import org.betterx.wover.tag.api.event.context.TagBootstrapContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PedestalBlock
extends BaseBlockNotFull
implements EntityBlock,
BlockTagProvider,
BlockModelProvider {
    public static final EnumProperty<EndBlockProperties.PedestalState> STATE = EndBlockProperties.PEDESTAL_STATE;
    public static final BooleanProperty HAS_ITEM = EndBlockProperties.HAS_ITEM;
    public static final BooleanProperty HAS_LIGHT = BlockProperties.HAS_LIGHT;
    private static final VoxelShape SHAPE_DEFAULT;
    private static final VoxelShape SHAPE_COLUMN;
    private static final VoxelShape SHAPE_PILLAR;
    private static final VoxelShape SHAPE_PEDESTAL_TOP;
    private static final VoxelShape SHAPE_COLUMN_TOP;
    private static final VoxelShape SHAPE_BOTTOM;
    protected final Block parent;
    protected float height = 1.0f;
    private static final Map<EndBlockProperties.PedestalState, ModelTemplate> PEDESTAL_MODELS;

    public PedestalBlock(Block parent) {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)parent).lightLevel(PedestalBlock.getLuminance(parent.defaultBlockState())));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(STATE, (Comparable)((Object)EndBlockProperties.PedestalState.DEFAULT))).setValue((Property)HAS_ITEM, (Comparable)Boolean.valueOf(false))).setValue((Property)HAS_LIGHT, (Comparable)Boolean.valueOf(false)));
        this.parent = parent;
    }

    private static ToIntFunction<BlockState> getLuminance(BlockState parent) {
        int light = parent.getLightEmission();
        if (light > 0) {
            return state -> light;
        }
        return state -> (Boolean)state.getValue((Property)HAS_LIGHT) != false ? 12 : 0;
    }

    public float getHeight(BlockState state) {
        if (state.getBlock() instanceof PedestalBlock && state.getValue(STATE) == EndBlockProperties.PedestalState.PEDESTAL_TOP) {
            return this.height - 0.2f;
        }
        return this.height;
    }

    @NotNull
    public ItemInteractionResult useItemOn(ItemStack itemStack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!state.is((Block)this) || !this.isPlaceable(state)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof PedestalBlockEntity) {
            PedestalBlockEntity pedestal = (PedestalBlockEntity)blockEntity;
            if (pedestal.isEmpty()) {
                if (itemStack.isEmpty()) {
                    return ItemInteractionResult.CONSUME;
                }
                pedestal.setItem(0, itemStack);
                level.blockEntityChanged(pos);
                this.checkRitual(level, player, pos);
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
            }
            ItemStack stack = pedestal.getItem(0);
            if (player.addItem(stack)) {
                pedestal.removeItemNoUpdate(0);
                level.blockEntityChanged(pos);
                this.checkRitual(level, player, pos);
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
            }
            return ItemInteractionResult.FAIL;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void destroy(LevelAccessor levelAccessor, BlockPos blockPos, BlockState blockState) {
        BlockPos.MutableBlockPos posMutable = new BlockPos.MutableBlockPos();
        for (Point point : InfusionRitual.getMap()) {
            InfusionPedestalEntity pedestal;
            posMutable.set((Vec3i)blockPos).move(point.x, 0, point.y);
            BlockState state = levelAccessor.getBlockState((BlockPos)posMutable);
            if (!(state.getBlock() instanceof InfusionPedestal)) continue;
            BlockEntity blockEntity = levelAccessor.getBlockEntity((BlockPos)posMutable);
            if (!(blockEntity instanceof InfusionPedestalEntity) || !(pedestal = (InfusionPedestalEntity)blockEntity).hasRitual()) break;
            pedestal.getRitual().setDirty();
            break;
        }
    }

    public void checkRitual(Level world, Player player, BlockPos pos) {
        BlockPos.MutableBlockPos posMutable = new BlockPos.MutableBlockPos();
        for (Point point : InfusionRitual.getMap()) {
            posMutable.set((Vec3i)pos).move(point.x, 0, point.y);
            BlockState state = world.getBlockState((BlockPos)posMutable);
            if (!(state.getBlock() instanceof InfusionPedestal)) continue;
            ((InfusionPedestal)state.getBlock()).checkRitual(world, player, (BlockPos)posMutable);
            break;
        }
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState upState = world.getBlockState(pos.above());
        BlockState downState = world.getBlockState(pos.below());
        boolean upSideSolid = upState.isFaceSturdy((BlockGetter)world, pos.above(), Direction.DOWN) || upState.is(BlockTags.WALLS);
        boolean hasPedestalOver = upState.getBlock() instanceof PedestalBlock;
        boolean hasPedestalUnder = downState.getBlock() instanceof PedestalBlock;
        if (!hasPedestalOver && hasPedestalUnder && upSideSolid) {
            return (BlockState)this.defaultBlockState().setValue(STATE, (Comparable)((Object)EndBlockProperties.PedestalState.COLUMN_TOP));
        }
        if (!hasPedestalOver && !hasPedestalUnder && upSideSolid) {
            return (BlockState)this.defaultBlockState().setValue(STATE, (Comparable)((Object)EndBlockProperties.PedestalState.COLUMN));
        }
        if (hasPedestalUnder && hasPedestalOver) {
            return (BlockState)this.defaultBlockState().setValue(STATE, (Comparable)((Object)EndBlockProperties.PedestalState.PILLAR));
        }
        if (hasPedestalUnder) {
            return (BlockState)this.defaultBlockState().setValue(STATE, (Comparable)((Object)EndBlockProperties.PedestalState.PEDESTAL_TOP));
        }
        if (hasPedestalOver) {
            return (BlockState)this.defaultBlockState().setValue(STATE, (Comparable)((Object)EndBlockProperties.PedestalState.BOTTOM));
        }
        return this.defaultBlockState();
    }

    @NotNull
    public BlockState updateShape(BlockState state, Direction direction, BlockState newState, LevelAccessor world, BlockPos pos, BlockPos posFrom) {
        BlockState updated = this.getUpdatedState(state, direction, newState, world, pos, posFrom);
        if (!updated.is((Block)this)) {
            return updated;
        }
        if (!this.isPlaceable(updated)) {
            this.moveStoredStack(world, updated, pos);
        }
        return updated;
    }

    private BlockState getUpdatedState(BlockState state, Direction direction, BlockState newState, LevelAccessor world, BlockPos pos, BlockPos posFrom) {
        if (!state.is((Block)this)) {
            return state.updateShape(direction, newState, world, pos, posFrom);
        }
        if (direction != Direction.UP && direction != Direction.DOWN) {
            return state;
        }
        BlockState upState = world.getBlockState(pos.above());
        BlockState downState = world.getBlockState(pos.below());
        boolean upSideSolid = upState.isFaceSturdy((BlockGetter)world, pos.above(), Direction.DOWN) || upState.is(BlockTags.WALLS);
        boolean hasPedestalOver = upState.getBlock() instanceof PedestalBlock;
        boolean hasPedestalUnder = downState.getBlock() instanceof PedestalBlock;
        if (direction == Direction.UP) {
            upSideSolid = newState.isFaceSturdy((BlockGetter)world, posFrom, Direction.DOWN) || newState.is(BlockTags.WALLS);
            hasPedestalOver = newState.getBlock() instanceof PedestalBlock;
        } else {
            hasPedestalUnder = newState.getBlock() instanceof PedestalBlock;
        }
        BlockState updatedState = !hasPedestalOver && hasPedestalUnder && upSideSolid ? (BlockState)state.setValue(STATE, (Comparable)((Object)EndBlockProperties.PedestalState.COLUMN_TOP)) : (!hasPedestalOver && !hasPedestalUnder && upSideSolid ? (BlockState)state.setValue(STATE, (Comparable)((Object)EndBlockProperties.PedestalState.COLUMN)) : (hasPedestalUnder && hasPedestalOver ? (BlockState)state.setValue(STATE, (Comparable)((Object)EndBlockProperties.PedestalState.PILLAR)) : (hasPedestalUnder ? (BlockState)state.setValue(STATE, (Comparable)((Object)EndBlockProperties.PedestalState.PEDESTAL_TOP)) : (hasPedestalOver ? (BlockState)state.setValue(STATE, (Comparable)((Object)EndBlockProperties.PedestalState.BOTTOM)) : (BlockState)state.setValue(STATE, (Comparable)((Object)EndBlockProperties.PedestalState.DEFAULT))))));
        if (!this.isPlaceable(updatedState)) {
            updatedState = (BlockState)((BlockState)updatedState.setValue((Property)HAS_ITEM, (Comparable)Boolean.valueOf(false))).setValue((Property)HAS_LIGHT, (Comparable)Boolean.valueOf(false));
        }
        return updatedState;
    }

    @NotNull
    public List<ItemStack> getDrops(@NotNull BlockState state, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull LootParams.Builder builder) {
        ArrayList drop = Lists.newArrayList((Iterable)super.getDrops(state, builder));
        if (state.is((Block)this)) {
            if (this.isPlaceable(state)) {
                PedestalBlockEntity pedestal;
                BlockEntity blockEntity = (BlockEntity)builder.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
                if (blockEntity instanceof PedestalBlockEntity && !(pedestal = (PedestalBlockEntity)blockEntity).isEmpty()) {
                    drop.add(pedestal.getItem(0));
                }
            } else {
                return drop;
            }
        }
        return drop;
    }

    private void moveStoredStack(LevelAccessor world, BlockState state, BlockPos pos) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof PedestalBlockEntity) {
            ItemStack stack;
            PedestalBlockEntity pedestal = (PedestalBlockEntity)blockEntity;
            if (state.is((Block)this) && !(stack = pedestal.removeItemNoUpdate(0)).isEmpty()) {
                this.moveStoredStack(blockEntity, world, stack, pos.above());
            }
        }
    }

    private void moveStoredStack(BlockEntity blockEntity, LevelAccessor world, ItemStack stack, BlockPos pos) {
        BlockState state = world.getBlockState(pos);
        if (!state.is((Block)this)) {
            this.dropStoredStack(blockEntity, stack, pos);
        } else if (((EndBlockProperties.PedestalState)((Object)state.getValue(STATE))).equals((Object)EndBlockProperties.PedestalState.PILLAR)) {
            this.moveStoredStack(blockEntity, world, stack, pos.above());
        } else if (!this.isPlaceable(state)) {
            this.dropStoredStack(blockEntity, stack, pos);
        } else if (blockEntity instanceof PedestalBlockEntity) {
            PedestalBlockEntity pedestal = (PedestalBlockEntity)blockEntity;
            if (pedestal.isEmpty()) {
                pedestal.setItem(0, stack);
            } else {
                this.dropStoredStack(blockEntity, stack, pos);
            }
        } else {
            this.dropStoredStack(blockEntity, stack, pos);
        }
    }

    private void dropStoredStack(BlockEntity blockEntity, ItemStack stack, BlockPos pos) {
        if (blockEntity != null && blockEntity.getLevel() != null) {
            Level world = blockEntity.getLevel();
            Block.popResource((Level)world, (BlockPos)this.getDropPos((LevelAccessor)world, pos), (ItemStack)stack);
        }
    }

    private BlockPos getDropPos(LevelAccessor world, BlockPos pos) {
        if (world.getBlockState(pos).isAir()) {
            return pos;
        }
        if (world.getBlockState(pos.above()).isAir()) {
            return pos.above();
        }
        for (int i = 2; i < Direction.values().length; ++i) {
            BlockPos dropPos = pos.relative(Direction.from3DDataValue((int)i));
            if (!world.getBlockState(dropPos).isAir()) continue;
            return dropPos.immutable();
        }
        return this.getDropPos(world, pos.above());
    }

    public boolean isPlaceable(BlockState state) {
        if (!state.is((Block)this)) {
            return false;
        }
        EndBlockProperties.PedestalState currentState = (EndBlockProperties.PedestalState)((Object)state.getValue(STATE));
        return currentState == EndBlockProperties.PedestalState.DEFAULT || currentState == EndBlockProperties.PedestalState.PEDESTAL_TOP;
    }

    @NotNull
    public VoxelShape getShape(BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        if (state.is((Block)this)) {
            return switch ((EndBlockProperties.PedestalState)((Object)state.getValue(STATE))) {
                case EndBlockProperties.PedestalState.BOTTOM -> SHAPE_BOTTOM;
                case EndBlockProperties.PedestalState.PEDESTAL_TOP -> SHAPE_PEDESTAL_TOP;
                case EndBlockProperties.PedestalState.COLUMN_TOP -> SHAPE_COLUMN_TOP;
                case EndBlockProperties.PedestalState.PILLAR -> SHAPE_PILLAR;
                case EndBlockProperties.PedestalState.COLUMN -> SHAPE_COLUMN;
                default -> SHAPE_DEFAULT;
            };
        }
        return super.getShape(state, world, pos, context);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.add(new Property[]{STATE, HAS_ITEM, HAS_LIGHT});
    }

    public BlockEntity newBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return new PedestalBlockEntity(blockPos, blockState);
    }

    public boolean hasUniqueEntity() {
        return false;
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return state.getBlock() instanceof PedestalBlock;
    }

    public int getAnalogOutputSignal(BlockState state, @NotNull Level world, @NotNull BlockPos pos) {
        return (Boolean)state.getValue((Property)HAS_ITEM) != false ? 15 : 0;
    }

    @Environment(value=EnvType.CLIENT)
    public void provideBlockModels(WoverBlockModelGenerators generator) {
        PedestalBlock.provideBlockModel(generator, this.createTextureMapping(), (Block)this);
    }

    @Environment(value=EnvType.CLIENT)
    public static void provideBlockModel(WoverBlockModelGenerators generator, TextureMapping mapping, Block pedestalBlock) {
        PedestalBlock.provideBlockModel(generator, mapping, pedestalBlock, PEDESTAL_MODELS);
    }

    @Environment(value=EnvType.CLIENT)
    public static void provideBlockModel(WoverBlockModelGenerators generator, TextureMapping mapping, Block pedestalBlock, Map<EndBlockProperties.PedestalState, ModelTemplate> pdestalModels) {
        ResourceLocation id = TextureMapping.getBlockTexture((Block)pedestalBlock);
        PropertyDispatch.C1 properties = PropertyDispatch.property(STATE);
        for (Map.Entry<EndBlockProperties.PedestalState, ModelTemplate> entry : pdestalModels.entrySet()) {
            String suffix = "_" + String.valueOf((Object)entry.getKey());
            ResourceLocation model = entry.getValue().createWithSuffix(pedestalBlock, suffix, mapping, generator.modelOutput());
            properties.select((Comparable)((Object)entry.getKey()), Variant.variant().with(VariantProperties.MODEL, (Object)model));
        }
        generator.acceptBlockState((BlockStateGenerator)MultiVariantGenerator.multiVariant((Block)pedestalBlock).with((PropertyDispatch)properties));
        generator.delegateItemModel(pedestalBlock, id.withSuffix("_default"));
    }

    @Environment(value=EnvType.CLIENT)
    protected TextureMapping createTextureMapping() {
        ResourceLocation parentTexture = TextureMapping.getBlockTexture((Block)this.parent);
        return new TextureMapping().put(TextureSlot.TOP, parentTexture.withSuffix("_top")).put(TextureSlot.BOTTOM, parentTexture.withSuffix("_bottom")).put(EndModels.BASE, parentTexture.withSuffix("_base")).put(EndModels.PILLAR, parentTexture.withSuffix("_pillar"));
    }

    public void registerBlockTags(ResourceLocation location, TagBootstrapContext<Block> context) {
        context.add(EndTags.PEDESTALS, (Object[])new Block[]{this});
    }

    static {
        PEDESTAL_MODELS = Map.of(EndBlockProperties.PedestalState.DEFAULT, EndModels.PEDESTAL_DEFAULT, EndBlockProperties.PedestalState.PEDESTAL_TOP, EndModels.PEDESTAL_TOP, EndBlockProperties.PedestalState.COLUMN_TOP, EndModels.PEDESTAL_COLUMN_TOP, EndBlockProperties.PedestalState.COLUMN, EndModels.PEDESTAL_COLUMN, EndBlockProperties.PedestalState.BOTTOM, EndModels.PEDESTAL_BOTTOM, EndBlockProperties.PedestalState.PILLAR, EndModels.PEDESTAL_PILLAR);
        VoxelShape basinUp = Block.box((double)2.0, (double)3.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0);
        VoxelShape basinDown = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0);
        VoxelShape columnTopUp = Block.box((double)1.0, (double)14.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
        VoxelShape columnTopDown = Block.box((double)2.0, (double)13.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0);
        VoxelShape pedestalTop = Block.box((double)1.0, (double)8.0, (double)1.0, (double)15.0, (double)10.0, (double)15.0);
        VoxelShape pedestalDefault = Block.box((double)1.0, (double)12.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);
        VoxelShape pillar = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0);
        VoxelShape pillarDefault = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)12.0, (double)13.0);
        VoxelShape columnTop = Shapes.or((VoxelShape)columnTopDown, (VoxelShape)columnTopUp);
        VoxelShape basin = Shapes.or((VoxelShape)basinDown, (VoxelShape)basinUp);
        SHAPE_PILLAR = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
        SHAPE_DEFAULT = Shapes.or((VoxelShape)basin, (VoxelShape[])new VoxelShape[]{pillarDefault, pedestalDefault});
        SHAPE_PEDESTAL_TOP = Shapes.or((VoxelShape)pillar, (VoxelShape)pedestalTop);
        SHAPE_COLUMN_TOP = Shapes.or((VoxelShape)SHAPE_PILLAR, (VoxelShape)columnTop);
        SHAPE_COLUMN = Shapes.or((VoxelShape)basin, (VoxelShape[])new VoxelShape[]{SHAPE_PILLAR, columnTop});
        SHAPE_BOTTOM = Shapes.or((VoxelShape)basin, (VoxelShape)SHAPE_PILLAR);
    }
}

