/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.blocks.basis;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.betterx.bclib.blocks.BaseBlockNotFull;
import org.betterx.wover.block.api.BlockProperties;
import org.betterx.wover.block.api.model.BlockModelProvider;
import org.betterx.wover.block.api.model.WoverBlockModelGenerators;
import org.jetbrains.annotations.Nullable;

public abstract class EndLanternBlock
extends BaseBlockNotFull
implements SimpleWaterloggedBlock,
LiquidBlockContainer,
BlockModelProvider {
    public static final BooleanProperty IS_FLOOR = BlockProperties.IS_FLOOR;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    public EndLanternBlock(Block source) {
        this(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)source).lightLevel(bs -> 15).noOcclusion());
    }

    public EndLanternBlock(BlockBehaviour.Properties settings) {
        super(settings.noOcclusion());
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)IS_FLOOR, (Comparable)Boolean.valueOf(true))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.add(new Property[]{IS_FLOOR, WATERLOGGED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        boolean water;
        Level worldView = ctx.getLevel();
        BlockPos blockPos = ctx.getClickedPos();
        Direction dir = ctx.getClickedFace();
        boolean bl = water = worldView.getFluidState(blockPos).getType() == Fluids.WATER;
        if (dir != Direction.DOWN && dir != Direction.UP) {
            if (EndLanternBlock.canSupportCenter((LevelReader)worldView, (BlockPos)blockPos.above(), (Direction)Direction.DOWN)) {
                return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)IS_FLOOR, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(water));
            }
            if (EndLanternBlock.canSupportCenter((LevelReader)worldView, (BlockPos)blockPos.below(), (Direction)Direction.UP)) {
                return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)IS_FLOOR, (Comparable)Boolean.valueOf(true))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(water));
            }
            return null;
        }
        if (dir == Direction.DOWN) {
            if (EndLanternBlock.canSupportCenter((LevelReader)worldView, (BlockPos)blockPos.above(), (Direction)Direction.DOWN)) {
                return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)IS_FLOOR, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(water));
            }
            if (EndLanternBlock.canSupportCenter((LevelReader)worldView, (BlockPos)blockPos.below(), (Direction)Direction.UP)) {
                return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)IS_FLOOR, (Comparable)Boolean.valueOf(true))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(water));
            }
            return null;
        }
        if (EndLanternBlock.canSupportCenter((LevelReader)worldView, (BlockPos)blockPos.below(), (Direction)Direction.UP)) {
            return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)IS_FLOOR, (Comparable)Boolean.valueOf(true))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(water));
        }
        if (EndLanternBlock.canSupportCenter((LevelReader)worldView, (BlockPos)blockPos.above(), (Direction)Direction.DOWN)) {
            return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)IS_FLOOR, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(water));
        }
        return null;
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        if (((Boolean)state.getValue((Property)IS_FLOOR)).booleanValue()) {
            return EndLanternBlock.canSupportCenter((LevelReader)world, (BlockPos)pos.below(), (Direction)Direction.UP);
        }
        return EndLanternBlock.canSupportCenter((LevelReader)world, (BlockPos)pos.above(), (Direction)Direction.DOWN);
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        Boolean water = (Boolean)state.getValue((Property)WATERLOGGED);
        if (water.booleanValue()) {
            world.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        if (!this.canSurvive(state, (LevelReader)world, pos)) {
            return water != false ? Blocks.WATER.defaultBlockState() : Blocks.AIR.defaultBlockState();
        }
        return state;
    }

    public boolean canPlaceLiquid(@Nullable Player player, BlockGetter blockGetter, BlockPos blockPos, BlockState blockState, Fluid fluid) {
        return false;
    }

    public boolean placeLiquid(LevelAccessor world, BlockPos pos, BlockState state, FluidState fluidState) {
        return false;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : Fluids.EMPTY.defaultFluidState();
    }

    @Environment(value=EnvType.CLIENT)
    public abstract void provideBlockModels(WoverBlockModelGenerators var1);
}

