/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.blocks;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SlimeBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import org.betterx.bclib.behaviours.interfaces.BehaviourLeaves;
import org.betterx.bclib.client.render.BCLRenderLayer;
import org.betterx.bclib.interfaces.RenderLayerProvider;
import org.betterx.bclib.interfaces.RuntimeBlockModelProvider;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.blocks.EndBlockProperties;
import org.betterx.betterend.noise.OpenSimplexNoise;
import org.betterx.betterend.registry.EndBlocks;

public class UmbrellaTreeMembraneBlock
extends SlimeBlock
implements RenderLayerProvider,
RuntimeBlockModelProvider,
BehaviourLeaves {
    public static final IntegerProperty COLOR = EndBlockProperties.COLOR;
    private static final OpenSimplexNoise NOISE = new OpenSimplexNoise(0L);

    public UmbrellaTreeMembraneBlock() {
        super((BlockBehaviour.Properties)FabricBlockSettings.copyOf((BlockBehaviour)Blocks.SLIME_BLOCK));
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        double px = (double)ctx.getClickedPos().getX() * 0.1;
        double py = (double)ctx.getClickedPos().getY() * 0.1;
        double pz = (double)ctx.getClickedPos().getZ() * 0.1;
        return (BlockState)this.defaultBlockState().setValue((Property)COLOR, (Comparable)Integer.valueOf(MHelper.floor((double)(NOISE.eval(px, py, pz) * 3.5 + 4.0))));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.add(new Property[]{COLOR});
    }

    public BCLRenderLayer getRenderLayer() {
        return BCLRenderLayer.TRANSLUCENT;
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        if ((Integer)state.getValue((Property)COLOR) > 0) {
            return Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)this)});
        }
        return MHelper.RANDOM.nextInt(4) == 0 ? Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)EndBlocks.UMBRELLA_TREE_SAPLING)}) : Collections.emptyList();
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter world, BlockPos pos) {
        return (Integer)state.getValue((Property)COLOR) > 0;
    }

    @Environment(value=EnvType.CLIENT)
    public boolean skipRendering(BlockState state, BlockState stateFrom, Direction direction) {
        if ((Integer)state.getValue((Property)COLOR) > 0) {
            return super.skipRendering(state, stateFrom, direction);
        }
        return false;
    }

    @Environment(value=EnvType.CLIENT)
    public BlockModel getItemModel(ResourceLocation resourceLocation) {
        return this.getBlockModel(resourceLocation, this.defaultBlockState());
    }
}

