/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.blocks;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import org.betterx.bclib.blocks.BaseVineBlock;
import org.betterx.bclib.interfaces.CustomColorProvider;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.registry.EndParticles;
import org.betterx.ui.ColorUtil;

public class TenaneaFlowersBlock
extends BaseVineBlock
implements CustomColorProvider {
    public static final Vec3i[] COLORS = new Vec3i[]{new Vec3i(250, 111, 222), new Vec3i(167, 89, 255), new Vec3i(120, 207, 239), new Vec3i(255, 87, 182)};

    public TenaneaFlowersBlock() {
        super(15);
    }

    public BlockColor getProvider() {
        return (state, world, pos, tintIndex) -> {
            if (pos == null) {
                pos = BlockPos.ZERO;
            }
            long i = (MHelper.getRandom((int)pos.getX(), (int)pos.getZ()) & 0x3F) + pos.getY();
            double delta = (double)i * 0.1;
            int index = MHelper.floor((double)delta);
            int index2 = index + 1 & 3;
            delta -= (double)index;
            Vec3i color1 = COLORS[index &= 3];
            Vec3i color2 = COLORS[index2];
            int r = MHelper.floor((double)Mth.lerp((double)delta, (double)color1.getX(), (double)color2.getX()));
            int g = MHelper.floor((double)Mth.lerp((double)delta, (double)color1.getY(), (double)color2.getY()));
            int b = MHelper.floor((double)Mth.lerp((double)delta, (double)color1.getZ(), (double)color2.getZ()));
            float[] hsb = ColorUtil.RGBtoHSB((int)r, (int)g, (int)b, (float[])new float[3]);
            return ColorUtil.HSBtoRGB((float)hsb[0], (float)MHelper.max((float)0.5f, (float)hsb[1]), (float)hsb[2]);
        };
    }

    public ItemColor getItemProvider() {
        return (stack, tintIndex) -> ColorUtil.color((int)255, (int)255, (int)255);
    }

    public boolean isValidBonemealTarget(LevelReader world, BlockPos pos, BlockState state) {
        return false;
    }

    @Environment(value=EnvType.CLIENT)
    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        super.animateTick(state, world, pos, random);
        if (random.nextInt(32) == 0) {
            double x = (double)pos.getX() + random.nextGaussian() + 0.5;
            double z = (double)pos.getZ() + random.nextGaussian() + 0.5;
            double y = (double)pos.getY() + random.nextDouble();
            world.addParticle((ParticleOptions)EndParticles.TENANEA_PETAL, x, y, z, 0.0, 0.0, 0.0);
        }
    }
}

