/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.blocks;

import com.google.common.collect.Maps;
import java.util.EnumMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.betterx.bclib.behaviours.BehaviourBuilders;
import org.betterx.bclib.blocks.BaseAttachedBlock;
import org.betterx.bclib.client.render.BCLRenderLayer;
import org.betterx.bclib.interfaces.RenderLayerProvider;
import org.betterx.bclib.interfaces.tools.AddMineablePickaxe;
import org.jetbrains.annotations.Nullable;

public class SmaragdantCrystalShardBlock
extends BaseAttachedBlock
implements AddMineablePickaxe,
RenderLayerProvider,
SimpleWaterloggedBlock,
LiquidBlockContainer {
    private static final EnumMap<Direction, VoxelShape> BOUNDING_SHAPES = Maps.newEnumMap(Direction.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    public SmaragdantCrystalShardBlock() {
        super(BehaviourBuilders.createStone((MapColor)MapColor.COLOR_GREEN).lightLevel(bs -> 15).sound(SoundType.AMETHYST_CLUSTER).requiresCorrectToolForDrops().noCollission());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateManager) {
        super.createBlockStateDefinition(stateManager);
        stateManager.add(new Property[]{WATERLOGGED});
    }

    public BCLRenderLayer getRenderLayer() {
        return BCLRenderLayer.CUTOUT;
    }

    public boolean canPlaceLiquid(@Nullable Player player, BlockGetter blockGetter, BlockPos blockPos, BlockState blockState, Fluid fluid) {
        return (Boolean)blockState.getValue((Property)WATERLOGGED) == false;
    }

    public boolean placeLiquid(LevelAccessor world, BlockPos pos, BlockState state, FluidState fluidState) {
        return (Boolean)state.getValue((Property)WATERLOGGED) == false;
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockState state = super.getStateForPlacement(ctx);
        if (state != null) {
            BlockPos blockPos;
            Level worldView = ctx.getLevel();
            boolean water = worldView.getFluidState(blockPos = ctx.getClickedPos()).getType() == Fluids.WATER;
            return (BlockState)state.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(water));
        }
        return null;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : Fluids.EMPTY.defaultFluidState();
    }

    public VoxelShape getShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        return BOUNDING_SHAPES.get(state.getValue((Property)FACING));
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        BlockPos blockPos = pos.relative(direction.getOpposite());
        return world.getBlockState(blockPos).isFaceSturdy((BlockGetter)world, blockPos, direction);
    }

    static {
        BOUNDING_SHAPES.put(Direction.UP, Shapes.box((double)0.125, (double)0.0, (double)0.125, (double)0.875, (double)0.875, (double)0.875));
        BOUNDING_SHAPES.put(Direction.DOWN, Shapes.box((double)0.125, (double)0.125, (double)0.125, (double)0.875, (double)1.0, (double)0.875));
        BOUNDING_SHAPES.put(Direction.NORTH, Shapes.box((double)0.125, (double)0.125, (double)0.125, (double)0.875, (double)0.875, (double)1.0));
        BOUNDING_SHAPES.put(Direction.SOUTH, Shapes.box((double)0.125, (double)0.125, (double)0.0, (double)0.875, (double)0.875, (double)0.875));
        BOUNDING_SHAPES.put(Direction.WEST, Shapes.box((double)0.125, (double)0.125, (double)0.125, (double)1.0, (double)0.875, (double)0.875));
        BOUNDING_SHAPES.put(Direction.EAST, Shapes.box((double)0.0, (double)0.125, (double)0.125, (double)0.875, (double)0.875, (double)0.875));
    }
}

