/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.betterx.bclib.blocks.BaseBlock;
import org.betterx.bclib.items.tool.BaseShearsItem;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.blocks.EndBlockProperties;
import org.betterx.betterend.entity.SilkMothEntity;
import org.betterx.betterend.registry.EndEntities;
import org.betterx.betterend.registry.EndItems;

public class SilkMothHiveBlock
extends BaseBlock.Wood {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final IntegerProperty FULLNESS = EndBlockProperties.FULLNESS;

    public SilkMothHiveBlock() {
        BlockBehaviour.Properties.of();
        super(BlockBehaviour.Properties.of().strength(0.5f, 0.1f).sound(SoundType.WOOL).noOcclusion().randomTicks());
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)FULLNESS, (Comparable)Integer.valueOf(0)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.add(new Property[]{FACING, FULLNESS});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Direction dir = ctx.getHorizontalDirection().getOpposite();
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)dir);
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return BlocksHelper.rotateHorizontal((BlockState)state, (Rotation)rotation, (Property)FACING);
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return BlocksHelper.mirrorHorizontal((BlockState)state, (Mirror)mirror, (Property)FACING);
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        Direction dir = (Direction)state.getValue((Property)FACING);
        BlockPos spawn = pos.relative(dir);
        if (!world.getBlockState(spawn).isAir()) {
            return;
        }
        int count = world.getEntities((EntityTypeTest)EndEntities.SILK_MOTH.type(), new AABB(pos).inflate(16.0), entity -> true).size();
        if (count > 6) {
            return;
        }
        SilkMothEntity moth = new SilkMothEntity((EntityType<? extends SilkMothEntity>)EndEntities.SILK_MOTH.type(), (Level)world);
        moth.moveTo((double)spawn.getX() + 0.5, (double)spawn.getY() + 0.5, (double)spawn.getZ() + 0.5, dir.toYRot(), 0.0f);
        moth.setDeltaMovement(new Vec3((double)dir.getStepX() * 0.4, 0.0, (double)dir.getStepZ() * 0.4));
        moth.setHive((Level)world, pos);
        world.addFreshEntity((Entity)moth);
        world.playSound(null, pos, SoundEvents.BEEHIVE_EXIT, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    public ItemInteractionResult useItemOn(ItemStack itemStack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack;
        if (hand == InteractionHand.MAIN_HAND && BaseShearsItem.isShear((ItemStack)(stack = player.getMainHandItem())) && (Integer)state.getValue((Property)FULLNESS) == 3) {
            BlocksHelper.setWithUpdate((LevelAccessor)world, (BlockPos)pos, (BlockState)((BlockState)state.setValue((Property)FULLNESS, (Comparable)Integer.valueOf(0))));
            Direction dir = (Direction)state.getValue((Property)FACING);
            double px = (double)(pos.getX() + dir.getStepX()) + 0.5;
            double py = (double)(pos.getY() + dir.getStepY()) + 0.5;
            double pz = (double)(pos.getZ() + dir.getStepZ()) + 0.5;
            ItemStack drop = new ItemStack((ItemLike)EndItems.SILK_FIBER, MHelper.randRange((int)8, (int)16, (RandomSource)world.getRandom()));
            ItemEntity entity = new ItemEntity(world, px, py, pz, drop);
            world.addFreshEntity((Entity)entity);
            if (world.getRandom().nextInt(4) == 0) {
                drop = new ItemStack((ItemLike)EndItems.SILK_MOTH_MATRIX);
                entity = new ItemEntity(world, px, py, pz, drop);
                world.addFreshEntity((Entity)entity);
            }
            if (!player.isCreative()) {
                stack.setDamageValue(stack.getDamageValue() + 1);
            }
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.FAIL;
    }
}

