/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.blocks;

import com.google.common.collect.Lists;
import java.util.List;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.betterx.bclib.blocks.BaseBlock;
import org.betterx.bclib.client.render.BCLRenderLayer;
import org.betterx.bclib.interfaces.CustomColorProvider;
import org.betterx.bclib.interfaces.RenderLayerProvider;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.betterend.particle.InfusionParticleType;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.betterend.registry.EndItems;
import org.betterx.ui.ColorUtil;
import org.betterx.wover.block.api.BlockProperties;
import org.jetbrains.annotations.Nullable;

public class RespawnObeliskBlock
extends BaseBlock.Stone
implements CustomColorProvider,
RenderLayerProvider {
    private static final VoxelShape VOXEL_SHAPE_BOTTOM = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    private static final VoxelShape VOXEL_SHAPE_MIDDLE_TOP = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    public static final EnumProperty<BlockProperties.TripleShape> SHAPE = BlockProperties.TRIPLE_SHAPE;

    public RespawnObeliskBlock() {
        super((BlockBehaviour.Properties)FabricBlockSettings.copyOf((BlockBehaviour)Blocks.END_STONE).luminance(state -> state.getValue(SHAPE) == BlockProperties.TripleShape.BOTTOM ? 0 : 15));
    }

    public VoxelShape getShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        return state.getValue(SHAPE) == BlockProperties.TripleShape.BOTTOM ? VOXEL_SHAPE_BOTTOM : VOXEL_SHAPE_MIDDLE_TOP;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.add(new Property[]{SHAPE});
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        for (int i = 0; i < 3; ++i) {
            if (world.getBlockState(pos.above(i)).canBeReplaced()) continue;
            return false;
        }
        return true;
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        state = this.defaultBlockState();
        BlocksHelper.setWithUpdate((LevelAccessor)world, (BlockPos)pos, (BlockState)((BlockState)state.setValue(SHAPE, (Comparable)BlockProperties.TripleShape.BOTTOM)));
        BlocksHelper.setWithUpdate((LevelAccessor)world, (BlockPos)pos.above(), (BlockState)((BlockState)state.setValue(SHAPE, (Comparable)BlockProperties.TripleShape.MIDDLE)));
        BlocksHelper.setWithUpdate((LevelAccessor)world, (BlockPos)pos.above(2), (BlockState)((BlockState)state.setValue(SHAPE, (Comparable)BlockProperties.TripleShape.TOP)));
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        BlockProperties.TripleShape shape = (BlockProperties.TripleShape)state.getValue(SHAPE);
        if (shape == BlockProperties.TripleShape.BOTTOM) {
            if (world.getBlockState(pos.above()).is((Block)this)) {
                return state;
            }
            return Blocks.AIR.defaultBlockState();
        }
        if (shape == BlockProperties.TripleShape.MIDDLE) {
            if (world.getBlockState(pos.above()).is((Block)this) && world.getBlockState(pos.below()).is((Block)this)) {
                return state;
            }
            return Blocks.AIR.defaultBlockState();
        }
        if (world.getBlockState(pos.below()).is((Block)this)) {
            return state;
        }
        return Blocks.AIR.defaultBlockState();
    }

    public BlockState playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        if (player.isCreative()) {
            BlockProperties.TripleShape shape = (BlockProperties.TripleShape)state.getValue(SHAPE);
            if (shape == BlockProperties.TripleShape.MIDDLE) {
                BlocksHelper.setWithUpdate((LevelAccessor)world, (BlockPos)pos.below(), (Block)Blocks.AIR);
            } else if (shape == BlockProperties.TripleShape.TOP) {
                BlocksHelper.setWithUpdate((LevelAccessor)world, (BlockPos)pos.below(2), (Block)Blocks.AIR);
            }
        }
        return super.playerWillDestroy(world, pos, state, player);
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        if (state.getValue(SHAPE) == BlockProperties.TripleShape.BOTTOM) {
            return Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)this)});
        }
        return Lists.newArrayList();
    }

    public BCLRenderLayer getRenderLayer() {
        return BCLRenderLayer.TRANSLUCENT;
    }

    public BlockColor getProvider() {
        return ((CustomColorProvider)EndBlocks.AURORA_CRYSTAL).getProvider();
    }

    public ItemColor getItemProvider() {
        return (stack, tintIndex) -> ColorUtil.color((int)255, (int)255, (int)255);
    }

    public ItemInteractionResult useItemOn(ItemStack itemStack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        boolean canActivate;
        boolean bl = canActivate = itemStack.getItem() == EndItems.AMBER_GEM && itemStack.getCount() > 5;
        if (hand != InteractionHand.MAIN_HAND || !canActivate) {
            if (!(world.isClientSide || itemStack.getItem() instanceof BlockItem || player.isCreative())) {
                ServerPlayer serverPlayerEntity = (ServerPlayer)player;
                serverPlayerEntity.displayClientMessage((Component)Component.translatable((String)"message.betterend.fail_spawn"), true);
            }
            return ItemInteractionResult.FAIL;
        }
        if (!world.isClientSide) {
            ServerPlayer serverPlayerEntity = (ServerPlayer)player;
            serverPlayerEntity.setRespawnPosition(world.dimension(), pos, 0.0f, false, false);
            serverPlayerEntity.displayClientMessage((Component)Component.translatable((String)"message.betterend.set_spawn"), true);
            double px = (double)pos.getX() + 0.5;
            double py = (double)pos.getY() + 0.5;
            double pz = (double)pos.getZ() + 0.5;
            InfusionParticleType particle = new InfusionParticleType(new ItemStack((ItemLike)EndItems.AMBER_GEM));
            if (world instanceof ServerLevel) {
                double py1 = py;
                double py2 = py - 0.2;
                if (state.getValue(SHAPE) == BlockProperties.TripleShape.BOTTOM) {
                    py1 += 1.0;
                    py2 += 2.0;
                } else if (state.getValue(SHAPE) == BlockProperties.TripleShape.MIDDLE) {
                    py1 += 0.0;
                    py2 += 1.0;
                } else {
                    py1 -= 2.0;
                }
                ((ServerLevel)world).sendParticles((ParticleOptions)particle, px, py1, pz, 20, 0.14, 0.5, 0.14, 0.1);
                ((ServerLevel)world).sendParticles((ParticleOptions)particle, px, py2, pz, 20, 0.14, 0.3, 0.14, 0.1);
            }
            world.playSound(null, px, py, py, SoundEvents.RESPAWN_ANCHOR_SET_SPAWN, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!player.isCreative()) {
                itemStack.shrink(6);
            }
        }
        return player.isCreative() ? ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION : ItemInteractionResult.sidedSuccess((boolean)world.isClientSide);
    }
}

