/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.blocks;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.betterx.bclib.blocks.BaseBlockNotFull;
import org.betterx.bclib.client.render.BCLRenderLayer;
import org.betterx.bclib.interfaces.RenderLayerProvider;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.blocks.EndBlockProperties;
import org.betterx.betterend.interfaces.PottablePlant;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.wover.block.api.BlockProperties;
import org.betterx.wover.tag.api.predefined.CommonBlockTags;

public class NeonCactusPlantBlock
extends BaseBlockNotFull
implements SimpleWaterloggedBlock,
RenderLayerProvider,
PottablePlant {
    public static final EnumProperty<BlockProperties.TripleShape> SHAPE = BlockProperties.TRIPLE_SHAPE;
    public static final EnumProperty<EndBlockProperties.CactusBottom> CACTUS_BOTTOM = EndBlockProperties.CACTUS_BOTTOM;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final DirectionProperty FACING = BlockStateProperties.FACING;
    private static final EnumMap<Direction, VoxelShape> BIG_SHAPES_OPEN = Maps.newEnumMap(Direction.class);
    private static final EnumMap<Direction, VoxelShape> MEDIUM_SHAPES_OPEN = Maps.newEnumMap(Direction.class);
    private static final EnumMap<Direction, VoxelShape> SMALL_SHAPES_OPEN = Maps.newEnumMap(Direction.class);
    private static final EnumMap<Direction.Axis, VoxelShape> BIG_SHAPES = Maps.newEnumMap(Direction.Axis.class);
    private static final EnumMap<Direction.Axis, VoxelShape> MEDIUM_SHAPES = Maps.newEnumMap(Direction.Axis.class);
    private static final EnumMap<Direction.Axis, VoxelShape> SMALL_SHAPES = Maps.newEnumMap(Direction.Axis.class);
    private static final int MAX_LENGTH = 12;

    public NeonCactusPlantBlock() {
        super(FabricBlockSettings.copyOf((BlockBehaviour)Blocks.CACTUS).lightLevel(bs -> 15).randomTicks());
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.UP)).setValue(SHAPE, (Comparable)BlockProperties.TripleShape.TOP));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.add(new Property[]{SHAPE, CACTUS_BOTTOM, WATERLOGGED, FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Level world = ctx.getLevel();
        BlockPos pos = ctx.getClickedPos();
        Direction dir = ctx.getClickedFace();
        BlockState down = world.getBlockState(pos.relative(dir.getOpposite()));
        BlockState state = (BlockState)((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(world.getFluidState(pos).getType() == Fluids.WATER))).setValue((Property)FACING, (Comparable)ctx.getClickedFace());
        state = down.is(Blocks.END_STONE) || down.is(EndBlocks.ENDSTONE_DUST) ? (BlockState)state.setValue(CACTUS_BOTTOM, (Comparable)((Object)EndBlockProperties.CactusBottom.SAND)) : (down.is(EndBlocks.END_MOSS) ? (BlockState)state.setValue(CACTUS_BOTTOM, (Comparable)((Object)EndBlockProperties.CactusBottom.MOSS)) : (BlockState)state.setValue(CACTUS_BOTTOM, (Comparable)((Object)EndBlockProperties.CactusBottom.EMPTY)));
        return state;
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return BlocksHelper.rotateHorizontal((BlockState)state, (Rotation)rotation, (Property)FACING);
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return BlocksHelper.mirrorHorizontal((BlockState)state, (Mirror)mirror, (Property)FACING);
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState newState, LevelAccessor world, BlockPos pos, BlockPos posFrom) {
        Direction dir;
        BlockState downState;
        world.scheduleTick(pos, (Block)this, 2);
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            world.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        state = (downState = world.getBlockState(pos.relative((dir = (Direction)state.getValue((Property)FACING)).getOpposite()))).is(Blocks.END_STONE) || downState.is(EndBlocks.ENDSTONE_DUST) ? (BlockState)state.setValue(CACTUS_BOTTOM, (Comparable)((Object)EndBlockProperties.CactusBottom.SAND)) : (downState.is(EndBlocks.END_MOSS) ? (BlockState)state.setValue(CACTUS_BOTTOM, (Comparable)((Object)EndBlockProperties.CactusBottom.MOSS)) : (BlockState)state.setValue(CACTUS_BOTTOM, (Comparable)((Object)EndBlockProperties.CactusBottom.EMPTY)));
        return state;
    }

    public void tick(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource random) {
        if (!blockState.canSurvive((LevelReader)serverLevel, blockPos)) {
            serverLevel.destroyBlock(blockPos, true, null, 1);
        }
    }

    public BCLRenderLayer getRenderLayer() {
        return BCLRenderLayer.CUTOUT;
    }

    public VoxelShape getShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        BlockProperties.TripleShape shape = (BlockProperties.TripleShape)state.getValue(SHAPE);
        Direction dir = (Direction)state.getValue((Property)FACING);
        BlockState next = view.getBlockState(pos.relative(dir));
        if (next.is((Block)this)) {
            Direction.Axis axis = dir.getAxis();
            if (shape == BlockProperties.TripleShape.BOTTOM) {
                return BIG_SHAPES.get(axis);
            }
            return shape == BlockProperties.TripleShape.MIDDLE ? MEDIUM_SHAPES.get(axis) : SMALL_SHAPES.get(axis);
        }
        if (shape == BlockProperties.TripleShape.BOTTOM) {
            return BIG_SHAPES_OPEN.get(dir);
        }
        return shape == BlockProperties.TripleShape.MIDDLE ? MEDIUM_SHAPES_OPEN.get(dir) : SMALL_SHAPES_OPEN.get(dir);
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        Direction dir = (Direction)state.getValue((Property)FACING);
        BlockPos supportPos = pos.relative(dir.getOpposite());
        BlockState support = level.getBlockState(supportPos);
        return support.is((Block)this) || support.isFaceSturdy((BlockGetter)level, supportPos, dir);
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        Direction side;
        BlockPos sidePos;
        if (!this.canSurvive(state, (LevelReader)world, pos) || random.nextInt(8) > 0) {
            return;
        }
        Direction dir = (Direction)state.getValue((Property)FACING);
        if (!world.isEmptyBlock(pos.relative(dir))) {
            return;
        }
        int length = this.getLength(state, world, pos, 12);
        if (length < 0 || length > 11) {
            return;
        }
        if (dir.getAxis().isHorizontal()) {
            int horizontal = this.getHorizontal(state, (WorldGenLevel)world, pos, 2);
            if (horizontal > random.nextInt(2)) {
                dir = Direction.UP;
                if (!world.getBlockState(pos.above()).isAir()) {
                    return;
                }
            }
        } else if (length > 1 && world.getBlockState(pos.relative(dir.getOpposite())).is((Block)this) && world.isEmptyBlock(sidePos = pos.relative(side = this.getSideDirection((WorldGenLevel)world, pos, state, dir, random)))) {
            BlockState placement = (BlockState)((BlockState)((BlockState)((BlockState)state.setValue(SHAPE, (Comparable)BlockProperties.TripleShape.TOP)).setValue(CACTUS_BOTTOM, (Comparable)((Object)EndBlockProperties.CactusBottom.EMPTY))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)side);
            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)sidePos, (BlockState)placement);
        }
        BlockState placement = (BlockState)((BlockState)((BlockState)((BlockState)state.setValue(SHAPE, (Comparable)BlockProperties.TripleShape.TOP)).setValue(CACTUS_BOTTOM, (Comparable)((Object)EndBlockProperties.CactusBottom.EMPTY))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)dir);
        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)pos.relative(dir), (BlockState)placement);
        this.mutateStem(placement, (WorldGenLevel)world, pos, 12);
    }

    public void growPlant(WorldGenLevel world, BlockPos pos, RandomSource random) {
        this.growPlant(world, pos, random, MHelper.randRange((int)6, (int)12, (RandomSource)random));
    }

    public void growPlant(WorldGenLevel world, BlockPos pos, RandomSource random, int iterations) {
        BlockState state = this.defaultBlockState();
        BlockState downState = world.getBlockState(pos.below());
        state = downState.is(Blocks.END_STONE) || downState.is(EndBlocks.ENDSTONE_DUST) ? (BlockState)state.setValue(CACTUS_BOTTOM, (Comparable)((Object)EndBlockProperties.CactusBottom.SAND)) : (downState.is(EndBlocks.END_MOSS) ? (BlockState)state.setValue(CACTUS_BOTTOM, (Comparable)((Object)EndBlockProperties.CactusBottom.MOSS)) : (BlockState)state.setValue(CACTUS_BOTTOM, (Comparable)((Object)EndBlockProperties.CactusBottom.EMPTY)));
        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)pos, (BlockState)state);
        ArrayList ends = Lists.newArrayList((Object[])new BlockPos.MutableBlockPos[]{pos.mutable()});
        for (int i = 0; i < iterations; ++i) {
            int count = ends.size();
            for (int n = 0; n < count; ++n) {
                if (this.growIteration(world, (BlockPos.MutableBlockPos)ends.get(n), random, ends, i)) continue;
                ends.remove(n);
                --count;
                --n;
            }
        }
    }

    private boolean growIteration(WorldGenLevel world, BlockPos.MutableBlockPos pos, RandomSource random, List<BlockPos.MutableBlockPos> ends, int length) {
        Direction side;
        BlockPos sidePos;
        BlockState state = world.getBlockState((BlockPos)pos);
        if (!state.is((Block)this)) {
            return false;
        }
        Direction dir = (Direction)state.getValue((Property)FACING);
        if (!world.isEmptyBlock(pos.relative(dir))) {
            return false;
        }
        if (dir.getAxis().isHorizontal()) {
            int horizontal = this.getHorizontal(state, world, (BlockPos)pos, 2);
            if (horizontal > random.nextInt(2)) {
                dir = Direction.UP;
                if (!world.getBlockState(pos.above()).isAir()) {
                    return false;
                }
            }
        } else if (length > 1 && world.getBlockState(pos.below()).is((Block)this) && world.isEmptyBlock(sidePos = pos.relative(side = this.getSideDirection(world, (BlockPos)pos, state, dir, random)))) {
            BlockState placement = (BlockState)((BlockState)((BlockState)((BlockState)state.setValue(SHAPE, (Comparable)BlockProperties.TripleShape.TOP)).setValue(CACTUS_BOTTOM, (Comparable)((Object)EndBlockProperties.CactusBottom.EMPTY))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)side);
            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)sidePos, (BlockState)placement);
            ends.add(sidePos.mutable());
        }
        BlockState placement = (BlockState)((BlockState)((BlockState)((BlockState)state.setValue(SHAPE, (Comparable)BlockProperties.TripleShape.TOP)).setValue(CACTUS_BOTTOM, (Comparable)((Object)EndBlockProperties.CactusBottom.EMPTY))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)dir);
        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)pos.relative(dir), (BlockState)placement);
        this.mutateStem(placement, world, (BlockPos)pos, 12);
        pos.move(dir);
        return true;
    }

    private Direction getSideDirection(WorldGenLevel world, BlockPos pos, BlockState iterState, Direction dir, RandomSource random) {
        Direction side;
        BlockPos.MutableBlockPos iterPos = pos.mutable();
        Direction startDir = dir;
        Direction lastDir = null;
        while (iterState.is((Block)this) && startDir.getAxis().isVertical()) {
            startDir = (Direction)iterState.getValue((Property)FACING);
            if (lastDir == null) {
                for (Direction side2 : BlocksHelper.HORIZONTAL) {
                    Direction sideDir;
                    BlockState sideState = world.getBlockState(iterPos.relative(side2));
                    if (!sideState.is((Block)this) || (sideDir = (Direction)sideState.getValue((Property)FACING)) != side2) continue;
                    lastDir = sideDir;
                }
            }
            iterPos.move(dir);
            iterState = world.getBlockState((BlockPos)iterPos);
        }
        Direction direction = side = lastDir == null ? BlocksHelper.randomHorizontal((RandomSource)random) : lastDir.getClockWise();
        if (side.getOpposite() == startDir) {
            side = side.getOpposite();
        }
        return side;
    }

    protected boolean isPathfindable(BlockState blockState, PathComputationType pathComputationType) {
        return false;
    }

    public void entityInside(BlockState blockState, Level level, BlockPos blockPos, Entity entity) {
        entity.hurt(level.damageSources().cactus(), 1.0f);
    }

    private int getLength(BlockState state, ServerLevel world, BlockPos pos, int max) {
        int length = 0;
        Direction dir = ((Direction)state.getValue((Property)FACING)).getOpposite();
        BlockPos.MutableBlockPos mut = new BlockPos.MutableBlockPos().set((Vec3i)pos);
        for (int i = 0; i < max; ++i) {
            mut.move(dir);
            state = world.getBlockState((BlockPos)mut);
            if (!state.is((Block)this)) {
                if (state.is(CommonBlockTags.END_STONES)) break;
                length = -1;
                break;
            }
            dir = ((Direction)state.getValue((Property)FACING)).getOpposite();
            ++length;
        }
        return length;
    }

    private int getHorizontal(BlockState state, WorldGenLevel world, BlockPos pos, int max) {
        int count = 0;
        Direction dir = ((Direction)state.getValue((Property)FACING)).getOpposite();
        BlockPos.MutableBlockPos mut = new BlockPos.MutableBlockPos().set((Vec3i)pos);
        for (int i = 0; i < max; ++i) {
            mut.move(dir);
            state = world.getBlockState((BlockPos)mut);
            if (!state.is((Block)this) || (dir = ((Direction)state.getValue((Property)FACING)).getOpposite()).getStepY() != 0) break;
            ++count;
        }
        return count;
    }

    private void mutateStem(BlockState state, WorldGenLevel world, BlockPos pos, int max) {
        Direction dir = ((Direction)state.getValue((Property)FACING)).getOpposite();
        BlockPos.MutableBlockPos mut = new BlockPos.MutableBlockPos().set((Vec3i)pos);
        for (int i = 0; i < max; ++i) {
            mut.move(dir);
            state = world.getBlockState((BlockPos)mut);
            if (!state.is((Block)this)) {
                return;
            }
            int size = (i + 2) * 3 / max;
            int src = ((BlockProperties.TripleShape)state.getValue(SHAPE)).getIndex();
            dir = ((Direction)state.getValue((Property)FACING)).getOpposite();
            if (src >= size) continue;
            BlockProperties.TripleShape shape = BlockProperties.TripleShape.fromIndex((int)size);
            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (BlockState)((BlockState)state.setValue(SHAPE, (Comparable)shape)));
        }
    }

    @Override
    public boolean canPlantOn(Block block) {
        return true;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public String getPottedState() {
        return "bottom=moss,shape=top,facing=up";
    }

    static {
        BIG_SHAPES.put(Direction.Axis.X, Block.box((double)0.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0));
        BIG_SHAPES.put(Direction.Axis.Y, Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0));
        BIG_SHAPES.put(Direction.Axis.Z, Block.box((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)16.0));
        MEDIUM_SHAPES.put(Direction.Axis.X, Block.box((double)0.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0, (double)13.0));
        MEDIUM_SHAPES.put(Direction.Axis.Y, Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0));
        MEDIUM_SHAPES.put(Direction.Axis.Z, Block.box((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)16.0));
        SMALL_SHAPES.put(Direction.Axis.X, Block.box((double)0.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0));
        SMALL_SHAPES.put(Direction.Axis.Y, Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0));
        SMALL_SHAPES.put(Direction.Axis.Z, Block.box((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)16.0));
        BIG_SHAPES_OPEN.put(Direction.UP, Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0));
        BIG_SHAPES_OPEN.put(Direction.DOWN, Block.box((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0));
        BIG_SHAPES_OPEN.put(Direction.NORTH, Block.box((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)14.0, (double)16.0));
        BIG_SHAPES_OPEN.put(Direction.SOUTH, Block.box((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)14.0));
        BIG_SHAPES_OPEN.put(Direction.WEST, Block.box((double)2.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0));
        BIG_SHAPES_OPEN.put(Direction.EAST, Block.box((double)0.0, (double)2.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0));
        MEDIUM_SHAPES_OPEN.put(Direction.UP, Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0));
        MEDIUM_SHAPES_OPEN.put(Direction.DOWN, Block.box((double)3.0, (double)3.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0));
        MEDIUM_SHAPES_OPEN.put(Direction.NORTH, Block.box((double)3.0, (double)3.0, (double)3.0, (double)13.0, (double)13.0, (double)16.0));
        MEDIUM_SHAPES_OPEN.put(Direction.SOUTH, Block.box((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)13.0));
        MEDIUM_SHAPES_OPEN.put(Direction.WEST, Block.box((double)3.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0, (double)13.0));
        MEDIUM_SHAPES_OPEN.put(Direction.EAST, Block.box((double)0.0, (double)3.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0));
        SMALL_SHAPES_OPEN.put(Direction.UP, Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0));
        SMALL_SHAPES_OPEN.put(Direction.DOWN, Block.box((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0));
        SMALL_SHAPES_OPEN.put(Direction.NORTH, Block.box((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)16.0));
        SMALL_SHAPES_OPEN.put(Direction.SOUTH, Block.box((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)12.0));
        SMALL_SHAPES_OPEN.put(Direction.WEST, Block.box((double)4.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0));
        SMALL_SHAPES_OPEN.put(Direction.EAST, Block.box((double)0.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0));
    }
}

