/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.blocks;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.pathfinder.PathComputationType;
import org.betterx.bclib.behaviours.BehaviourBuilders;
import org.betterx.betterend.blocks.basis.EndPlantBlock;
import org.betterx.betterend.interfaces.survives.SurvivesOnShadowGrass;

public class MurkweedBlock
extends EndPlantBlock
implements SurvivesOnShadowGrass {
    public MurkweedBlock() {
        super(BehaviourBuilders.createPlant((MapColor)MapColor.COLOR_BLACK).ignitedByLava());
    }

    @Environment(value=EnvType.CLIENT)
    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        double x = (double)pos.getX() + random.nextDouble();
        double y = (double)pos.getY() + random.nextDouble() * 0.5 + 0.5;
        double z = (double)pos.getZ() + random.nextDouble();
        double v = random.nextDouble() * 0.1;
        world.addParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (int)-1), x, y, z, v, v, v);
    }

    public void entityInside(BlockState state, Level world, BlockPos pos, Entity entity) {
        if (entity instanceof LivingEntity && !((LivingEntity)entity).hasEffect(MobEffects.BLINDNESS)) {
            ((LivingEntity)entity).addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 50));
        }
    }

    protected boolean isPathfindable(BlockState blockState, PathComputationType pathComputationType) {
        return false;
    }

    public boolean isTerrain(BlockState state) {
        return SurvivesOnShadowGrass.super.isTerrain(state);
    }
}

