/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.blocks;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.betterx.bclib.blocks.BaseBlockNotFull;
import org.betterx.bclib.client.render.BCLRenderLayer;
import org.betterx.bclib.interfaces.RenderLayerProvider;
import org.betterx.bclib.interfaces.tools.AddMineableHoe;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.wover.tag.api.predefined.CommonBlockTags;
import org.jetbrains.annotations.NotNull;

public class MengerSpongeBlock
extends BaseBlockNotFull
implements RenderLayerProvider,
AddMineableHoe {
    public static final VoxelShape SHAPE = Shapes.or((VoxelShape)Shapes.or((VoxelShape)MengerSpongeBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)6.0), (VoxelShape[])new VoxelShape[]{MengerSpongeBlock.box((double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)6.0, (double)16.0), Shapes.or((VoxelShape)MengerSpongeBlock.box((double)0.0, (double)10.0, (double)0.0, (double)16.0, (double)16.0, (double)6.0), (VoxelShape)MengerSpongeBlock.box((double)0.0, (double)10.0, (double)10.0, (double)16.0, (double)16.0, (double)16.0)), Shapes.or((VoxelShape)MengerSpongeBlock.box((double)0.0, (double)0.0, (double)0.0, (double)6.0, (double)6.0, (double)16.0), (VoxelShape)MengerSpongeBlock.box((double)10.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0)), Shapes.or((VoxelShape)MengerSpongeBlock.box((double)0.0, (double)10.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0), (VoxelShape)MengerSpongeBlock.box((double)10.0, (double)10.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)), Shapes.or((VoxelShape)MengerSpongeBlock.box((double)0.0, (double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)6.0), (VoxelShape)MengerSpongeBlock.box((double)10.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)6.0)), Shapes.or((VoxelShape)MengerSpongeBlock.box((double)0.0, (double)0.0, (double)10.0, (double)6.0, (double)16.0, (double)16.0), (VoxelShape)MengerSpongeBlock.box((double)10.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0, (double)16.0))}), (VoxelShape[])new VoxelShape[0]);

    public MengerSpongeBlock() {
        super(FabricBlockSettings.copyOf((BlockBehaviour)Blocks.SPONGE).noOcclusion());
    }

    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify) {
        if (this.absorbWater((LevelAccessor)world, pos)) {
            world.setBlockAndUpdate(pos, EndBlocks.MENGER_SPONGE_WET.defaultBlockState());
        }
    }

    @NotNull
    public BlockState updateShape(BlockState state, Direction facing, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (this.absorbWater(world, pos)) {
            return EndBlocks.MENGER_SPONGE_WET.defaultBlockState();
        }
        return state;
    }

    private boolean absorbWater(LevelAccessor world, BlockPos pos) {
        LinkedList queue = Lists.newLinkedList();
        queue.add(new Tuple((Object)pos, (Object)0));
        int i = 0;
        while (!queue.isEmpty()) {
            Tuple pair = (Tuple)queue.poll();
            BlockPos blockPos = (BlockPos)pair.getA();
            int j = (Integer)pair.getB();
            for (Direction direction : Direction.values()) {
                BlockPos blockPos2 = blockPos.relative(direction);
                BlockState blockState = world.getBlockState(blockPos2);
                FluidState fluidState = world.getFluidState(blockPos2);
                if (!fluidState.is(FluidTags.WATER)) continue;
                if (blockState.getBlock() instanceof BucketPickup && !((BucketPickup)blockState.getBlock()).pickupBlock(null, world, blockPos2, blockState).isEmpty()) {
                    ++i;
                    if (j >= 6) continue;
                    queue.add(new Tuple((Object)blockPos2, (Object)(j + 1)));
                    continue;
                }
                if (blockState.getBlock() instanceof LiquidBlock) {
                    world.setBlock(blockPos2, Blocks.AIR.defaultBlockState(), 3);
                    ++i;
                    if (j >= 6) continue;
                    queue.add(new Tuple((Object)blockPos2, (Object)(j + 1)));
                    continue;
                }
                if (!blockState.is(CommonBlockTags.WATER_PLANT)) continue;
                BlockEntity blockEntity = blockState.hasBlockEntity() ? world.getBlockEntity(blockPos2) : null;
                MengerSpongeBlock.dropResources((BlockState)blockState, (LevelAccessor)world, (BlockPos)blockPos2, (BlockEntity)blockEntity);
                world.setBlock(blockPos2, Blocks.AIR.defaultBlockState(), 3);
                ++i;
                if (j >= 6) continue;
                queue.add(new Tuple((Object)blockPos2, (Object)(j + 1)));
            }
            if (i <= 64) continue;
            break;
        }
        return i > 0;
    }

    public BCLRenderLayer getRenderLayer() {
        return BCLRenderLayer.CUTOUT;
    }

    @NotNull
    public VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return SHAPE;
    }
}

