/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.blocks;

import java.util.Collections;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.betterx.bclib.behaviours.BehaviourBuilders;
import org.betterx.bclib.blocks.BaseBlockNotFull;
import org.betterx.bclib.client.render.BCLRenderLayer;
import org.betterx.bclib.interfaces.RenderLayerProvider;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.blocks.EndBlockProperties;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.betterend.registry.EndItems;
import org.betterx.wover.tag.api.predefined.CommonBlockTags;

public class LumecornBlock
extends BaseBlockNotFull.Wood
implements RenderLayerProvider {
    public static final EnumProperty<EndBlockProperties.LumecornShape> SHAPE = EnumProperty.create((String)"shape", EndBlockProperties.LumecornShape.class);
    private static final VoxelShape SHAPE_BOTTOM = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final VoxelShape SHAPE_TOP = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)8.0, (double)10.0);

    public LumecornBlock() {
        super(BehaviourBuilders.createWood().strength(0.5f).lightLevel(state -> ((EndBlockProperties.LumecornShape)((Object)((Object)state.getValue(SHAPE)))).getLight()));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.add(new Property[]{SHAPE});
    }

    public BCLRenderLayer getRenderLayer() {
        return BCLRenderLayer.CUTOUT;
    }

    public VoxelShape getShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        return state.getValue(SHAPE) == EndBlockProperties.LumecornShape.LIGHT_TOP ? SHAPE_TOP : SHAPE_BOTTOM;
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        EndBlockProperties.LumecornShape shape = (EndBlockProperties.LumecornShape)((Object)state.getValue(SHAPE));
        if (shape == EndBlockProperties.LumecornShape.BOTTOM_BIG || shape == EndBlockProperties.LumecornShape.BOTTOM_SMALL) {
            return world.getBlockState(pos.below()).is(CommonBlockTags.END_STONES);
        }
        if (shape == EndBlockProperties.LumecornShape.LIGHT_TOP) {
            return world.getBlockState(pos.below()).is((Block)this);
        }
        return world.getBlockState(pos.below()).is((Block)this) && world.getBlockState(pos.above()).is((Block)this);
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (!this.canSurvive(state, (LevelReader)world, pos)) {
            return Blocks.AIR.defaultBlockState();
        }
        return state;
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        EndBlockProperties.LumecornShape shape = (EndBlockProperties.LumecornShape)((Object)state.getValue(SHAPE));
        if (shape == EndBlockProperties.LumecornShape.BOTTOM_BIG || shape == EndBlockProperties.LumecornShape.BOTTOM_SMALL || shape == EndBlockProperties.LumecornShape.MIDDLE) {
            return Collections.singletonList(new ItemStack((ItemLike)EndBlocks.LUMECORN_SEED, MHelper.randRange((int)1, (int)2, (RandomSource)MHelper.RANDOM_SOURCE)));
        }
        return MHelper.RANDOM.nextBoolean() ? Collections.singletonList(new ItemStack((ItemLike)EndItems.LUMECORN_ROD)) : Collections.emptyList();
    }

    @Environment(value=EnvType.CLIENT)
    public ItemStack getCloneItemStack(LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
        EndBlockProperties.LumecornShape shape = (EndBlockProperties.LumecornShape)((Object)blockState.getValue(SHAPE));
        if (shape == EndBlockProperties.LumecornShape.BOTTOM_BIG || shape == EndBlockProperties.LumecornShape.BOTTOM_SMALL || shape == EndBlockProperties.LumecornShape.MIDDLE) {
            return new ItemStack((ItemLike)EndBlocks.LUMECORN_SEED);
        }
        return new ItemStack((ItemLike)EndItems.LUMECORN_ROD);
    }
}

