/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.blocks;

import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootParams;
import org.betterx.bclib.behaviours.BehaviourBuilders;
import org.betterx.bclib.behaviours.interfaces.BehaviourPlant;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.blocks.basis.EndPlantBlock;
import org.betterx.betterend.interfaces.survives.SurvivesOnAmberMoss;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.wover.block.api.BlockProperties;

public class LanceleafBlock
extends EndPlantBlock
implements SurvivesOnAmberMoss,
BehaviourPlant {
    public static final EnumProperty<BlockProperties.PentaShape> SHAPE = BlockProperties.PENTA_SHAPE;
    public static final IntegerProperty ROTATION = BlockProperties.ROTATION;

    public LanceleafBlock() {
        super(BehaviourBuilders.createPlant((MapColor)MapColor.TERRACOTTA_BROWN).ignitedByLava().offsetType(BlockBehaviour.OffsetType.XZ));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.add(new Property[]{SHAPE, ROTATION});
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        BlockProperties.PentaShape shape = (BlockProperties.PentaShape)state.getValue(SHAPE);
        if (shape == BlockProperties.PentaShape.TOP) {
            return world.getBlockState(pos.below()).is((Block)this);
        }
        if (shape == BlockProperties.PentaShape.BOTTOM) {
            return this.canSurviveOnTop(world, pos) && world.getBlockState(pos.above()).is((Block)this);
        }
        return world.getBlockState(pos.below()).is((Block)this) && world.getBlockState(pos.above()).is((Block)this);
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (!this.canSurvive(state, (LevelReader)world, pos)) {
            return Blocks.AIR.defaultBlockState();
        }
        return state;
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        if (state.getValue(SHAPE) == BlockProperties.PentaShape.BOTTOM) {
            return Collections.singletonList(new ItemStack((ItemLike)EndBlocks.LANCELEAF_SEED));
        }
        return MHelper.RANDOM.nextBoolean() ? Collections.emptyList() : Collections.singletonList(new ItemStack((ItemLike)EndBlocks.LANCELEAF_SEED));
    }

    public boolean isTerrain(BlockState state) {
        return SurvivesOnAmberMoss.super.isTerrain(state);
    }
}

