/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.blocks;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SlimeBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import org.betterx.bclib.client.models.ModelsHelper;
import org.betterx.bclib.client.render.BCLRenderLayer;
import org.betterx.bclib.interfaces.CustomColorProvider;
import org.betterx.bclib.interfaces.RenderLayerProvider;
import org.betterx.bclib.interfaces.RuntimeBlockModelProvider;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.blocks.EndBlockProperties;
import org.betterx.betterend.client.models.Patterns;
import org.betterx.betterend.noise.OpenSimplexNoise;
import org.betterx.ui.ColorUtil;
import org.jetbrains.annotations.Nullable;

public class JellyshroomCapBlock
extends SlimeBlock
implements RenderLayerProvider,
RuntimeBlockModelProvider,
CustomColorProvider {
    public static final IntegerProperty COLOR = EndBlockProperties.COLOR;
    private static final OpenSimplexNoise NOISE = new OpenSimplexNoise(0L);
    private final Vec3i colorStart;
    private final Vec3i colorEnd;
    private final int coloritem;

    public JellyshroomCapBlock(int r1, int g1, int b1, int r2, int g2, int b2) {
        super((BlockBehaviour.Properties)FabricBlockSettings.copyOf((BlockBehaviour)Blocks.SLIME_BLOCK));
        this.colorStart = new Vec3i(r1, g1, b1);
        this.colorEnd = new Vec3i(r2, g2, b2);
        this.coloritem = ColorUtil.color((int)(r1 + r2 >> 1), (int)(g1 + g2 >> 1), (int)(b1 + b2 >> 1));
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        double px = (double)ctx.getClickedPos().getX() * 0.1;
        double py = (double)ctx.getClickedPos().getY() * 0.1;
        double pz = (double)ctx.getClickedPos().getZ() * 0.1;
        return (BlockState)this.defaultBlockState().setValue((Property)COLOR, (Comparable)Integer.valueOf(MHelper.floor((double)(NOISE.eval(px, py, pz) * 3.5 + 4.0))));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.add(new Property[]{COLOR});
    }

    public BCLRenderLayer getRenderLayer() {
        return BCLRenderLayer.TRANSLUCENT;
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        return Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)this)});
    }

    @Environment(value=EnvType.CLIENT)
    public BlockModel getItemModel(ResourceLocation resourceLocation) {
        return this.getBlockModel(resourceLocation, this.defaultBlockState());
    }

    @Environment(value=EnvType.CLIENT)
    @Nullable
    public BlockModel getBlockModel(ResourceLocation resourceLocation, BlockState blockState) {
        Optional<String> pattern = Patterns.createJson(Patterns.BLOCK_COLORED, "jellyshroom_cap");
        return ModelsHelper.fromPattern(pattern);
    }

    public BlockColor getProvider() {
        return (state, world, pos, tintIndex) -> {
            float delta = (float)((Integer)state.getValue((Property)COLOR)).intValue() / 7.0f;
            int r = Mth.floor((float)(Mth.lerp((float)delta, (float)((float)this.colorStart.getX() / 255.0f), (float)((float)this.colorEnd.getX() / 255.0f)) * 255.0f));
            int g = Mth.floor((float)(Mth.lerp((float)delta, (float)((float)this.colorStart.getY() / 255.0f), (float)((float)this.colorEnd.getY() / 255.0f)) * 255.0f));
            int b = Mth.floor((float)(Mth.lerp((float)delta, (float)((float)this.colorStart.getZ() / 255.0f), (float)((float)this.colorEnd.getZ() / 255.0f)) * 255.0f));
            return ColorUtil.color((int)r, (int)g, (int)b);
        };
    }

    public ItemColor getItemProvider() {
        return (stack, tintIndex) -> this.coloritem;
    }
}

