/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.blocks;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.betterx.bclib.behaviours.BehaviourBuilders;
import org.betterx.bclib.blocks.BaseBlockNotFull;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.betterend.blocks.entities.BlockEntityHydrothermalVent;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.wover.block.api.BlockProperties;
import org.jetbrains.annotations.Nullable;

public class HydrothermalVentBlock
extends BaseBlockNotFull.Stone
implements EntityBlock,
LiquidBlockContainer,
SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final BooleanProperty ACTIVATED = BlockProperties.ACTIVE;
    private static final VoxelShape SHAPE = Block.box((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);

    public HydrothermalVentBlock() {
        super(BehaviourBuilders.createStone().sound(SoundType.STONE).noCollission().requiresCorrectToolForDrops());
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true))).setValue((Property)ACTIVATED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED, ACTIVATED});
    }

    public VoxelShape getShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        return SHAPE;
    }

    public boolean canPlaceLiquid(@Nullable Player player, BlockGetter blockGetter, BlockPos blockPos, BlockState blockState, Fluid fluid) {
        return false;
    }

    public boolean placeLiquid(LevelAccessor world, BlockPos pos, BlockState state, FluidState fluidState) {
        return false;
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        state = world.getBlockState(pos.below());
        return state.is(EndBlocks.SULPHURIC_ROCK.stone);
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (!this.canSurvive(state, (LevelReader)world, pos)) {
            return Blocks.WATER.defaultBlockState();
        }
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue() && facing == Direction.UP && neighborState.is(Blocks.WATER)) {
            world.scheduleTick(pos, (Block)this, 20);
        }
        return state;
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Level worldAccess = ctx.getLevel();
        BlockPos blockPos = ctx.getClickedPos();
        return (BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(worldAccess.getFluidState(blockPos).getType() == Fluids.WATER));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BlockEntityHydrothermalVent(pos, state);
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        BlockPos up = pos.above();
        if (world.getBlockState(up).is(Blocks.WATER)) {
            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)up, (Block)EndBlocks.VENT_BUBBLE_COLUMN);
            world.scheduleTick(up, EndBlocks.VENT_BUBBLE_COLUMN, 5);
        }
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        if (world instanceof ServerLevel && ((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue() && world.getBlockState(pos.above()).is(Blocks.WATER)) {
            this.tick(state, (ServerLevel)world, pos, world.random);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        super.animateTick(state, world, pos, random);
        if (!((Boolean)state.getValue((Property)ACTIVATED)).booleanValue() && random.nextBoolean()) {
            double x = (double)pos.getX() + random.nextDouble();
            double y = (double)pos.getY() + 0.9 + random.nextDouble() * 0.3;
            double z = (double)pos.getZ() + random.nextDouble();
            world.addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return BlockEntityHydrothermalVent::tick;
    }
}

