/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.blocks;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.math.Transformation;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.multipart.MultiPart;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.betterx.bclib.behaviours.interfaces.BehaviourStone;
import org.betterx.bclib.blocks.BaseBlockNotFull;
import org.betterx.bclib.client.models.BasePatterns;
import org.betterx.bclib.client.models.ModelsHelper;
import org.betterx.bclib.client.models.PatternsHelper;
import org.betterx.bclib.client.render.BCLRenderLayer;
import org.betterx.bclib.interfaces.PostInitable;
import org.betterx.bclib.interfaces.RenderLayerProvider;
import org.betterx.bclib.interfaces.RuntimeBlockModelProvider;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.bclib.util.JsonFactory;
import org.betterx.betterend.BetterEnd;
import org.betterx.betterend.blocks.EndBlockProperties;
import org.betterx.betterend.blocks.basis.PottableLeavesBlock;
import org.betterx.betterend.client.models.Patterns;
import org.betterx.betterend.interfaces.PottablePlant;
import org.betterx.betterend.interfaces.PottableTerrain;
import org.betterx.betterend.registry.EndBlocks;
import org.joml.Vector3f;

public class FlowerPotBlock
extends BaseBlockNotFull
implements RenderLayerProvider,
PostInitable,
RuntimeBlockModelProvider {
    private static final IntegerProperty PLANT_ID = EndBlockProperties.PLANT_ID;
    private static final IntegerProperty SOIL_ID = EndBlockProperties.SOIL_ID;
    private static final IntegerProperty POT_LIGHT = EndBlockProperties.POT_LIGHT;
    private static final VoxelShape SHAPE_EMPTY = Shapes.or((VoxelShape)Block.box((double)4.0, (double)1.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0), (VoxelShape)Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)1.0, (double)11.0));
    private static final VoxelShape SHAPE_FULL = Shapes.or((VoxelShape)SHAPE_EMPTY, (VoxelShape)Block.box((double)3.0, (double)8.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0));
    private static Block[] plants;
    private static Block[] soils;

    public FlowerPotBlock(Block source) {
        super((BlockBehaviour.Properties)FabricBlockSettings.copyOf((BlockBehaviour)source).luminance(state -> (Integer)state.getValue((Property)POT_LIGHT) * 5));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)PLANT_ID, (Comparable)Integer.valueOf(0))).setValue((Property)SOIL_ID, (Comparable)Integer.valueOf(0))).setValue((Property)POT_LIGHT, (Comparable)Integer.valueOf(0)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{PLANT_ID, SOIL_ID, POT_LIGHT});
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        ArrayList drop = Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)this)});
        int id = (Integer)state.getValue((Property)SOIL_ID) - 1;
        if (id >= 0 && id < soils.length && soils[id] != null) {
            drop.add(new ItemStack((ItemLike)soils[id]));
        }
        if ((id = (Integer)state.getValue((Property)PLANT_ID) - 1) >= 0 && id < plants.length && plants[id] != null) {
            drop.add(new ItemStack((ItemLike)plants[id]));
        }
        return drop;
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        int plantID = (Integer)state.getValue((Property)PLANT_ID);
        if (plantID < 1 || plantID > plants.length || plants[plantID - 1] == null) {
            return (Integer)state.getValue((Property)POT_LIGHT) > 0 ? (BlockState)state.setValue((Property)POT_LIGHT, (Comparable)Integer.valueOf(0)) : state;
        }
        int light = plants[plantID - 1].defaultBlockState().getLightEmission() / 5;
        if ((Integer)state.getValue((Property)POT_LIGHT) != light) {
            state = (BlockState)state.setValue((Property)POT_LIGHT, (Comparable)Integer.valueOf(light));
        }
        return state;
    }

    public void postInit() {
        if (plants != null) {
            return;
        }
        Block[] plants = new Block[128];
        Block[] soils = new Block[16];
        HashMap reservedPlantsIDs = Maps.newHashMap();
        HashMap reservedSoilIDs = Maps.newHashMap();
        JsonObject obj = JsonFactory.getJsonObject((File)new File(FabricLoader.getInstance().getConfigDir().toFile(), BetterEnd.MOD_ID + "/blocks.json"));
        if (obj.get("flower_pots") != null) {
            JsonElement plantsObj = obj.get("flower_pots").getAsJsonObject().get("plants");
            JsonElement soilsObj = obj.get("flower_pots").getAsJsonObject().get("soils");
            if (plantsObj != null) {
                plantsObj.getAsJsonObject().entrySet().forEach(entry -> {
                    String name = ((String)entry.getKey()).substring(0, ((String)entry.getKey()).indexOf(32));
                    reservedPlantsIDs.put(name, ((JsonElement)entry.getValue()).getAsInt());
                });
            }
            if (soilsObj != null) {
                soilsObj.getAsJsonObject().entrySet().forEach(entry -> {
                    String name = ((String)entry.getKey()).substring(0, ((String)entry.getKey()).indexOf(32));
                    reservedSoilIDs.put(name, ((JsonElement)entry.getValue()).getAsInt());
                });
            }
        }
        EndBlocks.getModBlocks().forEach(block -> {
            if (block instanceof PottablePlant && ((PottablePlant)block).canBePotted()) {
                this.processBlock(plants, (Block)block, "flower_pots.plants", reservedPlantsIDs);
            } else if (block instanceof PottableTerrain && ((PottableTerrain)block).canBePotted()) {
                this.processBlock(soils, (Block)block, "flower_pots.soils", reservedSoilIDs);
            }
        });
        FlowerPotBlock.plants = new Block[this.maxNotNull(plants) + 1];
        System.arraycopy(plants, 0, FlowerPotBlock.plants, 0, FlowerPotBlock.plants.length);
        FlowerPotBlock.soils = new Block[this.maxNotNull(soils) + 1];
        System.arraycopy(soils, 0, FlowerPotBlock.soils, 0, FlowerPotBlock.soils.length);
        if (PLANT_ID.getValue(Integer.toString(FlowerPotBlock.plants.length)).isEmpty()) {
            throw new RuntimeException("There are too much plant ID values!");
        }
        if (SOIL_ID.getValue(Integer.toString(FlowerPotBlock.soils.length)).isEmpty()) {
            throw new RuntimeException("There are too much soil ID values!");
        }
    }

    private int maxNotNull(Block[] array) {
        int max = 0;
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == null) continue;
            max = i;
        }
        return max;
    }

    private void processBlock(Block[] target, Block block, String path, Map<String, Integer> idMap) {
        ResourceLocation location = BuiltInRegistries.BLOCK.getKey((Object)block);
        if (idMap.containsKey(location.getPath())) {
            target[idMap.get((Object)location.getPath()).intValue()] = block;
        } else {
            for (int i = 0; i < target.length; ++i) {
                if (idMap.containsValue(i)) continue;
                target[i] = block;
                idMap.put(location.getPath(), i);
                break;
            }
        }
    }

    public ItemInteractionResult useItemOn(ItemStack itemStack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.isClientSide) {
            return ItemInteractionResult.CONSUME;
        }
        int soilID = (Integer)state.getValue((Property)SOIL_ID);
        if (soilID == 0 || soilID > soils.length || soils[soilID - 1] == null) {
            if (!(itemStack.getItem() instanceof BlockItem)) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            Block block = ((BlockItem)itemStack.getItem()).getBlock();
            for (int i = 0; i < soils.length; ++i) {
                if (block != soils[i]) continue;
                BlocksHelper.setWithUpdate((LevelAccessor)level, (BlockPos)pos, (BlockState)((BlockState)state.setValue((Property)SOIL_ID, (Comparable)Integer.valueOf(i + 1))));
                if (!player.isCreative()) {
                    itemStack.shrink(1);
                }
                level.playSound(player, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.SOUL_SOIL_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
                return ItemInteractionResult.SUCCESS;
            }
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        int plantID = (Integer)state.getValue((Property)PLANT_ID);
        if (itemStack.isEmpty()) {
            if (plantID > 0 && plantID <= plants.length && plants[plantID - 1] != null) {
                BlocksHelper.setWithUpdate((LevelAccessor)level, (BlockPos)pos, (BlockState)((BlockState)((BlockState)state.setValue((Property)PLANT_ID, (Comparable)Integer.valueOf(0))).setValue((Property)POT_LIGHT, (Comparable)Integer.valueOf(0))));
                player.addItem(new ItemStack((ItemLike)plants[plantID - 1]));
                return ItemInteractionResult.SUCCESS;
            }
            if (soilID > 0 && soilID <= soils.length && soils[soilID - 1] != null) {
                BlocksHelper.setWithUpdate((LevelAccessor)level, (BlockPos)pos, (BlockState)((BlockState)state.setValue((Property)SOIL_ID, (Comparable)Integer.valueOf(0))));
                player.addItem(new ItemStack((ItemLike)soils[soilID - 1]));
            }
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (!(itemStack.getItem() instanceof BlockItem)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        BlockItem item = (BlockItem)itemStack.getItem();
        for (int i = 0; i < plants.length; ++i) {
            if (item.getBlock() != plants[i]) continue;
            if (!((PottablePlant)plants[i]).canPlantOn(soils[soilID - 1])) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            int light = plants[i].defaultBlockState().getLightEmission() / 5;
            BlocksHelper.setWithUpdate((LevelAccessor)level, (BlockPos)pos, (BlockState)((BlockState)((BlockState)state.setValue((Property)PLANT_ID, (Comparable)Integer.valueOf(i + 1))).setValue((Property)POT_LIGHT, (Comparable)Integer.valueOf(light))));
            level.playSound(player, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.HOE_TILL, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!player.isCreative()) {
                itemStack.shrink(1);
            }
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Environment(value=EnvType.CLIENT)
    public BlockModel getItemModel(ResourceLocation blockId) {
        Optional pattern = PatternsHelper.createJson((ResourceLocation)Patterns.BLOCK_FLOWER_POT, (ResourceLocation)blockId);
        return ModelsHelper.fromPattern((Optional)pattern);
    }

    @Environment(value=EnvType.CLIENT)
    public UnbakedModel getModelVariant(ModelResourceLocation stateId, BlockState blockState, Map<ResourceLocation, UnbakedModel> modelCache) {
        int i;
        ModelsHelper.MultiPartBuilder model = ModelsHelper.MultiPartBuilder.create((StateDefinition)this.stateDefinition);
        model.part(new ModelResourceLocation(stateId.id(), "inventory")).add();
        Transformation offset = new Transformation(new Vector3f(0.0f, 0.46875f, 0.0f), null, null, null);
        for (i = 0; i < plants.length; ++i) {
            BlockModel unbakedModel;
            Optional<String> pattern;
            HashMap textures;
            ResourceLocation loc;
            if (plants[i] == null) continue;
            int compareID = i + 1;
            ResourceLocation modelPath = BuiltInRegistries.BLOCK.getKey((Object)plants[i]);
            ResourceLocation objSource = ResourceLocation.fromNamespaceAndPath((String)modelPath.getNamespace(), (String)("models/block/" + modelPath.getPath() + "_potted.json"));
            if (Minecraft.getInstance().getResourceManager().getResource(objSource).isPresent()) {
                objSource = ResourceLocation.fromNamespaceAndPath((String)modelPath.getNamespace(), (String)("block/" + modelPath.getPath() + "_potted"));
                model.part(objSource).setTransformation(offset).setCondition(state -> (Integer)state.getValue((Property)PLANT_ID) == compareID).add();
                continue;
            }
            if (plants[i] instanceof SaplingBlock) {
                loc = BuiltInRegistries.BLOCK.getKey((Object)plants[i]);
                modelPath = ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("block/" + loc.getPath() + "_potted"));
                textures = Maps.newHashMap();
                textures.put("%modid%", loc.getNamespace());
                textures.put("%texture%", loc.getPath());
                pattern = Patterns.createJson(BasePatterns.BLOCK_CROSS, textures);
                unbakedModel = ModelsHelper.fromPattern(pattern);
                modelCache.put(modelPath, (UnbakedModel)unbakedModel);
                model.part(modelPath).setTransformation(offset).setCondition(state -> (Integer)state.getValue((Property)PLANT_ID) == compareID).add();
                continue;
            }
            if (plants[i] instanceof PottableLeavesBlock) {
                loc = BuiltInRegistries.BLOCK.getKey((Object)plants[i]);
                modelPath = ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("block/" + loc.getPath() + "_potted"));
                textures = Maps.newHashMap();
                textures.put("%leaves%", loc.getPath().contains("lucernia") ? loc.getPath() + "_1" : loc.getPath());
                textures.put("%stem%", loc.getPath().replace("_leaves", "_log_side"));
                pattern = Patterns.createJson(Patterns.BLOCK_POTTED_LEAVES, textures);
                unbakedModel = ModelsHelper.fromPattern(pattern);
                modelCache.put(modelPath, (UnbakedModel)unbakedModel);
                model.part(modelPath).setTransformation(offset).setCondition(state -> (Integer)state.getValue((Property)PLANT_ID) == compareID).add();
                continue;
            }
            objSource = ResourceLocation.fromNamespaceAndPath((String)modelPath.getNamespace(), (String)("blockstates/" + modelPath.getPath() + ".json"));
            JsonObject obj = JsonFactory.getJsonObject((ResourceLocation)objSource);
            if (obj != null) {
                JsonElement variants = obj.get("variants");
                JsonElement list = null;
                String path = null;
                if (variants == null) continue;
                if (variants.isJsonArray()) {
                    list = variants.getAsJsonArray().get(0);
                } else if (variants.isJsonObject()) {
                    list = variants.getAsJsonObject().get(((PottablePlant)plants[i]).getPottedState());
                }
                if (list == null) {
                    BetterEnd.LOGGER.warn("Incorrect json for pot plant " + String.valueOf(objSource) + ", no matching variants");
                    continue;
                }
                path = list.isJsonArray() ? list.getAsJsonArray().get(0).getAsJsonObject().get("model").getAsString() : list.getAsJsonObject().get("model").getAsString();
                if (path == null) {
                    BetterEnd.LOGGER.warn("Incorrect json for pot plant " + String.valueOf(objSource) + ", no matching variants");
                    continue;
                }
                model.part(ResourceLocation.parse((String)path)).setTransformation(offset).setCondition(state -> (Integer)state.getValue((Property)PLANT_ID) == compareID).add();
                continue;
            }
            ResourceLocation loc2 = BuiltInRegistries.BLOCK.getKey((Object)plants[i]);
            modelPath = ResourceLocation.fromNamespaceAndPath((String)loc2.getNamespace(), (String)("block/" + loc2.getPath() + "_potted"));
            HashMap textures2 = Maps.newHashMap();
            textures2.put("%modid%", loc2.getNamespace());
            textures2.put("%texture%", loc2.getPath());
            Optional<String> pattern2 = Patterns.createJson(BasePatterns.BLOCK_CROSS, textures2);
            BlockModel unbakedModel2 = ModelsHelper.fromPattern(pattern2);
            modelCache.put(modelPath, (UnbakedModel)unbakedModel2);
            model.part(modelPath).setTransformation(offset).setCondition(state -> (Integer)state.getValue((Property)PLANT_ID) == compareID).add();
        }
        for (i = 0; i < soils.length; ++i) {
            if (soils[i] == null) continue;
            ResourceLocation soilLoc = BetterEnd.C.mk("flower_pot_soil_" + i);
            if (!modelCache.containsKey(soilLoc)) {
                String texture = BuiltInRegistries.BLOCK.getKey((Object)soils[i]).getPath() + "_top";
                if (texture.contains("rutiscus")) {
                    texture = texture + "_1";
                }
                Optional<String> pattern = Patterns.createJson(Patterns.BLOCK_FLOWER_POT_SOIL, texture);
                BlockModel soil = ModelsHelper.fromPattern(pattern);
                modelCache.put(soilLoc, (UnbakedModel)soil);
            }
            int compareID = i + 1;
            model.part(soilLoc).setCondition(state -> (Integer)state.getValue((Property)SOIL_ID) == compareID).add();
        }
        MultiPart result = model.build();
        modelCache.put(stateId.id(), (UnbakedModel)result);
        return result;
    }

    public VoxelShape getShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        int id = (Integer)state.getValue((Property)PLANT_ID);
        return id > 0 && id <= plants.length ? SHAPE_FULL : SHAPE_EMPTY;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        return SHAPE_EMPTY;
    }

    public BCLRenderLayer getRenderLayer() {
        return BCLRenderLayer.CUTOUT;
    }

    public static class Stone
    extends FlowerPotBlock
    implements BehaviourStone {
        public Stone(Block source) {
            super(source);
        }
    }
}

