/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.blocks;

import com.google.common.collect.Maps;
import java.util.EnumMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.betterx.bclib.behaviours.BehaviourBuilders;
import org.betterx.bclib.behaviours.interfaces.BehaviourPlant;
import org.betterx.bclib.blocks.BaseAttachedBlock;
import org.betterx.bclib.client.render.BCLRenderLayer;
import org.betterx.bclib.interfaces.RenderLayerProvider;

public class FilaluxWingsBlock
extends BaseAttachedBlock
implements RenderLayerProvider,
BehaviourPlant {
    private static final EnumMap<Direction, VoxelShape> BOUNDING_SHAPES = Maps.newEnumMap(Direction.class);

    public FilaluxWingsBlock() {
        super(BehaviourBuilders.createPlant((MapColor)MapColor.COLOR_RED).sound(SoundType.WET_GRASS));
    }

    public BCLRenderLayer getRenderLayer() {
        return BCLRenderLayer.CUTOUT;
    }

    public VoxelShape getShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        return BOUNDING_SHAPES.get(state.getValue((Property)FACING));
    }

    static {
        BOUNDING_SHAPES.put(Direction.UP, Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.5, (double)1.0));
        BOUNDING_SHAPES.put(Direction.DOWN, Shapes.box((double)0.0, (double)0.5, (double)0.0, (double)1.0, (double)1.0, (double)1.0));
        BOUNDING_SHAPES.put(Direction.NORTH, Shapes.box((double)0.0, (double)0.0, (double)0.5, (double)1.0, (double)1.0, (double)1.0));
        BOUNDING_SHAPES.put(Direction.SOUTH, Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)0.5));
        BOUNDING_SHAPES.put(Direction.WEST, Shapes.box((double)0.5, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0));
        BOUNDING_SHAPES.put(Direction.EAST, Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)0.5, (double)1.0, (double)1.0));
    }
}

