/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.blocks;

import com.google.common.collect.Lists;
import de.ambertation.wunderlib.math.Float3;
import de.ambertation.wunderlib.ui.ColorHelper;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.particle.Particle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.models.blockstates.BlockStateGenerator;
import net.minecraft.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.data.models.blockstates.PropertyDispatch;
import net.minecraft.data.models.blockstates.Variant;
import net.minecraft.data.models.blockstates.VariantProperties;
import net.minecraft.data.models.model.ModelTemplate;
import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.betterx.bclib.behaviours.interfaces.BehaviourStone;
import org.betterx.bclib.interfaces.ClientLevelAccess;
import org.betterx.betterend.BetterEnd;
import org.betterx.betterend.blocks.EndBlockProperties;
import org.betterx.betterend.blocks.basis.PedestalBlock;
import org.betterx.betterend.blocks.entities.EternalPedestalEntity;
import org.betterx.betterend.client.models.EndModels;
import org.betterx.betterend.client.render.EternalCrystalRenderer;
import org.betterx.betterend.client.render.PedestalItemRenderer;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.betterend.registry.EndPortals;
import org.betterx.betterend.rituals.EternalRitual;
import org.betterx.wover.block.api.model.BlockModelProvider;
import org.betterx.wover.block.api.model.WoverBlockModelGenerators;
import org.jetbrains.annotations.NotNull;

public class EternalPedestal
extends PedestalBlock
implements BehaviourStone,
BlockModelProvider {
    public static final BooleanProperty ACTIVATED = EndBlockProperties.ACTIVE;

    public EternalPedestal() {
        super(EndBlocks.FLAVOLITE_RUNED_ETERNAL);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)ACTIVATED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public void checkRitual(Level sourceLevel, Player player, BlockPos pos) {
        BlockEntity blockEntity = sourceLevel.getBlockEntity(pos);
        if (blockEntity instanceof EternalPedestalEntity) {
            EternalPedestalEntity pedestal = (EternalPedestalEntity)blockEntity;
            BlockState updatedState = sourceLevel.getBlockState(pos);
            if (pedestal.isEmpty()) {
                EternalRitual ritual;
                if (pedestal.hasRitual() && (ritual = pedestal.getRitual()).isActive()) {
                    ResourceLocation targetWorld;
                    if (ritual.getWorld() == null) {
                        ritual.setWorld(sourceLevel);
                    }
                    int portalId = (targetWorld = ritual.getTargetWorldId()) != null ? EndPortals.getPortalIdByWorld(targetWorld) : EndPortals.getPortalIdByWorld(EndPortals.OVERWORLD_ID);
                    ritual.disablePortal(portalId);
                }
                sourceLevel.setBlockAndUpdate(pos, (BlockState)((BlockState)updatedState.setValue((Property)ACTIVATED, (Comparable)Boolean.valueOf(false))).setValue((Property)HAS_LIGHT, (Comparable)Boolean.valueOf(false)));
            } else {
                ItemStack itemStack = pedestal.getItem(0);
                ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem());
                if (EndPortals.isAvailableItem(id)) {
                    sourceLevel.setBlockAndUpdate(pos, (BlockState)((BlockState)updatedState.setValue((Property)ACTIVATED, (Comparable)Boolean.valueOf(true))).setValue((Property)HAS_LIGHT, (Comparable)Boolean.valueOf(true)));
                    if (pedestal.hasRitual()) {
                        if (pedestal.getRitual().getWorld() == null) {
                            pedestal.getRitual().setWorld(sourceLevel);
                        }
                        pedestal.getRitual().checkStructure(player);
                    } else {
                        EternalRitual ritual = new EternalRitual(sourceLevel, pos);
                        pedestal.linkRitual(ritual);
                        ritual.checkStructure(player);
                    }
                }
            }
        }
    }

    @Override
    @Deprecated
    @NotNull
    public BlockState updateShape(BlockState state, Direction direction, BlockState newState, LevelAccessor world, BlockPos pos, BlockPos posFrom) {
        BlockState updated = super.updateShape(state, direction, newState, world, pos, posFrom);
        if (!updated.is((Block)this)) {
            return updated;
        }
        if (!this.isPlaceable(updated)) {
            return (BlockState)updated.setValue((Property)ACTIVATED, (Comparable)Boolean.valueOf(false));
        }
        return updated;
    }

    @Deprecated
    public float getDestroyProgress(BlockState state, Player player, BlockGetter world, BlockPos pos) {
        return 0.0f;
    }

    public float getExplosionResistance() {
        return Blocks.BEDROCK.getExplosionResistance();
    }

    public boolean dropFromExplosion(Explosion explosion) {
        return false;
    }

    @Override
    @NotNull
    public List<ItemStack> getDrops(BlockState state, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull LootParams.Builder builder) {
        EternalPedestalEntity pedestal;
        EndBlockProperties.PedestalState currentState;
        if (state.is((Block)this) && ((currentState = (EndBlockProperties.PedestalState)((Object)state.getValue(EndBlockProperties.PEDESTAL_STATE))).equals((Object)EndBlockProperties.PedestalState.BOTTOM) || currentState.equals((Object)EndBlockProperties.PedestalState.PILLAR))) {
            return Lists.newArrayList();
        }
        ArrayList drop = Lists.newArrayList();
        BlockEntity blockEntity = (BlockEntity)builder.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (blockEntity instanceof EternalPedestalEntity && !(pedestal = (EternalPedestalEntity)blockEntity).isEmpty()) {
            drop.add(pedestal.getItem(0));
        }
        return drop;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateManager) {
        super.createBlockStateDefinition(stateManager);
        stateManager.add(new Property[]{ACTIVATED});
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new EternalPedestalEntity(blockPos, blockState);
    }

    @Override
    public boolean hasUniqueEntity() {
        return true;
    }

    @Environment(value=EnvType.CLIENT)
    private void dispatchParticles(Level level, BlockPos blockPos, RandomSource random) {
        if (level instanceof ClientLevelAccess) {
            EternalPedestalEntity pedestal;
            ClientLevelAccess clientLevel = (ClientLevelAccess)level;
            BlockEntity blockEntity = level.getBlockEntity(blockPos);
            if (blockEntity instanceof EternalPedestalEntity && (pedestal = (EternalPedestalEntity)blockEntity).hasRitual()) {
                BlockState state = level.getBlockState(blockPos);
                EternalRitual ritual = pedestal.getRitual();
                if (ritual != null && ritual.getCenter() != null && (ritual.isActive() || ritual.willActivate())) {
                    Particle particle;
                    SimpleParticleType particleOptions;
                    Float3 rnd;
                    int i;
                    boolean powerUp = ritual.willActivate();
                    boolean inX = ritual.getAxis() == Direction.Axis.X;
                    Float3 start = Float3.of((BlockPos)blockPos);
                    Float3 center = Float3.of((BlockPos)ritual.getCenter());
                    Float3 dir = center.sub(start).normalized().mul(powerUp ? 0.2 : 0.05);
                    float[] color = ColorHelper.toFloatArrayRGBA((int)EternalCrystalRenderer.colors(PedestalItemRenderer.getGemAge()));
                    if (powerUp) {
                        for (i = 0; i < 30; ++i) {
                            rnd = Float3.of((double)((double)random.nextFloat() * 0.3 - 0.15), (double)((double)random.nextFloat() * -0.1), (double)((double)random.nextFloat() * 0.3 - 0.15)).sub(dir);
                            particleOptions = ParticleTypes.GLOW;
                            particle = clientLevel.bcl_addParticle((ParticleOptions)particleOptions, center.x + (inX ? 0.0 : (double)(random.nextFloat() * 3.0f) - 1.5), center.y + 1.0 + (double)(random.nextFloat() * 3.0f), center.z + (inX ? (double)(random.nextFloat() * 3.0f) - 1.5 : 0.0), 0.0, 0.0, 0.0);
                            if (particle == null) continue;
                            particle.setColor(color[0], color[1], color[2]);
                            particle.setParticleSpeed(rnd.x, rnd.y, rnd.z);
                        }
                    }
                    for (i = 0; i < random.nextInt(powerUp ? 20 : 2, powerUp ? 40 : 10); ++i) {
                        rnd = Float3.of((double)((double)random.nextFloat() * 0.3 - 0.15), (double)((double)random.nextFloat() * -0.1), (double)((double)random.nextFloat() * 0.3 - 0.15)).add(dir.mul(powerUp ? (double)(random.nextFloat() * 4.0f) : 1.0));
                        particleOptions = ParticleTypes.EFFECT;
                        particle = clientLevel.bcl_addParticle((ParticleOptions)particleOptions, start.x + 0.3 + (double)random.nextFloat() * 0.4, start.y + 1.0 + (double)random.nextFloat() * 0.7, start.z + 0.3 + (double)random.nextFloat() * 0.4, 0.0, 0.0, 0.0);
                        if (particle == null) continue;
                        particle.setColor(color[0], color[1], color[2]);
                        particle.setParticleSpeed(rnd.x, rnd.y, rnd.z);
                        if (!powerUp) continue;
                        particle.setLifetime(6 + random.nextInt(4));
                    }
                }
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void animateTick(@NotNull BlockState blockState, @NotNull Level level, @NotNull BlockPos blockPos, @NotNull RandomSource randomSource) {
        super.animateTick(blockState, level, blockPos, randomSource);
        this.dispatchParticles(level, blockPos, randomSource);
    }

    private static List<Variant> createVariants(WoverBlockModelGenerators generator, TextureMapping mapping, ResourceLocation modelLocation, ModelTemplate template, ResourceLocation textureLocation, int count) {
        ArrayList<Variant> variants = new ArrayList<Variant>(count);
        for (int i = 0; i < count; ++i) {
            ResourceLocation topTexture = textureLocation.withSuffix("_" + (i + 1));
            mapping.put(TextureSlot.TOP, topTexture);
            variants.add(Variant.variant().with(VariantProperties.MODEL, (Object)template.create(modelLocation.withSuffix("_" + (i + 1)), mapping, generator.modelOutput())));
        }
        return variants;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void provideBlockModels(WoverBlockModelGenerators generator) {
        ResourceLocation id = TextureMapping.getBlockTexture((Block)this);
        ResourceLocation baseTexture = BetterEnd.C.mk("block/flavolite_polished");
        ResourceLocation pillarTexture = BetterEnd.C.mk("block/flavolite_pillar_side");
        TextureMapping mapping = new TextureMapping().put(EndModels.BASE, baseTexture).put(TextureSlot.BOTTOM, baseTexture).put(EndModels.PILLAR, pillarTexture);
        ResourceLocation column = EndModels.PEDESTAL_COLUMN.create(id.withSuffix("_column"), mapping, generator.modelOutput());
        ResourceLocation top = EndModels.PEDESTAL_COLUMN_TOP.create(id.withSuffix("_column_top"), mapping, generator.modelOutput());
        ResourceLocation bottom = EndModels.PEDESTAL_BOTTOM.create(id.withSuffix("_bottom"), mapping, generator.modelOutput());
        ResourceLocation pillar = EndModels.PEDESTAL_PILLAR.create(id.withSuffix("_pillar"), mapping, generator.modelOutput());
        PropertyDispatch.C2 properties = PropertyDispatch.properties((Property)STATE, (Property)ACTIVATED).select((Comparable)((Object)EndBlockProperties.PedestalState.DEFAULT), (Comparable)Boolean.valueOf(false), EternalPedestal.createVariants(generator, mapping, id.withSuffix("_default"), EndModels.PEDESTAL_DEFAULT, BetterEnd.C.mk("block/flavolite_runed"), 7)).select((Comparable)((Object)EndBlockProperties.PedestalState.DEFAULT), (Comparable)Boolean.valueOf(true), EternalPedestal.createVariants(generator, mapping, id.withSuffix("_default_active"), EndModels.PEDESTAL_DEFAULT, BetterEnd.C.mk("block/flavolite_runed_active"), 7)).select((Comparable)((Object)EndBlockProperties.PedestalState.PEDESTAL_TOP), (Comparable)Boolean.valueOf(false), EternalPedestal.createVariants(generator, mapping, id.withSuffix("_top"), EndModels.PEDESTAL_TOP, BetterEnd.C.mk("block/flavolite_runed"), 7)).select((Comparable)((Object)EndBlockProperties.PedestalState.PEDESTAL_TOP), (Comparable)Boolean.valueOf(true), EternalPedestal.createVariants(generator, mapping, id.withSuffix("_top_active"), EndModels.PEDESTAL_TOP, BetterEnd.C.mk("block/flavolite_runed_active"), 7)).select((Comparable)((Object)EndBlockProperties.PedestalState.COLUMN), (Comparable)Boolean.valueOf(true), Variant.variant().with(VariantProperties.MODEL, (Object)column)).select((Comparable)((Object)EndBlockProperties.PedestalState.COLUMN), (Comparable)Boolean.valueOf(false), Variant.variant().with(VariantProperties.MODEL, (Object)column)).select((Comparable)((Object)EndBlockProperties.PedestalState.COLUMN_TOP), (Comparable)Boolean.valueOf(true), Variant.variant().with(VariantProperties.MODEL, (Object)top)).select((Comparable)((Object)EndBlockProperties.PedestalState.COLUMN_TOP), (Comparable)Boolean.valueOf(false), Variant.variant().with(VariantProperties.MODEL, (Object)top)).select((Comparable)((Object)EndBlockProperties.PedestalState.BOTTOM), (Comparable)Boolean.valueOf(true), Variant.variant().with(VariantProperties.MODEL, (Object)bottom)).select((Comparable)((Object)EndBlockProperties.PedestalState.BOTTOM), (Comparable)Boolean.valueOf(false), Variant.variant().with(VariantProperties.MODEL, (Object)bottom)).select((Comparable)((Object)EndBlockProperties.PedestalState.PILLAR), (Comparable)Boolean.valueOf(true), Variant.variant().with(VariantProperties.MODEL, (Object)pillar)).select((Comparable)((Object)EndBlockProperties.PedestalState.PILLAR), (Comparable)Boolean.valueOf(false), Variant.variant().with(VariantProperties.MODEL, (Object)pillar));
        generator.acceptBlockState((BlockStateGenerator)MultiVariantGenerator.multiVariant((Block)this).with((PropertyDispatch)properties));
        generator.delegateItemModel((Block)this, id.withSuffix("_default_1"));
    }
}

