/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import org.betterx.bclib.behaviours.interfaces.BehaviourWaterPlantSeed;
import org.betterx.bclib.blocks.UnderwaterPlantWithAgeBlock;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.betterend.blocks.EndLotusLeafBlock;
import org.betterx.betterend.blocks.EndLotusStemBlock;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.wover.block.api.BlockProperties;
import org.betterx.wover.tag.api.predefined.CommonBlockTags;

public class EndLotusSeedBlock
extends UnderwaterPlantWithAgeBlock
implements BehaviourWaterPlantSeed {
    public void grow(WorldGenLevel world, RandomSource random, BlockPos pos) {
        if (this.canGrow(world, pos)) {
            BlockState startLeaf = (BlockState)EndBlocks.END_LOTUS_STEM.defaultBlockState().setValue((Property)EndLotusStemBlock.LEAF, (Comparable)Boolean.valueOf(true));
            BlockState roots = (BlockState)((BlockState)EndBlocks.END_LOTUS_STEM.defaultBlockState().setValue(EndLotusStemBlock.SHAPE, (Comparable)BlockProperties.TripleShape.BOTTOM)).setValue((Property)EndLotusStemBlock.WATERLOGGED, (Comparable)Boolean.valueOf(true));
            BlockState stem = EndBlocks.END_LOTUS_STEM.defaultBlockState();
            BlockState flower = EndBlocks.END_LOTUS_FLOWER.defaultBlockState();
            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)pos, (BlockState)roots);
            BlockPos.MutableBlockPos bpos = new BlockPos.MutableBlockPos().set((Vec3i)pos);
            bpos.setY(bpos.getY() + 1);
            while (world.getFluidState((BlockPos)bpos).isSource()) {
                BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)bpos, (BlockState)((BlockState)stem.setValue((Property)EndLotusStemBlock.WATERLOGGED, (Comparable)Boolean.valueOf(true))));
                bpos.setY(bpos.getY() + 1);
            }
            int height = random.nextBoolean() ? 0 : (random.nextBoolean() ? 1 : (random.nextBoolean() ? 1 : -1));
            BlockProperties.TripleShape shape = height == 0 ? BlockProperties.TripleShape.TOP : BlockProperties.TripleShape.MIDDLE;
            Direction dir = BlocksHelper.randomHorizontal((RandomSource)random);
            BlockPos leafCenter = bpos.immutable().relative(dir);
            if (this.hasLeaf(world, leafCenter)) {
                this.generateLeaf(world, leafCenter);
                BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)bpos, (BlockState)((BlockState)((BlockState)startLeaf.setValue(EndLotusStemBlock.SHAPE, (Comparable)shape)).setValue(EndLotusStemBlock.FACING, (Comparable)dir)));
            } else {
                BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)bpos, (BlockState)((BlockState)stem.setValue(EndLotusStemBlock.SHAPE, (Comparable)shape)));
            }
            bpos.setY(bpos.getY() + 1);
            for (int i = 1; i <= height; ++i) {
                if (!world.isEmptyBlock((BlockPos)bpos)) {
                    bpos.setY(bpos.getY() - 1);
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)bpos, (BlockState)flower);
                    bpos.setY(bpos.getY() - 1);
                    stem = world.getBlockState((BlockPos)bpos);
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)bpos, (BlockState)((BlockState)stem.setValue(EndLotusStemBlock.SHAPE, (Comparable)BlockProperties.TripleShape.TOP)));
                    return;
                }
                BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)bpos, (BlockState)stem);
                bpos.setY(bpos.getY() + 1);
            }
            if (!world.isEmptyBlock((BlockPos)bpos) || height < 0) {
                bpos.setY(bpos.getY() - 1);
            }
            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)bpos, (BlockState)flower);
            bpos.setY(bpos.getY() - 1);
            stem = world.getBlockState((BlockPos)bpos);
            if (!stem.is(EndBlocks.END_LOTUS_STEM)) {
                stem = EndBlocks.END_LOTUS_STEM.defaultBlockState();
                if (!world.getBlockState(bpos.north()).getFluidState().isEmpty()) {
                    stem = (BlockState)stem.setValue((Property)EndLotusStemBlock.WATERLOGGED, (Comparable)Boolean.valueOf(true));
                }
            }
            if (world.getBlockState(bpos.relative(dir)).is(EndBlocks.END_LOTUS_LEAF)) {
                stem = (BlockState)((BlockState)stem.setValue((Property)EndLotusStemBlock.LEAF, (Comparable)Boolean.valueOf(true))).setValue(EndLotusStemBlock.FACING, (Comparable)dir);
            }
            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)bpos, (BlockState)((BlockState)stem.setValue(EndLotusStemBlock.SHAPE, (Comparable)BlockProperties.TripleShape.TOP)));
        }
    }

    private boolean canGrow(WorldGenLevel world, BlockPos pos) {
        BlockPos.MutableBlockPos bpos = new BlockPos.MutableBlockPos();
        bpos.set((Vec3i)pos);
        while (world.getBlockState((BlockPos)bpos).getFluidState().getType().equals(Fluids.WATER.getSource())) {
            bpos.setY(bpos.getY() + 1);
        }
        return world.isEmptyBlock((BlockPos)bpos) && world.isEmptyBlock(bpos.above());
    }

    private void generateLeaf(WorldGenLevel world, BlockPos pos) {
        BlockPos.MutableBlockPos p = new BlockPos.MutableBlockPos();
        BlockState leaf = EndBlocks.END_LOTUS_LEAF.defaultBlockState();
        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)pos, (BlockState)((BlockState)leaf.setValue(EndLotusLeafBlock.SHAPE, (Comparable)BlockProperties.TripleShape.BOTTOM)));
        for (Direction move : BlocksHelper.HORIZONTAL) {
            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)p.set((Vec3i)pos).move(move), (BlockState)((BlockState)((BlockState)leaf.setValue(EndLotusLeafBlock.HORIZONTAL_FACING, (Comparable)move)).setValue(EndLotusLeafBlock.SHAPE, (Comparable)BlockProperties.TripleShape.MIDDLE)));
        }
        for (int i = 0; i < 4; ++i) {
            Direction d1 = BlocksHelper.HORIZONTAL[i];
            Direction d2 = BlocksHelper.HORIZONTAL[i + 1 & 3];
            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)p.set((Vec3i)pos).move(d1).move(d2), (BlockState)((BlockState)((BlockState)leaf.setValue(EndLotusLeafBlock.HORIZONTAL_FACING, (Comparable)d1)).setValue(EndLotusLeafBlock.SHAPE, (Comparable)BlockProperties.TripleShape.TOP)));
        }
    }

    private boolean hasLeaf(WorldGenLevel world, BlockPos pos) {
        BlockPos.MutableBlockPos p = new BlockPos.MutableBlockPos();
        p.setY(pos.getY());
        int count = 0;
        for (int x = -1; x < 2; ++x) {
            p.setX(pos.getX() + x);
            for (int z = -1; z < 2; ++z) {
                p.setZ(pos.getZ() + z);
                if (!world.isEmptyBlock((BlockPos)p) || world.getFluidState(p.below()).isEmpty()) continue;
                ++count;
            }
        }
        return count == 9;
    }

    protected boolean isTerrain(BlockState state) {
        return state.is(CommonBlockTags.END_STONES);
    }
}

